/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.SideInputHandler;
import org.apache.beam.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.runners.fnexecution.control.ProcessBundleDescriptors;
import org.apache.beam.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.runners.fnexecution.state.StateRequestHandlers;
import org.apache.beam.runners.fnexecution.translation.StreamingSideInputHandlerFactory;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class SamzaStateRequestHandlers {
    public static StateRequestHandler of(ExecutableStage executableStage, Map<RunnerApi.ExecutableStagePayload.SideInputId, PCollectionView<?>> sideInputIds, SideInputHandler sideInputHandler) {
        StateRequestHandler sideInputStateHandler;
        if (executableStage.getSideInputs().size() > 0) {
            StateRequestHandlers.SideInputHandlerFactory sideInputHandlerFactory = (StateRequestHandlers.SideInputHandlerFactory)Preconditions.checkNotNull((Object)StreamingSideInputHandlerFactory.forStage((ExecutableStage)executableStage, sideInputIds, (SideInputHandler)sideInputHandler));
            try {
                sideInputStateHandler = StateRequestHandlers.forSideInputHandlerFactory((Map)ProcessBundleDescriptors.getSideInputs((ExecutableStage)executableStage), (StateRequestHandlers.SideInputHandlerFactory)sideInputHandlerFactory);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to initialize SideInputHandler", e);
            }
        } else {
            sideInputStateHandler = StateRequestHandler.unsupported();
        }
        EnumMap<BeamFnApi.StateKey.TypeCase, StateRequestHandler> handlerMap = new EnumMap<BeamFnApi.StateKey.TypeCase, StateRequestHandler>(BeamFnApi.StateKey.TypeCase.class);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.ITERABLE_SIDE_INPUT, sideInputStateHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.MULTIMAP_SIDE_INPUT, sideInputStateHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.MULTIMAP_KEYS_SIDE_INPUT, sideInputStateHandler);
        return StateRequestHandlers.delegateBasedUponType(handlerMap);
    }
}

