/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.runners.samza.runtime.OpAdapter;
import org.apache.beam.runners.samza.runtime.WindowAssignOp;
import org.apache.beam.runners.samza.translation.PortableTranslationContext;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.samza.operators.MessageStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class WindowAssignTranslator<@UnknownKeyFor T>
implements TransformTranslator<Window.Assign<T>> {
    WindowAssignTranslator() {
    }

    @Override
    public void translate(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Window.Assign<T> transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, @UnknownKeyFor @NonNull @Initialized TranslationContext ctx) {
        PCollection output = (PCollection)ctx.getOutput(transform);
        WindowFn windowFn = output.getWindowingStrategy().getWindowFn();
        MessageStream inputStream = ctx.getMessageStream((PValue)ctx.getInput(transform));
        MessageStream outputStream = inputStream.flatMapAsync(OpAdapter.adapt(new WindowAssignOp(windowFn)));
        ctx.registerMessageStream((PValue)output, outputStream);
    }

    @Override
    public void translatePortable(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline, @UnknownKeyFor @NonNull @Initialized PortableTranslationContext ctx) {
        RunnerApi.WindowIntoPayload payload;
        try {
            payload = RunnerApi.WindowIntoPayload.parseFrom((ByteString)transform.getTransform().getSpec().getPayload());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(String.format("failed to parse WindowIntoPayload: %s", transform.getId()), e);
        }
        WindowFn windowFn = WindowingStrategyTranslation.windowFnFromProto((RunnerApi.FunctionSpec)payload.getWindowFn());
        MessageStream inputStream = ctx.getOneInputMessageStream(transform);
        MessageStream outputStream = inputStream.flatMapAsync(OpAdapter.adapt(new WindowAssignOp(windowFn)));
        ctx.registerMessageStream(ctx.getOutputId(transform), outputStream);
    }
}

