/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.beam.runners.samza.runtime.KeyedTimerData;
import org.apache.beam.runners.samza.runtime.Op;
import org.apache.beam.runners.samza.runtime.OpEmitter;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.samza.config.Config;
import org.apache.samza.context.Context;
import org.apache.samza.operators.Scheduler;
import org.apache.samza.operators.functions.FlatMapFunction;
import org.apache.samza.operators.functions.ScheduledFunction;
import org.apache.samza.operators.functions.WatermarkFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpAdapter<@UnknownKeyFor InT, @UnknownKeyFor OutT, @UnknownKeyFor K>
implements FlatMapFunction<OpMessage<InT>, OpMessage<OutT>>,
WatermarkFunction<OpMessage<OutT>>,
ScheduledFunction<KeyedTimerData<K>, OpMessage<OutT>>,
Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(OpAdapter.class);
    private final @UnknownKeyFor @NonNull @Initialized Op<InT, OutT, K> op;
    private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OpMessage<OutT>> outputList;
    private transient @UnknownKeyFor @NonNull @Initialized Instant outputWatermark;
    private transient @UnknownKeyFor @NonNull @Initialized OpEmitter<OutT> emitter;
    private transient @UnknownKeyFor @NonNull @Initialized Config config;
    private transient @UnknownKeyFor @NonNull @Initialized Context context;

    public static <InT, OutT, K> @UnknownKeyFor @NonNull @Initialized FlatMapFunction<@UnknownKeyFor @NonNull @Initialized OpMessage<InT>, @UnknownKeyFor @NonNull @Initialized OpMessage<OutT>> adapt(@UnknownKeyFor @NonNull @Initialized Op<InT, OutT, K> op) {
        return new OpAdapter<InT, OutT, K>(op);
    }

    private OpAdapter(@UnknownKeyFor @NonNull @Initialized Op<InT, OutT, K> op) {
        this.op = op;
    }

    public final void init(@UnknownKeyFor @NonNull @Initialized Context context) {
        this.outputList = new ArrayList<OpMessage<OutT>>();
        this.emitter = new OpEmitterImpl();
        this.config = context.getJobContext().getConfig();
        this.context = context;
    }

    public final void schedule(@UnknownKeyFor @NonNull @Initialized Scheduler<@UnknownKeyFor @NonNull @Initialized KeyedTimerData<K>> timerRegistry) {
        assert (this.context != null);
        this.op.open(this.config, this.context, timerRegistry, this.emitter);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized OpMessage<OutT>> apply(@UnknownKeyFor @NonNull @Initialized OpMessage<InT> message) {
        assert (this.outputList.isEmpty());
        try {
            switch (message.getType()) {
                case ELEMENT: {
                    this.op.processElement(message.getElement(), this.emitter);
                    break;
                }
                case SIDE_INPUT: {
                    this.op.processSideInput(message.getViewId(), message.getViewElements(), this.emitter);
                    break;
                }
                case SIDE_INPUT_WATERMARK: {
                    this.op.processSideInputWatermark(message.getSideInputWatermark(), this.emitter);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unexpected input type: %s", new Object[]{message.getType()}));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Op {} threw an exception during processing", (Object)this.getClass().getName(), (Object)e);
            throw UserCodeException.wrap((Throwable)e);
        }
        ArrayList<OpMessage<OutT>> results = new ArrayList<OpMessage<OutT>>(this.outputList);
        this.outputList.clear();
        return results;
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized OpMessage<OutT>> processWatermark(@UnknownKeyFor @NonNull @Initialized long time) {
        assert (this.outputList.isEmpty());
        try {
            this.op.processWatermark(new Instant(time), this.emitter);
        }
        catch (Exception e) {
            LOG.error("Op {} threw an exception during processing watermark", (Object)this.getClass().getName(), (Object)e);
            throw UserCodeException.wrap((Throwable)e);
        }
        ArrayList<OpMessage<OutT>> results = new ArrayList<OpMessage<OutT>>(this.outputList);
        this.outputList.clear();
        return results;
    }

    public @UnknownKeyFor @NonNull @Initialized Long getOutputWatermark() {
        return this.outputWatermark != null ? Long.valueOf(this.outputWatermark.getMillis()) : null;
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized OpMessage<OutT>> onCallback(@UnknownKeyFor @NonNull @Initialized KeyedTimerData<K> keyedTimerData, @UnknownKeyFor @NonNull @Initialized long time) {
        assert (this.outputList.isEmpty());
        try {
            this.op.processTimer(keyedTimerData, this.emitter);
        }
        catch (Exception e) {
            LOG.error("Op {} threw an exception during processing timer", (Object)this.getClass().getName(), (Object)e);
            throw UserCodeException.wrap((Throwable)e);
        }
        ArrayList<OpMessage<OutT>> results = new ArrayList<OpMessage<OutT>>(this.outputList);
        this.outputList.clear();
        return results;
    }

    public void close() {
        this.op.close();
    }

    private class OpEmitterImpl
    implements OpEmitter<OutT> {
        private OpEmitterImpl() {
        }

        @Override
        public void emitElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<OutT> element) {
            OpAdapter.this.outputList.add(OpMessage.ofElement(element));
        }

        @Override
        public void emitWatermark(@UnknownKeyFor @NonNull @Initialized Instant watermark) {
            OpAdapter.this.outputWatermark = watermark;
        }

        @Override
        public <T> void emitView(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized Iterable<T>> elements) {
            OpAdapter.this.outputList.add(OpMessage.ofSideInput(id, elements));
        }
    }
}

