/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.metrics;

import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.samza.metrics.FnWithMetricsWrapper;
import org.apache.beam.runners.samza.metrics.SamzaMetricsContainer;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class DoFnRunnerWithMetrics<@UnknownKeyFor InT, @UnknownKeyFor OutT>
implements DoFnRunner<InT, OutT> {
    private final @UnknownKeyFor @NonNull @Initialized DoFnRunner<InT, OutT> underlying;
    private final @UnknownKeyFor @NonNull @Initialized SamzaMetricsContainer metricsContainer;
    private final @UnknownKeyFor @NonNull @Initialized FnWithMetricsWrapper metricsWrapper;

    private DoFnRunnerWithMetrics(@UnknownKeyFor @NonNull @Initialized DoFnRunner<InT, OutT> underlying, @UnknownKeyFor @NonNull @Initialized SamzaMetricsContainer metricsContainer, @UnknownKeyFor @NonNull @Initialized String stepName) {
        this.underlying = underlying;
        this.metricsContainer = metricsContainer;
        this.metricsWrapper = new FnWithMetricsWrapper(metricsContainer, stepName);
    }

    public static <InT, OutT> @UnknownKeyFor @NonNull @Initialized DoFnRunner<InT, OutT> wrap(@UnknownKeyFor @NonNull @Initialized DoFnRunner<InT, OutT> doFnRunner, @UnknownKeyFor @NonNull @Initialized SamzaMetricsContainer metricsContainer, @UnknownKeyFor @NonNull @Initialized String stepName) {
        return new DoFnRunnerWithMetrics<InT, OutT>(doFnRunner, metricsContainer, stepName);
    }

    public void startBundle() {
        this.withMetrics(() -> this.underlying.startBundle(), false);
    }

    public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<InT> elem) {
        this.withMetrics(() -> this.underlying.processElement(elem), false);
    }

    public <KeyT> void onTimer(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        this.withMetrics(() -> this.underlying.onTimer(timerId, timerFamilyId, key, window, timestamp, outputTimestamp, timeDomain), false);
    }

    public void finishBundle() {
        this.withMetrics(() -> this.underlying.finishBundle(), true);
    }

    public <KeyT> void onWindowExpiration(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, KeyT key) {
        this.underlying.onWindowExpiration(window, timestamp, key);
    }

    public @UnknownKeyFor @NonNull @Initialized DoFn<InT, OutT> getFn() {
        return this.underlying.getFn();
    }

    private void withMetrics(@UnknownKeyFor @NonNull @Initialized Runnable runnable, @UnknownKeyFor @NonNull @Initialized boolean shouldUpdateMetrics) {
        try {
            this.metricsWrapper.wrap(() -> {
                runnable.run();
                return null;
            }, shouldUpdateMetrics);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

