/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.util;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashIdGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(HashIdGenerator.class);
    private static final int DEFAULT_MAX_HASH_LENGTH = 5;
    private final int maxHashLength;
    private final Set<String> usedIds = new HashSet<String>();

    public HashIdGenerator(int maxHashLength) {
        this.maxHashLength = maxHashLength;
    }

    public HashIdGenerator() {
        this(5);
    }

    public String getId(String name) {
        String origId;
        if (name.length() <= this.maxHashLength && this.usedIds.add(name)) {
            return name;
        }
        String hexString = Integer.toHexString(name.hashCode());
        String id = origId = hexString.length() <= this.maxHashLength ? hexString : hexString.substring(Math.max(0, hexString.length() - this.maxHashLength));
        int suffixNum = 2;
        while (!this.usedIds.add(id)) {
            id = origId + "-" + suffixNum++;
        }
        LOG.info("Name {} is mapped to id {}", (Object)name, (Object)id);
        return id;
    }
}

