/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.runners.samza.translation.PortableTranslationContext;
import org.apache.beam.runners.samza.translation.SamzaImpulseSystemFactory;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.GenericInputDescriptor;
import org.apache.samza.system.descriptors.GenericSystemDescriptor;

public class ImpulseTranslator
implements TransformTranslator<PTransform<PBegin, PCollection<byte[]>>> {
    @Override
    public void translate(PTransform<PBegin, PCollection<byte[]>> transform, TransformHierarchy.Node node, TranslationContext ctx) {
        PCollection<byte[]> output = ctx.getOutput(transform);
        String outputId = ctx.getIdForPValue((PValue)output);
        GenericSystemDescriptor systemDescriptor = new GenericSystemDescriptor(outputId, SamzaImpulseSystemFactory.class.getName());
        KVSerde kvSerde = KVSerde.of((Serde)new NoOpSerde(), (Serde)new NoOpSerde());
        GenericInputDescriptor inputDescriptor = systemDescriptor.getInputDescriptor(outputId, (Serde)kvSerde);
        ctx.registerInputMessageStream((PValue)output, inputDescriptor);
    }

    @Override
    public void translatePortable(PipelineNode.PTransformNode transform, QueryablePipeline pipeline, PortableTranslationContext ctx) {
        String outputId = ctx.getOutputId(transform);
        GenericSystemDescriptor systemDescriptor = new GenericSystemDescriptor(outputId, SamzaImpulseSystemFactory.class.getName());
        KVSerde kvSerde = KVSerde.of((Serde)new NoOpSerde(), (Serde)new NoOpSerde());
        GenericInputDescriptor inputDescriptor = systemDescriptor.getInputDescriptor(outputId, (Serde)kvSerde);
        ctx.registerInputMessageStream(outputId, inputDescriptor);
    }
}

