/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.metrics;

import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.samza.metrics.FnWithMetricsWrapper;
import org.apache.beam.runners.samza.metrics.SamzaMetricsContainer;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.joda.time.Instant;

public class DoFnRunnerWithMetrics<InT, OutT>
implements DoFnRunner<InT, OutT> {
    private final DoFnRunner<InT, OutT> underlying;
    private final SamzaMetricsContainer metricsContainer;
    private final FnWithMetricsWrapper metricsWrapper;

    private DoFnRunnerWithMetrics(DoFnRunner<InT, OutT> underlying, SamzaMetricsContainer metricsContainer, String stepName) {
        this.underlying = underlying;
        this.metricsContainer = metricsContainer;
        this.metricsWrapper = new FnWithMetricsWrapper(metricsContainer, stepName);
    }

    public static <InT, OutT> DoFnRunner<InT, OutT> wrap(DoFnRunner<InT, OutT> doFnRunner, SamzaMetricsContainer metricsContainer, String stepName) {
        return new DoFnRunnerWithMetrics<InT, OutT>(doFnRunner, metricsContainer, stepName);
    }

    public void startBundle() {
        this.withMetrics(() -> this.underlying.startBundle(), false);
    }

    public void processElement(WindowedValue<InT> elem) {
        this.withMetrics(() -> this.underlying.processElement(elem), false);
    }

    public void onTimer(String timerId, String timerFamilyId, BoundedWindow window, Instant timestamp, Instant outputTimestamp, TimeDomain timeDomain) {
        this.withMetrics(() -> this.underlying.onTimer(timerId, timerFamilyId, window, timestamp, outputTimestamp, timeDomain), false);
    }

    public void finishBundle() {
        this.withMetrics(() -> this.underlying.finishBundle(), true);
    }

    public DoFn<InT, OutT> getFn() {
        return this.underlying.getFn();
    }

    private void withMetrics(Runnable runnable, boolean shouldUpdateMetrics) {
        try {
            this.metricsWrapper.wrap(() -> {
                runnable.run();
                return null;
            }, shouldUpdateMetrics);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

