/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.container;

import java.time.Duration;
import org.apache.beam.runners.samza.container.ContainerCfgFactory;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.application.descriptors.ApplicationDescriptorUtil;
import org.apache.samza.config.Config;
import org.apache.samza.config.ShellCommandConfig;
import org.apache.samza.context.ExternalContext;
import org.apache.samza.job.ApplicationStatus;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ContainerLaunchUtil;
import org.apache.samza.util.SamzaUncaughtExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamContainerRunner
implements ApplicationRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerCfgFactory.class);
    private final ApplicationDescriptorImpl<? extends ApplicationDescriptor> appDesc;

    public BeamContainerRunner(SamzaApplication app, Config config) {
        this.appDesc = ApplicationDescriptorUtil.getAppDescriptor((SamzaApplication)app, (Config)config);
    }

    public void run(ExternalContext externalContext) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new SamzaUncaughtExceptionHandler(() -> {
            LOG.info("Exiting process now.");
            System.exit(1);
        }));
        ContainerLaunchUtil.run(this.appDesc, (String)System.getenv(ShellCommandConfig.ENV_CONTAINER_ID()), (JobModel)ContainerCfgFactory.jobModel);
    }

    public void kill() {
    }

    public ApplicationStatus status() {
        return ApplicationStatus.Running;
    }

    public void waitForFinish() {
        LOG.info("Container has stopped");
    }

    public boolean waitForFinish(Duration timeout) {
        LOG.info("Container has stopped");
        return true;
    }
}

