/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.runners.fnexecution.wire.WireCoders;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;

public class PortableTranslationContext {
    private final Map<String, MessageStream<?>> messsageStreams = new HashMap();
    private final StreamApplicationDescriptor appDescriptor;
    private final SamzaPipelineOptions options;
    private int topologicalId;
    private final Set<String> registeredInputStreams = new HashSet<String>();

    public PortableTranslationContext(StreamApplicationDescriptor appDescriptor, SamzaPipelineOptions options) {
        this.appDescriptor = appDescriptor;
        this.options = options;
    }

    public SamzaPipelineOptions getSamzaPipelineOptions() {
        return this.options;
    }

    public void setCurrentTopologicalId(int id) {
        this.topologicalId = id;
    }

    public int getCurrentTopologicalId() {
        return this.topologicalId;
    }

    public <T> List<MessageStream<OpMessage<T>>> getAllInputMessageStreams(PipelineNode.PTransformNode transform) {
        Collection inputStreamIds = transform.getTransform().getInputsMap().values();
        return inputStreamIds.stream().map(this::getMessageStreamById).collect(Collectors.toList());
    }

    public <T> MessageStream<OpMessage<T>> getOneInputMessageStream(PipelineNode.PTransformNode transform) {
        String id = (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
        return this.getMessageStreamById(id);
    }

    public <T> MessageStream<OpMessage<T>> getMessageStreamById(String id) {
        return this.messsageStreams.get(id);
    }

    public String getInputId(PipelineNode.PTransformNode transform) {
        return (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
    }

    public String getOutputId(PipelineNode.PTransformNode transform) {
        return (String)Iterables.getOnlyElement(transform.getTransform().getOutputsMap().values());
    }

    public <T> void registerMessageStream(String id, MessageStream<OpMessage<T>> stream) {
        if (this.messsageStreams.containsKey(id)) {
            throw new IllegalArgumentException("Stream already registered for id: " + id);
        }
        this.messsageStreams.put(id, stream);
    }

    public <OutT> OutputStream<OutT> getOutputStream(OutputDescriptor<OutT, ?> outputDescriptor) {
        return this.appDescriptor.getOutputStream(outputDescriptor);
    }

    public <T> void registerInputMessageStream(String id, InputDescriptor<KV<?, OpMessage<T>>, ?> inputDescriptor) {
        String streamId = inputDescriptor.getStreamId();
        if (this.registeredInputStreams.contains(streamId)) {
            return;
        }
        MessageStream stream = this.appDescriptor.getInputStream(inputDescriptor).map(KV::getValue);
        this.registerMessageStream(id, stream);
        this.registeredInputStreams.add(streamId);
    }

    public WindowedValue.WindowedValueCoder instantiateCoder(String collectionId, RunnerApi.Components components) {
        PipelineNode.PCollectionNode collectionNode = PipelineNode.pCollection((String)collectionId, (RunnerApi.PCollection)components.getPcollectionsOrThrow(collectionId));
        try {
            return (WindowedValue.WindowedValueCoder)WireCoders.instantiateRunnerWireCoder((PipelineNode.PCollectionNode)collectionNode, (RunnerApi.Components)components);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public WindowingStrategy<?, BoundedWindow> getPortableWindowStrategy(PipelineNode.PTransformNode transform, QueryablePipeline pipeline) {
        WindowingStrategy windowingStrategy;
        String inputId = (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)pipeline.getComponents());
        RunnerApi.WindowingStrategy windowingStrategyProto = pipeline.getComponents().getWindowingStrategiesOrThrow(pipeline.getComponents().getPcollectionsOrThrow(inputId).getWindowingStrategyId());
        try {
            windowingStrategy = WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)windowingStrategyProto, (RehydratedComponents)rehydratedComponents);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to hydrate GroupByKey windowing strategy %s.", windowingStrategyProto), e);
        }
        WindowingStrategy ret = windowingStrategy;
        return ret;
    }
}

