/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Map;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

public class ConfigContext {
    private final Map<PValue, String> idMap;
    private AppliedPTransform<?, ?, ?> currentTransform;
    private final SamzaPipelineOptions options;

    public ConfigContext(Map<PValue, String> idMap, SamzaPipelineOptions options) {
        this.idMap = idMap;
        this.options = options;
    }

    public void setCurrentTransform(AppliedPTransform<?, ?, ?> currentTransform) {
        this.currentTransform = currentTransform;
    }

    public void clearCurrentTransform() {
        this.currentTransform = null;
    }

    public <OutT extends PValue> OutT getOutput(PTransform<?, OutT> transform) {
        return (OutT)((PValue)Iterables.getOnlyElement(this.currentTransform.getOutputs().values()));
    }

    public String getOutputId(TransformHierarchy.Node node) {
        return this.getIdForPValue((PValue)Iterables.getOnlyElement(node.getOutputs().values()));
    }

    public SamzaPipelineOptions getPipelineOptions() {
        return this.options;
    }

    private String getIdForPValue(PValue pvalue) {
        String id = this.idMap.get(pvalue);
        if (id == null) {
            throw new IllegalArgumentException("No id mapping for value: " + pvalue);
        }
        return id;
    }
}

