/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.runners.samza.translation.PortableTranslationContext;
import org.apache.beam.runners.samza.translation.SamzaImpulseSystemFactory;
import org.apache.beam.runners.samza.translation.TransformConfigGenerator;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

public class ImpulseTranslator
implements TransformTranslator,
TransformConfigGenerator {
    @Override
    public void translatePortable(PipelineNode.PTransformNode transform, QueryablePipeline pipeline, PortableTranslationContext ctx) {
        String outputId = ctx.getOutputId(transform);
        ctx.registerInputMessageStream(outputId);
    }

    @Override
    public Map<String, String> createPortableConfig(PipelineNode.PTransformNode transform) {
        String id = (String)Iterables.getOnlyElement(transform.getTransform().getOutputsMap().values());
        HashMap<String, String> config = new HashMap<String, String>();
        String systemPrefix = "systems." + id;
        String streamPrefix = "streams." + id;
        config.put(systemPrefix + ".samza.factory", SamzaImpulseSystemFactory.class.getName());
        config.put(streamPrefix + ".samza.system", id);
        return config;
    }
}

