/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.serialization.Base64Serializer;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigFactory;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.TaskConfig;
import org.apache.samza.config.factories.PropertiesConfigFactory;
import org.apache.samza.container.grouper.task.SingleContainerGrouperFactory;
import org.apache.samza.runtime.LocalApplicationRunner;
import org.apache.samza.serializers.ByteSerdeFactory;
import org.apache.samza.standalone.PassthroughCoordinationUtilsFactory;
import org.apache.samza.standalone.PassthroughJobCoordinatorFactory;

public class ConfigBuilder {
    private static final String APP_RUNNER_CLASS = "app.runner.class";
    private final Map<String, String> config = new HashMap<String, String>();
    private final SamzaPipelineOptions options;

    public ConfigBuilder(SamzaPipelineOptions options) {
        this.options = options;
    }

    public void put(String name, String property) {
        this.config.put(name, property);
    }

    public void putAll(Map<String, String> properties) {
        this.config.putAll(properties);
    }

    public Config build() {
        try {
            this.config.putAll(ConfigBuilder.systemStoreConfig());
            this.config.putAll(ConfigBuilder.createUserConfig(this.options));
            this.config.put(JobConfig.JOB_NAME(), this.options.getJobName());
            this.config.put("beamPipelineOptions", Base64Serializer.serializeUnchecked((Serializable)new SerializablePipelineOptions((PipelineOptions)this.options)));
            return new MapConfig(this.config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isEmptyUserConfig(Map<String, String> config) {
        if (config == null) {
            return true;
        }
        return config.keySet().stream().allMatch(key -> key.startsWith("beam.override."));
    }

    private static Map<String, String> createUserConfig(SamzaPipelineOptions options) throws Exception {
        String configFilePath = options.getConfigFilePath();
        HashMap<String, String> config = new HashMap<String, String>();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{configFilePath})) {
            File configFile = new File(configFilePath);
            URI configUri = configFile.toURI();
            ConfigFactory configFactory = options.getConfigFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (configFactory instanceof PropertiesConfigFactory) {
                Preconditions.checkArgument((boolean)configFile.exists(), (String)"Config file %s does not exist", (Object)configFilePath);
            }
            config.putAll((Map<String, String>)configFactory.getConfig(configUri));
        }
        if (options.getConfigOverride() != null) {
            config.putAll(options.getConfigOverride());
        }
        if (ConfigBuilder.isEmptyUserConfig(options.getConfigOverride())) {
            config.putAll(ConfigBuilder.localRunConfig());
        }
        return config;
    }

    @VisibleForTesting
    public static Map<String, String> localRunConfig() {
        return ImmutableMap.builder().put((Object)APP_RUNNER_CLASS, (Object)LocalApplicationRunner.class.getName()).put((Object)"job.coordinator.factory", (Object)PassthroughJobCoordinatorFactory.class.getName()).put((Object)"job.coordination.utils.factory", (Object)PassthroughCoordinationUtilsFactory.class.getName()).put((Object)TaskConfig.GROUPER_FACTORY(), (Object)SingleContainerGrouperFactory.class.getName()).put((Object)TaskConfig.COMMIT_MS(), (Object)"-1").put((Object)"processor.id", (Object)"1").put((Object)"app.run.id", (Object)(String.valueOf(System.currentTimeMillis()) + "-" + UUID.randomUUID().toString().substring(0, 8))).build();
    }

    private static Map<String, String> systemStoreConfig() {
        return ImmutableMap.builder().put((Object)"stores.beamStore.factory", (Object)"org.apache.samza.storage.kv.RocksDbKeyValueStorageEngineFactory").put((Object)"stores.beamStore.key.serde", (Object)"byteSerde").put((Object)"stores.beamStore.msg.serde", (Object)"byteSerde").put((Object)"serializers.registry.byteSerde.class", (Object)ByteSerdeFactory.class.getName()).build();
    }
}

