/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza;

import java.util.Map;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.samza.config.ConfigFactory;
import org.apache.samza.config.factories.PropertiesConfigFactory;

public interface SamzaPipelineOptions
extends PipelineOptions {
    @Description(value="The config file for Samza. It is *optional*. By default Samza supports properties config.Without a config file, Samza uses a default config for local execution.")
    public String getConfigFilePath();

    public void setConfigFilePath(String var1);

    @Description(value="The factory to read config file from config file path.")
    @Default.Class(value=PropertiesConfigFactory.class)
    public Class<? extends ConfigFactory> getConfigFactory();

    public void setConfigFactory(Class<? extends ConfigFactory> var1);

    @Description(value="The config override to set programmatically. It will be applied on top of config file if it exits, otherwise used directly as the config.")
    public Map<String, String> getConfigOverride();

    public void setConfigOverride(Map<String, String> var1);

    @Description(value="The interval to check for watermarks in milliseconds.")
    @Default.Long(value=1000L)
    public long getWatermarkInterval();

    public void setWatermarkInterval(long var1);

    @Description(value="The maximum number of messages to buffer for a given system.")
    @Default.Integer(value=5000)
    public int getSystemBufferSize();

    public void setSystemBufferSize(int var1);

    @Description(value="The maximum parallelism allowed for any data source.")
    @Default.Integer(value=1)
    public int getMaxSourceParallelism();

    public void setMaxSourceParallelism(int var1);

    @Description(value="The batch get size limit for the state store.")
    @Default.Integer(value=10000)
    public int getStoreBatchGetSize();

    public void setStoreBatchGetSize(int var1);
}

