/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import org.apache.beam.runners.samza.runtime.OpAdapter;
import org.apache.beam.runners.samza.runtime.WindowAssignOp;
import org.apache.beam.runners.samza.translation.TransformTranslator;
import org.apache.beam.runners.samza.translation.TranslationContext;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.samza.operators.MessageStream;

class WindowAssignTranslator<T>
implements TransformTranslator<Window.Assign<T>> {
    WindowAssignTranslator() {
    }

    @Override
    public void translate(Window.Assign<T> transform, TransformHierarchy.Node node, TranslationContext ctx) {
        PCollection output = (PCollection)ctx.getOutput(transform);
        WindowFn windowFn = output.getWindowingStrategy().getWindowFn();
        MessageStream inputStream = ctx.getMessageStream((PValue)ctx.getInput(transform));
        MessageStream outputStream = inputStream.flatMap(OpAdapter.adapt(new WindowAssignOp(windowFn)));
        ctx.registerMessageStream((PValue)output, outputStream);
    }
}

