/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.provisioning;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.model.fnexecution.v1.ProvisionApi;
import org.apache.beam.model.fnexecution.v1.ProvisionServiceGrpc;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.fnexecution.FnService;
import org.apache.beam.runners.fnexecution.HeaderAccessor;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.StreamObserver;

public class StaticGrpcProvisionService
extends ProvisionServiceGrpc.ProvisionServiceImplBase
implements FnService {
    private final ProvisionApi.ProvisionInfo info;
    private final HeaderAccessor headerAccessor;
    private static final Map<String, RunnerApi.Environment> environments = new ConcurrentHashMap<String, RunnerApi.Environment>();

    public static StaticGrpcProvisionService create(ProvisionApi.ProvisionInfo info, HeaderAccessor headerAccessor) {
        return new StaticGrpcProvisionService(info, headerAccessor);
    }

    private StaticGrpcProvisionService(ProvisionApi.ProvisionInfo info, HeaderAccessor headerAccessor) {
        this.info = info;
        this.headerAccessor = headerAccessor;
    }

    public void getProvisionInfo(ProvisionApi.GetProvisionInfoRequest request, StreamObserver<ProvisionApi.GetProvisionInfoResponse> responseObserver) {
        if (this.headerAccessor.getSdkWorkerId() == null || !environments.containsKey(this.headerAccessor.getSdkWorkerId())) {
            responseObserver.onNext((Object)ProvisionApi.GetProvisionInfoResponse.newBuilder().setInfo(this.info).build());
            responseObserver.onCompleted();
            return;
        }
        responseObserver.onNext((Object)ProvisionApi.GetProvisionInfoResponse.newBuilder().setInfo(this.info.toBuilder().addAllDependencies((Iterable)environments.get(this.headerAccessor.getSdkWorkerId()).getDependenciesList())).build());
        responseObserver.onCompleted();
    }

    @Override
    public void close() throws Exception {
    }

    public void registerEnvironment(String workerId, RunnerApi.Environment environment) {
        environments.put(workerId, environment);
    }
}

