/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.artifact;

import java.io.File;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;
import org.apache.beam.runners.fnexecution.artifact.AbstractLegacyArtifactStagingService;

public class JavaFilesystemLegacyArtifactStagingService
extends AbstractLegacyArtifactStagingService {
    public static final String MANIFEST = "MANIFEST.json";
    public static final String ARTIFACTS = "ARTIFACTS";
    private final FileSystem fileSystem;
    private final Path artifactRootDir;

    public JavaFilesystemLegacyArtifactStagingService(FileSystem fileSystem, String artifactRootDir) {
        this.fileSystem = fileSystem;
        this.artifactRootDir = fileSystem.getPath(artifactRootDir, new String[0]);
    }

    @Override
    public String getArtifactUri(String stagingSessionToken, String encodedFileName) throws Exception {
        return this.artifactRootDir.resolve(stagingSessionToken).resolve(ARTIFACTS).resolve(encodedFileName).toString();
    }

    @Override
    public WritableByteChannel openUri(String uri) throws IOException {
        Path parent = this.fileSystem.getPath(uri, new String[0]).getParent();
        if (parent == null) {
            throw new RuntimeException("Provided URI did not have a parent: " + uri);
        }
        Files.createDirectories(parent, new FileAttribute[0]);
        return Channels.newChannel(Files.newOutputStream(this.fileSystem.getPath(uri, new String[0]), new OpenOption[0]));
    }

    @Override
    public void removeUri(String uri) throws IOException {
        Files.deleteIfExists(this.fileSystem.getPath(uri, new String[0]));
    }

    @Override
    public WritableByteChannel openManifest(String stagingSessionToken) throws Exception {
        return this.openUri(this.getManifestUri(stagingSessionToken));
    }

    @Override
    public void removeArtifacts(String stagingSessionToken) throws Exception {
        try (Stream<Path> paths = Files.walk(this.artifactRootDir.resolve(stagingSessionToken), new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    @Override
    public String getRetrievalToken(String stagingSessionToken) throws Exception {
        return this.getManifestUri(stagingSessionToken);
    }

    private String getManifestUri(String stagingSessionToken) {
        return this.artifactRootDir.resolve(stagingSessionToken).resolve(MANIFEST).toString();
    }
}

