/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.artifact;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.model.jobmanagement.v1.ArtifactRetrievalServiceGrpc;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.ArtifactResolver;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.runners.core.construction.DefaultArtifactResolver;
import org.apache.beam.runners.fnexecution.FnService;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.StatusException;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class ArtifactRetrievalService
extends ArtifactRetrievalServiceGrpc.ArtifactRetrievalServiceImplBase
implements FnService {
    public static final int DEFAULT_BUFFER_SIZE = 0x400000;
    public static final String FILE_ARTIFACT_URN = "beam:artifact:type:file:v1";
    public static final String URL_ARTIFACT_URN = "beam:artifact:type:url:v1";
    public static final String STAGING_TO_ARTIFACT_URN = "beam:artifact:role:staging_to:v1";
    private final ArtifactResolver resolver;
    private final int bufferSize;

    public ArtifactRetrievalService() {
        this(0x400000);
    }

    public ArtifactRetrievalService(ArtifactResolver resolver) {
        this(resolver, 0x400000);
    }

    public ArtifactRetrievalService(int bufferSize) {
        this(DefaultArtifactResolver.INSTANCE, bufferSize);
    }

    public ArtifactRetrievalService(ArtifactResolver resolver, int bufferSize) {
        this.resolver = resolver;
        this.bufferSize = bufferSize;
    }

    public void resolveArtifacts(ArtifactApi.ResolveArtifactsRequest request, StreamObserver<ArtifactApi.ResolveArtifactsResponse> responseObserver) {
        responseObserver.onNext((Object)ArtifactApi.ResolveArtifactsResponse.newBuilder().addAllReplacements((Iterable)this.resolver.resolveArtifacts(request.getArtifactsList())).build());
        responseObserver.onCompleted();
    }

    public void getArtifact(ArtifactApi.GetArtifactRequest request, StreamObserver<ArtifactApi.GetArtifactResponse> responseObserver) {
        switch (request.getArtifact().getTypeUrn()) {
            case "beam:artifact:type:file:v1": {
                try {
                    int bytesRead;
                    RunnerApi.ArtifactFilePayload payload = RunnerApi.ArtifactFilePayload.parseFrom((ByteString)request.getArtifact().getTypePayload());
                    InputStream inputStream = Channels.newInputStream(FileSystems.open((ResourceId)FileSystems.matchNewResource((String)payload.getPath(), (boolean)false)));
                    byte[] buffer = new byte[this.bufferSize];
                    while ((bytesRead = inputStream.read(buffer)) > 0) {
                        responseObserver.onNext((Object)ArtifactApi.GetArtifactResponse.newBuilder().setData(ByteString.copyFrom((byte[])buffer, (int)0, (int)bytesRead)).build());
                    }
                    responseObserver.onCompleted();
                }
                catch (IOException exn) {
                    exn.printStackTrace();
                    responseObserver.onError((Throwable)exn);
                }
                break;
            }
            default: {
                responseObserver.onError((Throwable)new StatusException(Status.INVALID_ARGUMENT.withDescription("Unexpected artifact type: " + request.getArtifact().getTypeUrn())));
            }
        }
    }

    @Override
    public void close() {
    }

    static {
        Preconditions.checkState((boolean)FILE_ARTIFACT_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE)));
        Preconditions.checkState((boolean)URL_ARTIFACT_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.URL)));
        Preconditions.checkState((boolean)STAGING_TO_ARTIFACT_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO)));
    }
}

