/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.StringUtils;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.Message;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.MessageOrBuilder;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.util.JsonFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SchemaCoderCloudObjectTranslator
implements CloudObjectTranslator<SchemaCoder> {
    private static final @UnknownKeyFor @NonNull @Initialized String SCHEMA = "schema";
    private static final @UnknownKeyFor @NonNull @Initialized String TYPE_DESCRIPTOR = "typeDescriptor";
    private static final @UnknownKeyFor @NonNull @Initialized String TO_ROW_FUNCTION = "toRowFunction";
    private static final @UnknownKeyFor @NonNull @Initialized String FROM_ROW_FUNCTION = "fromRowFunction";

    @Override
    public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized SchemaCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
        CloudObject base = CloudObject.forClass(SchemaCoder.class);
        Structs.addString((Map<String, Object>)((Object)base), TYPE_DESCRIPTOR, StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)target.getEncodedTypeDescriptor())));
        Structs.addString((Map<String, Object>)((Object)base), TO_ROW_FUNCTION, StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)target.getToRowFunction())));
        Structs.addString((Map<String, Object>)((Object)base), FROM_ROW_FUNCTION, StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)target.getFromRowFunction())));
        try {
            Structs.addString((Map<String, Object>)((Object)base), SCHEMA, JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)SchemaTranslation.schemaToProto((Schema)target.getSchema(), (boolean)true)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return base;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SchemaCoder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
        try {
            TypeDescriptor typeDescriptor = (TypeDescriptor)SerializableUtils.deserializeFromByteArray((byte[])StringUtils.jsonStringToByteArray((String)Structs.getString((Map<String, Object>)((Object)cloudObject), TYPE_DESCRIPTOR)), (String)TYPE_DESCRIPTOR);
            SerializableFunction toRowFunction = (SerializableFunction)SerializableUtils.deserializeFromByteArray((byte[])StringUtils.jsonStringToByteArray((String)Structs.getString((Map<String, Object>)((Object)cloudObject), TO_ROW_FUNCTION)), (String)TO_ROW_FUNCTION);
            SerializableFunction fromRowFunction = (SerializableFunction)SerializableUtils.deserializeFromByteArray((byte[])StringUtils.jsonStringToByteArray((String)Structs.getString((Map<String, Object>)((Object)cloudObject), FROM_ROW_FUNCTION)), (String)FROM_ROW_FUNCTION);
            SchemaApi.Schema.Builder schemaBuilder = SchemaApi.Schema.newBuilder();
            JsonFormat.parser().merge(Structs.getString((Map<String, Object>)((Object)cloudObject), SCHEMA), (Message.Builder)schemaBuilder);
            Schema schema = SchemaTranslation.schemaFromProto((SchemaApi.Schema)schemaBuilder.build());
            SchemaCoderCloudObjectTranslator.overrideEncodingPositions(schema);
            return SchemaCoder.of((Schema)schema, (TypeDescriptor)typeDescriptor, (SerializableFunction)toRowFunction, (SerializableFunction)fromRowFunction);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void overrideEncodingPositions(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        UUID uuid = schema.getUUID();
        if (schema.isEncodingPositionsOverridden() && uuid != null) {
            RowCoder.overrideEncodingPositions((UUID)uuid, (Map)schema.getEncodingPositions());
        }
        schema.getFields().stream().map(Schema.Field::getType).forEach(SchemaCoderCloudObjectTranslator::overrideEncodingPositions);
    }

    private static void overrideEncodingPositions(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case ROW: {
                SchemaCoderCloudObjectTranslator.overrideEncodingPositions((Schema)Preconditions.checkArgumentNotNull((Object)fieldType.getRowSchema()));
                break;
            }
            case ARRAY: 
            case ITERABLE: {
                SchemaCoderCloudObjectTranslator.overrideEncodingPositions((Schema.FieldType)Preconditions.checkArgumentNotNull((Object)fieldType.getCollectionElementType()));
                break;
            }
            case MAP: {
                SchemaCoderCloudObjectTranslator.overrideEncodingPositions((Schema.FieldType)Preconditions.checkArgumentNotNull((Object)fieldType.getMapKeyType()));
                SchemaCoderCloudObjectTranslator.overrideEncodingPositions((Schema.FieldType)Preconditions.checkArgumentNotNull((Object)fieldType.getMapValueType()));
                break;
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = (Schema.LogicalType)Preconditions.checkArgumentNotNull((Object)fieldType.getLogicalType());
                Schema.FieldType argumentType = logicalType.getArgumentType();
                if (argumentType != null) {
                    SchemaCoderCloudObjectTranslator.overrideEncodingPositions(argumentType);
                }
                SchemaCoderCloudObjectTranslator.overrideEncodingPositions(logicalType.getBaseType());
                break;
            }
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized SchemaCoder> getSupportedClass() {
        return SchemaCoder.class;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
        return CloudObject.forClass(SchemaCoder.class).getClassName();
    }
}

