/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.util.Map;
import org.apache.avro.Schema;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.coders.AvroCoder;

class AvroCoderCloudObjectTranslator
implements CloudObjectTranslator<AvroCoder> {
    private static final String TYPE_FIELD = "type";
    private static final String SCHEMA_FIELD = "schema";

    AvroCoderCloudObjectTranslator() {
    }

    @Override
    public CloudObject toCloudObject(AvroCoder target, SdkComponents sdkComponents) {
        CloudObject base = CloudObject.forClass(AvroCoder.class);
        Structs.addString((Map<String, Object>)((Object)base), SCHEMA_FIELD, target.getSchema().toString());
        Structs.addString((Map<String, Object>)((Object)base), TYPE_FIELD, target.getType().getName());
        return base;
    }

    @Override
    public AvroCoder<?> fromCloudObject(CloudObject cloudObject) {
        Schema.Parser parser = new Schema.Parser();
        String className = Structs.getString((Map<String, Object>)((Object)cloudObject), TYPE_FIELD);
        String schemaString = Structs.getString((Map<String, Object>)((Object)cloudObject), SCHEMA_FIELD);
        try {
            Class<?> type = Class.forName(className);
            Schema schema = parser.parse(schemaString);
            return AvroCoder.of(type, (Schema)schema);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Class<? extends AvroCoder> getSupportedClass() {
        return AvroCoder.class;
    }

    @Override
    public String cloudObjectClassName() {
        return CloudObject.forClass(AvroCoder.class).getClassName();
    }
}

