/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import java.util.Map;
import org.apache.beam.runners.dataflow.options.CloudDebuggerOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineDebugOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineWorkerPoolOptions;
import org.apache.beam.runners.dataflow.options.DataflowProfilingOptions;
import org.apache.beam.runners.dataflow.options.DataflowWorkerLoggingOptions;
import org.apache.beam.runners.dataflow.options.DefaultGcpRegionFactory;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.options.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Options that configure the Dataflow pipeline.")
public interface DataflowPipelineOptions
extends PipelineOptions,
GcpOptions,
ApplicationNameOptions,
DataflowPipelineDebugOptions,
DataflowPipelineWorkerPoolOptions,
BigQueryOptions,
GcsOptions,
StreamingOptions,
CloudDebuggerOptions,
DataflowWorkerLoggingOptions,
DataflowProfilingOptions,
PubsubOptions {
    @Description(value="Project id. Required when running a Dataflow in the cloud. See https://cloud.google.com/storage/docs/projects for further details.")
    @Validation.Required
    @Default.InstanceFactory(value=GcpOptions.DefaultProjectFactory.class)
    public String getProject();

    public void setProject(String var1);

    @Description(value="GCS path for staging local files, e.g. \"gs://bucket/object\". Must be a valid Cloud Storage URL, beginning with the prefix \"gs://\". If stagingLocation is unset, defaults to gcpTempLocation with \"/staging\" suffix.")
    @Default.InstanceFactory(value=StagingLocationFactory.class)
    public String getStagingLocation();

    public void setStagingLocation(String var1);

    @Description(value="If set, replace the existing pipeline with the name specified by --jobName with this pipeline, preserving state.")
    public boolean isUpdate();

    public void setUpdate(boolean var1);

    @Hidden
    @Description(value="If set, the snapshot from which the job should be created.")
    @Experimental
    public String getCreateFromSnapshot();

    public void setCreateFromSnapshot(String var1);

    @Description(value="Where the runner should generate a template file. Must either be local or Cloud Storage.")
    public String getTemplateLocation();

    public void setTemplateLocation(String var1);

    @Hidden
    @Description(value="Run the job as a specific service account, instead of the default GCE robot.")
    @Experimental
    public String getServiceAccount();

    public void setServiceAccount(String var1);

    @Description(value="The Google Compute Engine region for creating Dataflow jobs. See https://cloud.google.com/compute/docs/regions-zones/regions-zones for a list of valid options.")
    @Default.InstanceFactory(value=DefaultGcpRegionFactory.class)
    public String getRegion();

    public void setRegion(String var1);

    @Description(value="Labels that will be applied to the billing records for this job.")
    public Map<String, String> getLabels();

    public void setLabels(Map<String, String> var1);

    @Description(value="The URL of the staged portable pipeline")
    public String getPipelineUrl();

    public void setPipelineUrl(String var1);

    @Description(value="The customized dataflow worker jar")
    public String getDataflowWorkerJar();

    public void setDataflowWorkerJar(String var1);

    @Description(value="Controls the Flexible Resource Scheduling mode.")
    @Default.Enum(value="UNSPECIFIED")
    public FlexResourceSchedulingGoal getFlexRSGoal();

    public void setFlexRSGoal(FlexResourceSchedulingGoal var1);

    public static class StagingLocationFactory
    implements DefaultValueFactory<String> {
        private static final Logger LOG = LoggerFactory.getLogger(StagingLocationFactory.class);

        public String create(PipelineOptions options) {
            String gcpTempLocation;
            GcsOptions gcsOptions = (GcsOptions)options.as(GcsOptions.class);
            LOG.info("No stagingLocation provided, falling back to gcpTempLocation");
            try {
                gcpTempLocation = gcsOptions.getGcpTempLocation();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error constructing default value for stagingLocation: failed to retrieve gcpTempLocation. Either stagingLocation must be set explicitly or a valid value must be providedfor gcpTempLocation.", e);
            }
            try {
                gcsOptions.getPathValidator().validateOutputFilePrefixSupported(gcpTempLocation);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Error constructing default value for stagingLocation: gcpTempLocation is not a valid GCS path, %s. ", gcpTempLocation), e);
            }
            return FileSystems.matchNewResource((String)gcpTempLocation, (boolean)true).resolve("staging", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).toString();
        }
    }

    public static enum FlexResourceSchedulingGoal {
        UNSPECIFIED,
        SPEED_OPTIMIZED,
        COST_OPTIMIZED;

    }
}

