/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class Distinct<@UnknownKeyFor T>
extends PTransform<PCollection<T>, PCollection<T>> {
    public static <T> @UnknownKeyFor @NonNull @Initialized Distinct<T> create() {
        return new Distinct<T>();
    }

    public static <T, IdT> @UnknownKeyFor @NonNull @Initialized WithRepresentativeValues<T, IdT> withRepresentativeValueFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, IdT> fn) {
        return new WithRepresentativeValues(fn, null);
    }

    private static <T, W extends BoundedWindow> void validateWindowStrategy(@UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, W> strategy) {
        if (strategy.needsMerge() && (!strategy.getTrigger().getClass().equals(DefaultTrigger.class) || strategy.getAllowedLateness().isLongerThan((ReadableDuration)Duration.ZERO))) {
            throw new UnsupportedOperationException(String.format("%s does not support merging windowing strategies, except when using the default trigger and zero allowed lateness.", Distinct.class.getSimpleName()));
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> in) {
        Distinct.validateWindowStrategy(in.getWindowingStrategy());
        PCollection combined = (PCollection)((PCollection)in.apply("KeyByElement", MapElements.via(new SimpleFunction<T, KV<T, Void>>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized KV<T, @UnknownKeyFor @Nullable @Initialized Void> apply(T element) {
                return KV.of(element, null);
            }
        }))).apply("DropValues", Combine.perKey(new SerializableFunction<Iterable<Void>, Void>(){

            @Override
            public @Nullable @UnknownKeyFor @Initialized Void apply(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @Nullable @Initialized Void> iter) {
                return null;
            }
        }));
        return (PCollection)combined.apply("ExtractFirstKey", ParDo.of(new DoFn<KV<T, Void>, T>(){

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<T, @UnknownKeyFor @Nullable @Initialized Void> element, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> receiver) {
                if (paneInfo.isFirst()) {
                    receiver.output(element.getKey());
                }
            }
        }));
    }

    public static class WithRepresentativeValues<@UnknownKeyFor T, @UnknownKeyFor IdT>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, IdT> fn;
        private final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<IdT> representativeType;

        private WithRepresentativeValues(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, IdT> fn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<IdT> representativeType) {
            this.fn = fn;
            this.representativeType = representativeType;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> in) {
            Distinct.validateWindowStrategy(in.getWindowingStrategy());
            WithKeys withKeys = WithKeys.of(this.fn);
            if (this.representativeType != null) {
                withKeys = withKeys.withKeyType(this.representativeType);
            }
            PCollection keyed = (PCollection)in.apply("KeyByRepresentativeValue", withKeys);
            KvCoder keyedCoder = (KvCoder)keyed.getCoder();
            PCollection combined = ((PCollection)keyed.apply("OneValuePerKey", Combine.perKey(new Combine.BinaryCombineFn<T>(){

                @Override
                public T apply(T left, T right) {
                    return left;
                }
            }))).setCoder(KvCoder.of(keyedCoder.getKeyCoder(), NullableCoder.of(keyedCoder.getValueCoder())));
            return (PCollection)combined.apply("KeepFirstPane", ParDo.of(new DoFn<KV<IdT, T>, T>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<IdT, T> element, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> receiver) {
                    if (paneInfo.isFirst()) {
                        receiver.output(element.getValue());
                    }
                }
            }));
        }

        public @UnknownKeyFor @NonNull @Initialized WithRepresentativeValues<T, IdT> withRepresentativeType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<IdT> type) {
            return new WithRepresentativeValues<T, IdT>(this.fn, type);
        }
    }
}

