/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SingleInputOutputOverrideFactory;
import org.apache.beam.repackaged.direct_java.runners.local.StructuralKey;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

class MultiStepCombine<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
extends PTransformTranslation.RawPTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>> {
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> outputCoder;
    static final @UnknownKeyFor @NonNull @Initialized String DIRECT_MERGE_ACCUMULATORS_EXTRACT_OUTPUT_URN = "beam:directrunner:transforms:merge_accumulators_extract_output:v1";

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher matcher() {
        return new PTransformMatcher(){

            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                if ("beam:transform:combine_per_key:v1".equals(PTransformTranslation.urnForTransformOrNull(application.getTransform()))) {
                    CombineFnBase.GlobalCombineFn fn = ((Combine.PerKey)application.getTransform()).getFn();
                    return this.isApplicable(application.getInputs(), fn);
                }
                return false;
            }

            private <K, InputT> @UnknownKeyFor @NonNull @Initialized boolean isApplicable(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fn) {
                if (!(fn instanceof Combine.CombineFn)) {
                    return false;
                }
                if (inputs.size() == 1) {
                    boolean accumulatorCoderAvailable;
                    PCollection input = (PCollection)Iterables.getOnlyElement(inputs.values());
                    WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                    boolean windowFnApplicable = !windowingStrategy.needsMerge();
                    boolean triggerApplicable = DefaultTrigger.of().equals((Object)windowingStrategy.getTrigger());
                    try {
                        if (input.getCoder() instanceof KvCoder) {
                            KvCoder kvCoder = (KvCoder)input.getCoder();
                            Coder accumulatorCoder = fn.getAccumulatorCoder(input.getPipeline().getCoderRegistry(), kvCoder.getValueCoder());
                            accumulatorCoderAvailable = accumulatorCoder != null;
                        } else {
                            accumulatorCoderAvailable = false;
                        }
                    }
                    catch (CannotProvideCoderException e) {
                        throw new RuntimeException(String.format("Could not construct an accumulator %s for %s. Accumulator %s for a %s may be null, but may not throw an exception", Coder.class.getSimpleName(), fn, Coder.class.getSimpleName(), Combine.class.getSimpleName()), e);
                    }
                    return windowFnApplicable && triggerApplicable && accumulatorCoderAvailable;
                }
                return false;
            }
        };
    }

    public static <K, InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized MultiStepCombine<K, InputT, AccumT, OutputT> of(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> outputCoder) {
        return new MultiStepCombine<K, InputT, AccumT, OutputT>(combineFn, outputCoder);
    }

    private MultiStepCombine(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> outputCoder) {
        this.combineFn = combineFn;
        this.outputCoder = outputCoder;
    }

    @Override
    public @NonNull @UnknownKeyFor @Initialized String getUrn() {
        return "beam:directrunner:transforms:multistepcombine:v1";
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @UnknownKeyFor @Initialized RunnerApi.FunctionSpec getSpec() {
        return null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> input) {
        Coder accumulatorCoder;
        Preconditions.checkArgument((boolean)(input.getCoder() instanceof KvCoder), (String)"Expected input to have a %s of type %s, got %s", (Object)Coder.class.getSimpleName(), (Object)KvCoder.class.getSimpleName(), (Object)input.getCoder());
        KvCoder inputCoder = (KvCoder)input.getCoder();
        Coder inputValueCoder = inputCoder.getValueCoder();
        try {
            accumulatorCoder = this.combineFn.getAccumulatorCoder(input.getPipeline().getCoderRegistry(), inputValueCoder);
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalStateException(String.format("Could not construct an Accumulator Coder with the provided %s %s", Combine.CombineFn.class.getSimpleName(), this.combineFn), e);
        }
        return (PCollection)((PCollection)((PCollection)input.apply((PTransform)ParDo.of(CombineInputs.of(this.combineFn, input.getWindowingStrategy().getTimestampCombiner(), inputCoder.getKeyCoder())))).setCoder((Coder)KvCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)accumulatorCoder)).apply((PTransform)GroupByKey.create())).apply(MergeAndExtractAccumulatorOutput.of(this.combineFn, this.outputCoder));
    }

    private static class MergeAccumulatorsAndExtractOutputEvaluator<@UnknownKeyFor K, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    implements TransformEvaluator<KV<K, Iterable<AccumT>>> {
        private final @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<AccumT>>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>, @UnknownKeyFor @NonNull @Initialized MergeAndExtractAccumulatorOutput<K, AccumT, OutputT>> application;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, AccumT, OutputT> combineFn;
        private final @UnknownKeyFor @NonNull @Initialized UncommittedBundle<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> output;

        public MergeAccumulatorsAndExtractOutputEvaluator(@UnknownKeyFor @NonNull @Initialized EvaluationContext ctxt, @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<AccumT>>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>, @UnknownKeyFor @NonNull @Initialized MergeAndExtractAccumulatorOutput<K, AccumT, OutputT>> application) {
            this.application = application;
            this.combineFn = ((MergeAndExtractAccumulatorOutput)application.getTransform()).getCombineFn();
            this.output = ctxt.createBundle((PCollection)Iterables.getOnlyElement(application.getOutputs().values()));
        }

        @Override
        public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<AccumT>>> element) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Preconditions.checkState((element.getWindows().size() == 1 ? 1 : 0) != 0, (String)"Expected inputs to %s to be in exactly one window. Got %s", (Object)MergeAccumulatorsAndExtractOutputEvaluator.class.getSimpleName(), (int)element.getWindows().size());
            Iterable inputAccumulators = (Iterable)((KV)element.getValue()).getValue();
            try {
                Object first = this.combineFn.createAccumulator();
                Object merged = this.combineFn.mergeAccumulators(Iterables.concat(Collections.singleton(first), (Iterable)inputAccumulators, Collections.singleton(this.combineFn.createAccumulator())));
                Object extracted = this.combineFn.extractOutput(merged);
                this.output.add(element.withValue((Object)KV.of((Object)((KV)element.getValue()).getKey(), (Object)extracted)));
            }
            catch (Exception e) {
                throw UserCodeException.wrap((Throwable)e);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TransformResult<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<AccumT>>> finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
            return StepTransformResult.withoutHold(this.application).addOutput(this.output, new UncommittedBundle[0]).build();
        }
    }

    static class MergeAndExtractAccumulatorOutputEvaluatorFactory
    implements TransformEvaluatorFactory {
        private final @UnknownKeyFor @NonNull @Initialized EvaluationContext ctxt;

        public MergeAndExtractAccumulatorOutputEvaluatorFactory(@UnknownKeyFor @NonNull @Initialized EvaluationContext ctxt) {
            this.ctxt = ctxt;
        }

        @Override
        public <InputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<InputT> forApplication(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputBundle) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return this.createEvaluator(application);
        }

        private <K, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<AccumT>>> createEvaluator(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<AccumT>>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>, @UnknownKeyFor @NonNull @Initialized MergeAndExtractAccumulatorOutput<K, AccumT, OutputT>> application) {
            return new MergeAccumulatorsAndExtractOutputEvaluator<K, AccumT, OutputT>(this.ctxt, application);
        }

        @Override
        public void cleanup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        }
    }

    static class MergeAndExtractAccumulatorOutput<@UnknownKeyFor K, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends PTransformTranslation.RawPTransform<PCollection<KV<K, Iterable<AccumT>>>, PCollection<KV<K, OutputT>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, AccumT, OutputT> combineFn;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> outputCoder;

        private MergeAndExtractAccumulatorOutput(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, AccumT, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> outputCoder) {
            this.combineFn = combineFn;
            this.outputCoder = outputCoder;
        }

        public static <K, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized MergeAndExtractAccumulatorOutput<K, AccumT, OutputT> of(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, AccumT, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> outputCoder) {
            return new MergeAndExtractAccumulatorOutput<K, AccumT, OutputT>(combineFn, outputCoder);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, AccumT, OutputT> getCombineFn() {
            return this.combineFn;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<AccumT>>> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)input.getWindowingStrategy(), (PCollection.IsBounded)input.isBounded(), this.outputCoder);
        }

        @Override
        @Nonnull
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return MultiStepCombine.DIRECT_MERGE_ACCUMULATORS_EXTRACT_OUTPUT_URN;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable @UnknownKeyFor @Initialized RunnerApi.FunctionSpec getSpec() {
            return null;
        }
    }

    static class WindowedStructuralKey<@UnknownKeyFor K> {
        private final @UnknownKeyFor @NonNull @Initialized StructuralKey<K> key;
        private final @UnknownKeyFor @NonNull @Initialized BoundedWindow window;

        @SideEffectFree
        public static <K> @UnknownKeyFor @NonNull @Initialized WindowedStructuralKey<K> create(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, K key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return new WindowedStructuralKey<K>(StructuralKey.of(key, keyCoder), window);
        }

        private WindowedStructuralKey(@UnknownKeyFor @NonNull @Initialized StructuralKey<K> key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            this.key = (StructuralKey)Preconditions.checkNotNull(key, (Object)"key cannot be null");
            this.window = (BoundedWindow)Preconditions.checkNotNull((Object)window, (Object)"Window cannot be null");
        }

        public K getKey() {
            return this.key.getKey();
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow() {
            return this.window;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (!(other instanceof WindowedStructuralKey)) {
                return false;
            }
            WindowedStructuralKey that = (WindowedStructuralKey)other;
            return this.window.equals(that.window) && this.key.equals(that.key);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.window, this.key);
        }
    }

    private static class CombineInputs<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor AccumT>
    extends DoFn<KV<K, InputT>, KV<K, AccumT>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> combineFn;
        private final @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner;
        private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
        private transient @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized WindowedStructuralKey<K>, AccumT> accumulators;
        private transient @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized WindowedStructuralKey<K>, @UnknownKeyFor @NonNull @Initialized Instant> timestamps;

        private CombineInputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> combineFn, @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder) {
            this.combineFn = combineFn;
            this.timestampCombiner = timestampCombiner;
            this.keyCoder = keyCoder;
        }

        public static <K, InputT, AccumT> @UnknownKeyFor @NonNull @Initialized CombineInputs<K, InputT, AccumT> of(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> combineFn, @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner, @UnknownKeyFor @NonNull @Initialized Coder<K> coder) {
            return new CombineInputs<K, InputT, AccumT>(combineFn, timestampCombiner, coder);
        }

        @DoFn.StartBundle
        @EnsuresNonNull(value={"accumulators", "timestamps"})
        public void startBundle() {
            this.accumulators = new LinkedHashMap<WindowedStructuralKey<K>, AccumT>();
            this.timestamps = new LinkedHashMap<WindowedStructuralKey<K>, Instant>();
        }

        @DoFn.ProcessElement
        @RequiresNonNull(value={"accumulators", "timestamps"})
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            Instant combinedTimestamp;
            Map<WindowedStructuralKey<WindowedStructuralKey<Object>>, Instant> timestamps = this.timestamps;
            Map<WindowedStructuralKey<WindowedStructuralKey<Object>>, AccumT> accumulators = this.accumulators;
            Instant assignedTimestamp = this.timestampCombiner.assign(window, context.timestamp());
            WindowedStructuralKey<Object> key = WindowedStructuralKey.create(this.keyCoder, ((KV)context.element()).getKey(), window);
            @Nullable Object accumulator = accumulators.get(key);
            if (accumulator == null) {
                accumulator = this.combineFn.createAccumulator();
            }
            if ((combinedTimestamp = timestamps.get(key)) == null) {
                combinedTimestamp = assignedTimestamp;
            }
            accumulators.put(key, this.combineFn.addInput(accumulator, ((KV)context.element()).getValue()));
            timestamps.put(key, this.timestampCombiner.combine(new Instant[]{assignedTimestamp, combinedTimestamp}));
        }

        @DoFn.FinishBundle
        @RequiresNonNull(value={"accumulators", "timestamps"})
        public void outputAccumulators(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext context) {
            Map<WindowedStructuralKey<K>, AccumT> accumulators = this.accumulators;
            Map<WindowedStructuralKey<K>, Instant> timestamps = this.timestamps;
            for (Map.Entry<WindowedStructuralKey<K>, Instant> timestampEntry : timestamps.entrySet()) {
                WindowedStructuralKey<K> key = timestampEntry.getKey();
                Instant timestamp = timestampEntry.getValue();
                AccumT preCombineAccum = accumulators.get(key);
                context.output((Object)KV.of(key.getKey(), (Object)this.combineFn.compact(preCombineAccum)), timestamp, key.getWindow());
            }
            this.accumulators = null;
            this.timestamps = null;
        }
    }

    static class Factory<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends SingleInputOutputOverrideFactory<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>, PTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>>> {
        public static @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory create() {
            return new Factory();
        }

        private Factory() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>>> transform) {
            CombineFnBase.GlobalCombineFn globalFn = ((Combine.PerKey)transform.getTransform()).getFn();
            Preconditions.checkState((boolean)(globalFn instanceof Combine.CombineFn), (String)"%s.matcher() should only match %s instances using %s, got %s", (Object)MultiStepCombine.class.getSimpleName(), (Object)Combine.PerKey.class.getSimpleName(), (Object)Combine.CombineFn.class.getSimpleName(), (Object)globalFn.getClass().getName());
            Combine.CombineFn fn = (Combine.CombineFn)globalFn;
            PCollection input = (PCollection)Iterables.getOnlyElement(transform.getInputs().values());
            PCollection output = (PCollection)Iterables.getOnlyElement(transform.getOutputs().values());
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)input, MultiStepCombine.of(fn, output.getCoder()));
        }
    }
}

