/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.repackaged.direct_java.runners.core.DoFnRunner;
import org.apache.beam.repackaged.direct_java.runners.core.DoFnRunners;
import org.apache.beam.repackaged.direct_java.runners.core.LateDataUtils;
import org.apache.beam.repackaged.direct_java.runners.core.SideInputReader;
import org.apache.beam.repackaged.direct_java.runners.core.SimpleDoFnRunner;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespaces;
import org.apache.beam.repackaged.direct_java.runners.core.StateTags;
import org.apache.beam.repackaged.direct_java.runners.core.StepContext;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerMap;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnOutputReceivers;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.SystemDoFnInternal;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;

public class SimpleDoFnRunner<InputT, OutputT>
implements DoFnRunner<InputT, OutputT> {
    private final PipelineOptions options;
    private final DoFn<InputT, OutputT> fn;
    private final DoFnInvoker<InputT, OutputT> invoker;
    private final SideInputReader sideInputReader;
    private final DoFnRunners.OutputManager outputManager;
    private final TupleTag<OutputT> mainOutputTag;
    private final Set<TupleTag<?>> outputTags;
    private final boolean observesWindow;
    private final DoFnSignature signature;
    private final Coder<BoundedWindow> windowCoder;
    private final Duration allowedLateness;
    private final StepContext stepContext;
    private final @Nullable SchemaCoder<InputT> schemaCoder;
    final @Nullable SchemaCoder<OutputT> mainOutputSchemaCoder;
    private @Nullable Map<TupleTag<?>, Coder<?>> outputCoders;
    private final @Nullable DoFnSchemaInformation doFnSchemaInformation;
    private final Map<String, PCollectionView<?>> sideInputMapping;

    public SimpleDoFnRunner(PipelineOptions options, DoFn<InputT, OutputT> fn, SideInputReader sideInputReader, DoFnRunners.OutputManager outputManager, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags, StepContext stepContext, @Nullable Coder<InputT> inputCoder, Map<TupleTag<?>, Coder<?>> outputCoders, WindowingStrategy<?, ?> windowingStrategy, DoFnSchemaInformation doFnSchemaInformation, Map<String, PCollectionView<?>> sideInputMapping) {
        Coder untypedCoder;
        Coder<?> outputCoder;
        this.options = options;
        this.fn = fn;
        this.signature = DoFnSignatures.getSignature(fn.getClass());
        this.observesWindow = this.signature.processElement().observesWindow() || !sideInputReader.isEmpty();
        this.invoker = DoFnInvokers.invokerFor(fn);
        this.sideInputReader = sideInputReader;
        this.schemaCoder = inputCoder instanceof SchemaCoder ? (SchemaCoder)inputCoder : null;
        this.outputCoders = outputCoders;
        this.mainOutputSchemaCoder = outputCoders != null && !outputCoders.isEmpty() ? ((outputCoder = outputCoders.get(mainOutputTag)) instanceof SchemaCoder ? (SchemaCoder)outputCoder : null) : null;
        this.outputManager = outputManager;
        this.mainOutputTag = mainOutputTag;
        this.outputTags = Sets.newHashSet((Iterable)FluentIterable.of(mainOutputTag, (Object[])new TupleTag[0]).append(additionalOutputTags));
        this.stepContext = stepContext;
        this.windowCoder = untypedCoder = windowingStrategy.getWindowFn().windowCoder();
        this.allowedLateness = windowingStrategy.getAllowedLateness();
        this.doFnSchemaInformation = doFnSchemaInformation;
        this.sideInputMapping = sideInputMapping;
    }

    @Override
    public DoFn<InputT, OutputT> getFn() {
        return this.fn;
    }

    @Override
    public void startBundle() {
        try {
            this.invoker.invokeStartBundle((DoFnInvoker.ArgumentProvider)new DoFnStartBundleArgumentProvider());
        }
        catch (Throwable t) {
            throw this.wrapUserCodeException(t);
        }
    }

    @Override
    public void processElement(WindowedValue<InputT> compressedElem) {
        if (this.observesWindow) {
            for (WindowedValue elem : compressedElem.explodeWindows()) {
                this.invokeProcessElement(elem);
            }
        } else {
            this.invokeProcessElement(compressedElem);
        }
    }

    @Override
    public <KeyT> void onTimer(String timerId, String timerFamilyId, KeyT key, BoundedWindow window, Instant timestamp, Instant outputTimestamp, TimeDomain timeDomain) {
        Instant effectiveTimestamp;
        switch (timeDomain) {
            case EVENT_TIME: {
                effectiveTimestamp = outputTimestamp;
                break;
            }
            case PROCESSING_TIME: 
            case SYNCHRONIZED_PROCESSING_TIME: {
                effectiveTimestamp = this.stepContext.timerInternals().currentInputWatermarkTime();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown time domain: %s", timeDomain));
            }
        }
        OnTimerArgumentProvider argumentProvider = new OnTimerArgumentProvider(timerId, key, window, timestamp, effectiveTimestamp, timeDomain);
        this.invoker.invokeOnTimer(timerId, timerFamilyId, argumentProvider);
    }

    private void invokeProcessElement(WindowedValue<InputT> elem) {
        try {
            this.invoker.invokeProcessElement((DoFnInvoker.ArgumentProvider)new DoFnProcessContext(elem));
        }
        catch (Exception ex) {
            throw this.wrapUserCodeException(ex);
        }
    }

    @Override
    public void finishBundle() {
        try {
            this.invoker.invokeFinishBundle((DoFnInvoker.ArgumentProvider)new DoFnFinishBundleArgumentProvider());
        }
        catch (Throwable t) {
            throw this.wrapUserCodeException(t);
        }
    }

    @Override
    public <KeyT> void onWindowExpiration(BoundedWindow window, Instant timestamp, KeyT key) {
        this.invoker.invokeOnWindowExpiration(new OnWindowExpirationArgumentProvider(window, timestamp, key));
    }

    private RuntimeException wrapUserCodeException(Throwable t) {
        throw UserCodeException.wrapIf((!this.isSystemDoFn() ? 1 : 0) != 0, (Throwable)t);
    }

    private boolean isSystemDoFn() {
        return this.invoker.getClass().isAnnotationPresent(SystemDoFnInternal.class);
    }

    private <T> T sideInput(PCollectionView<T> view, BoundedWindow sideInputWindow) {
        if (!this.sideInputReader.contains(view)) {
            throw new IllegalArgumentException("calling sideInput() with unknown view");
        }
        return this.sideInputReader.get(view, sideInputWindow);
    }

    private <T> void outputWindowedValue(TupleTag<T> tag, WindowedValue<T> windowedElem) {
        Preconditions.checkArgument((boolean)this.outputTags.contains(tag), (String)"Unknown output tag %s", tag);
        this.outputManager.output(tag, windowedElem);
    }

    private class TimerInternalsTimerMap
    implements TimerMap {
        Map<String, Timer> timers = new HashMap<String, Timer>();
        private final TimerInternals timerInternals;
        private final BoundedWindow window;
        private final StateNamespace namespace;
        private final TimerSpec spec;
        private final Instant elementInputTimestamp;
        private final String timerFamilyId;

        public TimerInternalsTimerMap(String timerFamilyId, BoundedWindow window, StateNamespace namespace, TimerSpec spec, Instant elementInputTimestamp, TimerInternals timerInternals) {
            this.window = window;
            this.namespace = namespace;
            this.spec = spec;
            this.elementInputTimestamp = elementInputTimestamp;
            this.timerInternals = timerInternals;
            this.timerFamilyId = timerFamilyId;
        }

        public void set(String timerId, Instant absoluteTime) {
            TimerInternalsTimer timer = new TimerInternalsTimer(this.window, this.namespace, timerId, this.timerFamilyId, this.spec, this.elementInputTimestamp, this.timerInternals);
            timer.set(absoluteTime);
            this.timers.put(timerId, timer);
        }

        public Timer get(String timerId) {
            if (this.timers.get(timerId) == null) {
                TimerInternalsTimer timer = new TimerInternalsTimer(this.window, this.namespace, timerId, this.timerFamilyId, this.spec, this.elementInputTimestamp, this.timerInternals);
                this.timers.put(timerId, timer);
            }
            return this.timers.get(timerId);
        }
    }

    private class TimerInternalsTimer
    implements Timer {
        private final TimerInternals timerInternals;
        private final BoundedWindow window;
        private final StateNamespace namespace;
        private final String timerId;
        private final String timerFamilyId;
        private final TimerSpec spec;
        private Instant target;
        private Instant outputTimestamp;
        private final Instant elementInputTimestamp;
        private Duration period = Duration.ZERO;
        private Duration offset = Duration.ZERO;

        public TimerInternalsTimer(BoundedWindow window, StateNamespace namespace, String timerId, TimerSpec spec, Instant elementInputTimestamp, TimerInternals timerInternals) {
            this.window = window;
            this.namespace = namespace;
            this.timerId = timerId;
            this.timerFamilyId = "";
            this.spec = spec;
            this.elementInputTimestamp = elementInputTimestamp;
            this.timerInternals = timerInternals;
        }

        public TimerInternalsTimer(BoundedWindow window, StateNamespace namespace, String timerId, String timerFamilyId, TimerSpec spec, Instant elementInputTimestamp, TimerInternals timerInternals) {
            this.window = window;
            this.namespace = namespace;
            this.timerId = timerId;
            this.timerFamilyId = timerFamilyId;
            this.spec = spec;
            this.elementInputTimestamp = elementInputTimestamp;
            this.timerInternals = timerInternals;
        }

        public void set(Instant target) {
            this.target = target;
            this.setAndVerifyOutputTimestamp();
            this.setUnderlyingTimer();
        }

        public void setRelative() {
            long millisSinceStart;
            Instant now = this.getCurrentRelativeTime();
            this.target = this.period.equals((Object)Duration.ZERO) ? now.plus((ReadableDuration)this.offset) : ((millisSinceStart = now.plus((ReadableDuration)this.offset).getMillis() % this.period.getMillis()) == 0L ? now : now.plus((ReadableDuration)this.period).minus(millisSinceStart));
            this.target = this.minTargetAndGcTime(this.target);
            this.setAndVerifyOutputTimestamp();
            this.setUnderlyingTimer();
        }

        public void clear() {
            this.timerInternals.deleteTimer(this.namespace, this.timerId, this.timerFamilyId, this.spec.getTimeDomain());
        }

        public Timer offset(Duration offset) {
            this.offset = offset;
            return this;
        }

        public Timer align(Duration period) {
            this.period = period;
            return this;
        }

        private Instant minTargetAndGcTime(Instant target) {
            Instant windowExpiry;
            if (TimeDomain.EVENT_TIME.equals((Object)this.spec.getTimeDomain()) && target.isAfter((ReadableInstant)(windowExpiry = LateDataUtils.garbageCollectionTime(this.window, SimpleDoFnRunner.this.allowedLateness)))) {
                return windowExpiry;
            }
            return target;
        }

        public Timer withOutputTimestamp(Instant outputTimestamp) {
            this.outputTimestamp = outputTimestamp;
            return this;
        }

        private void setAndVerifyOutputTimestamp() {
            if (this.outputTimestamp != null) {
                Preconditions.checkArgument((!this.outputTimestamp.isBefore((ReadableInstant)this.elementInputTimestamp) ? 1 : 0) != 0, (String)"output timestamp %s should be after input message timestamp or output timestamp of firing timers %s", (Object)this.outputTimestamp, (Object)this.elementInputTimestamp);
            }
            if (this.outputTimestamp == null && TimeDomain.EVENT_TIME.equals((Object)this.spec.getTimeDomain())) {
                this.outputTimestamp = this.target;
            }
            if (this.outputTimestamp == null) {
                this.outputTimestamp = this.elementInputTimestamp;
            }
            Instant windowExpiry = this.window.maxTimestamp().plus((ReadableDuration)SimpleDoFnRunner.this.allowedLateness);
            if (TimeDomain.EVENT_TIME.equals((Object)this.spec.getTimeDomain())) {
                Preconditions.checkArgument((!this.outputTimestamp.isAfter((ReadableInstant)windowExpiry) ? 1 : 0) != 0, (String)"Attempted to set an event-time timer with an output timestamp of %s that is after the expiration of window %s", (Object)this.outputTimestamp, (Object)windowExpiry);
                Preconditions.checkArgument((!this.target.isAfter((ReadableInstant)windowExpiry) ? 1 : 0) != 0, (String)"Attempted to set an event-time timer with a firing timestamp of %s that is after the expiration of window %s", (Object)this.target, (Object)windowExpiry);
            } else {
                Preconditions.checkArgument((!this.outputTimestamp.isAfter((ReadableInstant)windowExpiry) ? 1 : 0) != 0, (String)"Attempted to set a processing-time timer with an output timestamp of %s that is after the expiration of window %s", (Object)this.outputTimestamp, (Object)windowExpiry);
            }
        }

        private void setUnderlyingTimer() {
            this.timerInternals.setTimer(this.namespace, this.timerId, this.timerFamilyId, this.target, this.outputTimestamp, this.spec.getTimeDomain());
        }

        public Instant getCurrentRelativeTime() {
            return this.getCurrentTime(this.spec.getTimeDomain());
        }

        private Instant getCurrentTime(TimeDomain timeDomain) {
            switch (timeDomain) {
                case EVENT_TIME: {
                    return this.timerInternals.currentInputWatermarkTime();
                }
                case PROCESSING_TIME: {
                    return this.timerInternals.currentProcessingTime();
                }
                case SYNCHRONIZED_PROCESSING_TIME: {
                    return this.timerInternals.currentSynchronizedProcessingTime();
                }
            }
            throw new IllegalStateException(String.format("Timer created for unknown time domain %s", this.spec.getTimeDomain()));
        }
    }

    private class OnWindowExpirationArgumentProvider<KeyT>
    extends DoFn.OnWindowExpirationContext
    implements DoFnInvoker.ArgumentProvider<InputT, OutputT> {
        private final BoundedWindow window;
        private final Instant timestamp;
        private final KeyT key;
        private @Nullable StateNamespace namespace;

        private StateNamespace getNamespace() {
            if (this.namespace == null) {
                this.namespace = StateNamespaces.window(SimpleDoFnRunner.this.windowCoder, this.window);
            }
            return this.namespace;
        }

        private OnWindowExpirationArgumentProvider(BoundedWindow window, Instant timestamp, KeyT key) {
            super(SimpleDoFnRunner.this.fn);
            this.window = window;
            this.timestamp = timestamp;
            this.key = key;
        }

        public BoundedWindow window() {
            return this.window;
        }

        public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Cannot access paneInfo outside of @ProcessElement methods.");
        }

        public PipelineOptions pipelineOptions() {
            return this.getPipelineOptions();
        }

        public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("StartBundleContext parameters are not supported.");
        }

        public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("FinishBundleContext parameters are not supported.");
        }

        public DoFn.ProcessContext processContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("ProcessContext parameters are not supported.");
        }

        public InputT element(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Element parameters are not supported.");
        }

        public Object sideInput(String tagId) {
            throw new UnsupportedOperationException("SideInput parameters are not supported.");
        }

        public Object schemaElement(int index) {
            throw new UnsupportedOperationException("Element parameters are not supported.");
        }

        public Instant timestamp(DoFn<InputT, OutputT> doFn) {
            return this.timestamp;
        }

        public String timerId(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Timer parameters are not supported.");
        }

        public TimeDomain timeDomain(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Cannot access time domain outside of @ProcessTimer method.");
        }

        public KeyT key() {
            return this.key;
        }

        public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> doFn) {
            return DoFnOutputReceivers.windowedReceiver((DoFn.WindowedContext)this, (TupleTag)SimpleDoFnRunner.this.mainOutputTag);
        }

        public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn<InputT, OutputT> doFn) {
            return DoFnOutputReceivers.rowReceiver((DoFn.WindowedContext)this, (TupleTag)SimpleDoFnRunner.this.mainOutputTag, SimpleDoFnRunner.this.mainOutputSchemaCoder);
        }

        public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> doFn) {
            return DoFnOutputReceivers.windowedMultiReceiver((DoFn.WindowedContext)this, (Map)SimpleDoFnRunner.this.outputCoders);
        }

        public Object restriction() {
            throw new UnsupportedOperationException("@Restriction parameters are not supported.");
        }

        public DoFn.OnTimerContext onTimerContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("OnTimerContext parameters are not supported.");
        }

        public RestrictionTracker<?, ?> restrictionTracker() {
            throw new UnsupportedOperationException("RestrictionTracker parameters are not supported.");
        }

        public Object watermarkEstimatorState() {
            throw new UnsupportedOperationException("@WatermarkEstimatorState parameters are not supported.");
        }

        public WatermarkEstimator<?> watermarkEstimator() {
            throw new UnsupportedOperationException("WatermarkEstimator parameters are not supported.");
        }

        public State state(String stateId, boolean alwaysFetched) {
            try {
                StateSpec spec = (StateSpec)((DoFnSignature.StateDeclaration)SimpleDoFnRunner.this.signature.stateDeclarations().get(stateId)).field().get(SimpleDoFnRunner.this.fn);
                Object state = SimpleDoFnRunner.this.stepContext.stateInternals().state(this.getNamespace(), StateTags.tagForSpec(stateId, spec));
                if (alwaysFetched) {
                    return (State)((ReadableState)state).readLater();
                }
                return state;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Timer timer(String timerId) {
            throw new UnsupportedOperationException("Timer parameters are not supported.");
        }

        public TimerMap timerFamily(String timerFamilyId) {
            throw new UnsupportedOperationException("TimerFamily parameters are not supported.");
        }

        public PipelineOptions getPipelineOptions() {
            return SimpleDoFnRunner.this.options;
        }

        public void output(OutputT output) {
            this.output(SimpleDoFnRunner.this.mainOutputTag, output);
        }

        public void outputWithTimestamp(OutputT output, Instant timestamp) {
            this.outputWithTimestamp(SimpleDoFnRunner.this.mainOutputTag, output, timestamp);
        }

        public <T> void output(TupleTag<T> tag, T output) {
            SimpleDoFnRunner.this.outputWindowedValue(tag, WindowedValue.of(output, (Instant)this.timestamp, (BoundedWindow)this.window(), (PaneInfo)PaneInfo.NO_FIRING));
        }

        public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
            SimpleDoFnRunner.this.outputWindowedValue(tag, WindowedValue.of(output, (Instant)timestamp, (BoundedWindow)this.window(), (PaneInfo)PaneInfo.NO_FIRING));
        }

        public DoFn.BundleFinalizer bundleFinalizer() {
            throw new UnsupportedOperationException("Bundle finalization is not supported in non-portable pipelines.");
        }
    }

    private class OnTimerArgumentProvider<KeyT>
    extends DoFn.OnTimerContext
    implements DoFnInvoker.ArgumentProvider<InputT, OutputT> {
        private final BoundedWindow window;
        private final Instant fireTimestamp;
        private final Instant timestamp;
        private final TimeDomain timeDomain;
        private final String timerId;
        private final KeyT key;
        private @Nullable StateNamespace namespace;

        private StateNamespace getNamespace() {
            if (this.namespace == null) {
                this.namespace = StateNamespaces.window(SimpleDoFnRunner.this.windowCoder, this.window);
            }
            return this.namespace;
        }

        private OnTimerArgumentProvider(String timerId, KeyT key, BoundedWindow window, Instant fireTimestamp, Instant timestamp, TimeDomain timeDomain) {
            super(SimpleDoFnRunner.this.fn);
            this.timerId = timerId;
            this.window = window;
            this.fireTimestamp = fireTimestamp;
            this.timestamp = timestamp;
            this.timeDomain = timeDomain;
            this.key = key;
        }

        public Instant timestamp() {
            return this.timestamp;
        }

        public Instant fireTimestamp() {
            return this.fireTimestamp;
        }

        public BoundedWindow window() {
            return this.window;
        }

        public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Cannot access paneInfo outside of @ProcessElement methods.");
        }

        public PipelineOptions pipelineOptions() {
            return this.getPipelineOptions();
        }

        public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("StartBundleContext parameters are not supported.");
        }

        public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("FinishBundleContext parameters are not supported.");
        }

        public TimeDomain timeDomain() {
            return this.timeDomain;
        }

        public KeyT key() {
            return this.key;
        }

        public DoFn.ProcessContext processContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("ProcessContext parameters are not supported.");
        }

        public InputT element(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Element parameters are not supported.");
        }

        public Object sideInput(String tagId) {
            throw new UnsupportedOperationException("SideInput parameters are not supported.");
        }

        public Object schemaElement(int index) {
            throw new UnsupportedOperationException("Element parameters are not supported.");
        }

        public Instant timestamp(DoFn<InputT, OutputT> doFn) {
            return this.timestamp();
        }

        public String timerId(DoFn<InputT, OutputT> doFn) {
            return this.timerId;
        }

        public TimeDomain timeDomain(DoFn<InputT, OutputT> doFn) {
            return this.timeDomain();
        }

        public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> doFn) {
            return DoFnOutputReceivers.windowedReceiver((DoFn.WindowedContext)this, (TupleTag)SimpleDoFnRunner.this.mainOutputTag);
        }

        public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn<InputT, OutputT> doFn) {
            return DoFnOutputReceivers.rowReceiver((DoFn.WindowedContext)this, (TupleTag)SimpleDoFnRunner.this.mainOutputTag, SimpleDoFnRunner.this.mainOutputSchemaCoder);
        }

        public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> doFn) {
            return DoFnOutputReceivers.windowedMultiReceiver((DoFn.WindowedContext)this, (Map)SimpleDoFnRunner.this.outputCoders);
        }

        public Object restriction() {
            throw new UnsupportedOperationException("@Restriction parameters are not supported.");
        }

        public DoFn.OnTimerContext onTimerContext(DoFn<InputT, OutputT> doFn) {
            return this;
        }

        public RestrictionTracker<?, ?> restrictionTracker() {
            throw new UnsupportedOperationException("RestrictionTracker parameters are not supported.");
        }

        public Object watermarkEstimatorState() {
            throw new UnsupportedOperationException("@WatermarkEstimatorState parameters are not supported.");
        }

        public WatermarkEstimator<?> watermarkEstimator() {
            throw new UnsupportedOperationException("WatermarkEstimator parameters are not supported.");
        }

        public State state(String stateId, boolean alwaysFetched) {
            try {
                StateSpec spec = (StateSpec)((DoFnSignature.StateDeclaration)SimpleDoFnRunner.this.signature.stateDeclarations().get(stateId)).field().get(SimpleDoFnRunner.this.fn);
                Object state = SimpleDoFnRunner.this.stepContext.stateInternals().state(this.getNamespace(), StateTags.tagForSpec(stateId, spec));
                if (alwaysFetched) {
                    return (State)((ReadableState)state).readLater();
                }
                return state;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Timer timer(String timerId) {
            try {
                TimerSpec spec = (TimerSpec)((DoFnSignature.TimerDeclaration)SimpleDoFnRunner.this.signature.timerDeclarations().get(timerId)).field().get(SimpleDoFnRunner.this.fn);
                return new TimerInternalsTimer(this.window, this.getNamespace(), timerId, spec, this.timestamp(), SimpleDoFnRunner.this.stepContext.timerInternals());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public TimerMap timerFamily(String timerFamilyId) {
            try {
                TimerSpec spec = (TimerSpec)((DoFnSignature.TimerFamilyDeclaration)SimpleDoFnRunner.this.signature.timerFamilyDeclarations().get(timerFamilyId)).field().get(SimpleDoFnRunner.this.fn);
                return new TimerInternalsTimerMap(timerFamilyId, this.window(), this.getNamespace(), spec, this.timestamp(), SimpleDoFnRunner.this.stepContext.timerInternals());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public PipelineOptions getPipelineOptions() {
            return SimpleDoFnRunner.this.options;
        }

        public void output(OutputT output) {
            this.output(SimpleDoFnRunner.this.mainOutputTag, output);
        }

        public void outputWithTimestamp(OutputT output, Instant timestamp) {
            this.outputWithTimestamp(SimpleDoFnRunner.this.mainOutputTag, output, timestamp);
        }

        public <T> void output(TupleTag<T> tag, T output) {
            SimpleDoFnRunner.this.outputWindowedValue(tag, WindowedValue.of(output, (Instant)this.timestamp, (BoundedWindow)this.window(), (PaneInfo)PaneInfo.NO_FIRING));
        }

        public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
            SimpleDoFnRunner.this.outputWindowedValue(tag, WindowedValue.of(output, (Instant)timestamp, (BoundedWindow)this.window(), (PaneInfo)PaneInfo.NO_FIRING));
        }

        public DoFn.BundleFinalizer bundleFinalizer() {
            throw new UnsupportedOperationException("Bundle finalization is not supported in non-portable pipelines.");
        }
    }

    private class DoFnProcessContext
    extends DoFn.ProcessContext
    implements DoFnInvoker.ArgumentProvider<InputT, OutputT> {
        final WindowedValue<InputT> elem;
        private @Nullable StateNamespace namespace;

        private StateNamespace getNamespace() {
            if (this.namespace == null) {
                this.namespace = StateNamespaces.window(SimpleDoFnRunner.this.windowCoder, this.window());
            }
            return this.namespace;
        }

        private DoFnProcessContext(WindowedValue<InputT> elem) {
            super(SimpleDoFnRunner.this.fn);
            this.elem = elem;
        }

        public PipelineOptions getPipelineOptions() {
            return SimpleDoFnRunner.this.options;
        }

        public InputT element() {
            return this.elem.getValue();
        }

        public <T> T sideInput(PCollectionView<T> view) {
            Preconditions.checkNotNull(view, (Object)"View passed to sideInput cannot be null");
            BoundedWindow window = (BoundedWindow)Iterables.getOnlyElement(this.windows());
            return (T)SimpleDoFnRunner.this.sideInput(view, view.getWindowMappingFn().getSideInputWindow(window));
        }

        public PaneInfo pane() {
            return this.elem.getPane();
        }

        public void output(OutputT output) {
            this.output(SimpleDoFnRunner.this.mainOutputTag, output);
        }

        public void outputWithTimestamp(OutputT output, Instant timestamp) {
            this.checkTimestamp(timestamp);
            this.outputWithTimestamp(SimpleDoFnRunner.this.mainOutputTag, output, timestamp);
        }

        public <T> void output(TupleTag<T> tag, T output) {
            Preconditions.checkNotNull(tag, (Object)"Tag passed to output cannot be null");
            SimpleDoFnRunner.this.outputWindowedValue(tag, this.elem.withValue(output));
        }

        public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
            Preconditions.checkNotNull(tag, (Object)"Tag passed to outputWithTimestamp cannot be null");
            this.checkTimestamp(timestamp);
            SimpleDoFnRunner.this.outputWindowedValue(tag, WindowedValue.of(output, (Instant)timestamp, (Collection)this.elem.getWindows(), (PaneInfo)this.elem.getPane()));
        }

        public Instant timestamp() {
            return this.elem.getTimestamp();
        }

        public Collection<? extends BoundedWindow> windows() {
            return this.elem.getWindows();
        }

        private void checkTimestamp(Instant timestamp) {
            if (SimpleDoFnRunner.this.fn.getAllowedTimestampSkew().getMillis() != Long.MAX_VALUE && timestamp.isBefore((ReadableInstant)this.elem.getTimestamp().minus((ReadableDuration)SimpleDoFnRunner.this.fn.getAllowedTimestampSkew()))) {
                throw new IllegalArgumentException(String.format("Cannot output with timestamp %s. Output timestamps must be no earlier than the timestamp of the current input (%s) minus the allowed skew (%s). See the DoFn#getAllowedTimestampSkew() Javadoc for details on changing the allowed skew.", timestamp, this.elem.getTimestamp(), PeriodFormat.getDefault().print((ReadablePeriod)SimpleDoFnRunner.this.fn.getAllowedTimestampSkew().toPeriod())));
            }
        }

        public BoundedWindow window() {
            return (BoundedWindow)Iterables.getOnlyElement((Iterable)this.elem.getWindows());
        }

        public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
            return this.pane();
        }

        public PipelineOptions pipelineOptions() {
            return this.getPipelineOptions();
        }

        public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("StartBundleContext parameters are not supported.");
        }

        public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("FinishBundleContext parameters are not supported.");
        }

        public DoFn.ProcessContext processContext(DoFn<InputT, OutputT> doFn) {
            return this;
        }

        public InputT element(DoFn<InputT, OutputT> doFn) {
            return this.element();
        }

        public Object key() {
            throw new UnsupportedOperationException("Cannot access key as parameter outside of @OnTimer method.");
        }

        public Object sideInput(String tagId) {
            return this.sideInput((PCollectionView)SimpleDoFnRunner.this.sideInputMapping.get(tagId));
        }

        public Object schemaElement(int index) {
            SerializableFunction converter = (SerializableFunction)SimpleDoFnRunner.this.doFnSchemaInformation.getElementConverters().get(index);
            return converter.apply(this.element());
        }

        public Instant timestamp(DoFn<InputT, OutputT> doFn) {
            return this.timestamp();
        }

        public String timerId(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Cannot access timerId as parameter outside of @OnTimer method.");
        }

        public TimeDomain timeDomain(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Cannot access time domain outside of @ProcessTimer method.");
        }

        public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> doFn) {
            return DoFnOutputReceivers.windowedReceiver((DoFn.WindowedContext)this, (TupleTag)SimpleDoFnRunner.this.mainOutputTag);
        }

        public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn<InputT, OutputT> doFn) {
            return DoFnOutputReceivers.rowReceiver((DoFn.WindowedContext)this, (TupleTag)SimpleDoFnRunner.this.mainOutputTag, SimpleDoFnRunner.this.mainOutputSchemaCoder);
        }

        public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> doFn) {
            return DoFnOutputReceivers.windowedMultiReceiver((DoFn.WindowedContext)this, (Map)SimpleDoFnRunner.this.outputCoders);
        }

        public Object restriction() {
            throw new UnsupportedOperationException("@Restriction parameters are not supported. Only the RestrictionTracker is accessible.");
        }

        public DoFn.OnTimerContext onTimerContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Cannot access OnTimerContext outside of @OnTimer methods.");
        }

        public RestrictionTracker<?, ?> restrictionTracker() {
            throw new UnsupportedOperationException("RestrictionTracker parameters are not supported.");
        }

        public Object watermarkEstimatorState() {
            throw new UnsupportedOperationException("@WatermarkEstimatorState parameters are not supported.");
        }

        public WatermarkEstimator<?> watermarkEstimator() {
            throw new UnsupportedOperationException("WatermarkEstimator parameters are not supported.");
        }

        public State state(String stateId, boolean alwaysFetched) {
            try {
                StateSpec spec = (StateSpec)((DoFnSignature.StateDeclaration)SimpleDoFnRunner.this.signature.stateDeclarations().get(stateId)).field().get(SimpleDoFnRunner.this.fn);
                Object state = SimpleDoFnRunner.this.stepContext.stateInternals().state(this.getNamespace(), StateTags.tagForSpec(stateId, spec));
                if (alwaysFetched) {
                    return (State)((ReadableState)state).readLater();
                }
                return state;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Timer timer(String timerId) {
            try {
                TimerSpec spec = (TimerSpec)((DoFnSignature.TimerDeclaration)SimpleDoFnRunner.this.signature.timerDeclarations().get(timerId)).field().get(SimpleDoFnRunner.this.fn);
                return new TimerInternalsTimer(this.window(), this.getNamespace(), timerId, spec, this.timestamp(), SimpleDoFnRunner.this.stepContext.timerInternals());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public TimerMap timerFamily(String timerFamilyId) {
            try {
                TimerSpec spec = (TimerSpec)((DoFnSignature.TimerFamilyDeclaration)SimpleDoFnRunner.this.signature.timerFamilyDeclarations().get(timerFamilyId)).field().get(SimpleDoFnRunner.this.fn);
                return new TimerInternalsTimerMap(timerFamilyId, this.window(), this.getNamespace(), spec, this.timestamp(), SimpleDoFnRunner.this.stepContext.timerInternals());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public DoFn.BundleFinalizer bundleFinalizer() {
            return SimpleDoFnRunner.this.stepContext.bundleFinalizer();
        }
    }

    private class DoFnFinishBundleArgumentProvider
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT> {
        private final org.apache.beam.repackaged.direct_java.runners.core.SimpleDoFnRunner$DoFnFinishBundleArgumentProvider.Context context = new Context();

        private DoFnFinishBundleArgumentProvider() {
        }

        public PipelineOptions pipelineOptions() {
            return SimpleDoFnRunner.this.options;
        }

        public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
            return this.context;
        }

        public String getErrorContext() {
            return "SimpleDoFnRunner/FinishBundle";
        }

        private class Context
        extends DoFn.FinishBundleContext {
            private Context() {
                super(SimpleDoFnRunner.this.fn);
            }

            public PipelineOptions getPipelineOptions() {
                return SimpleDoFnRunner.this.options;
            }

            public void output(OutputT output, Instant timestamp, BoundedWindow window) {
                this.output(SimpleDoFnRunner.this.mainOutputTag, output, timestamp, window);
            }

            public <T> void output(TupleTag<T> tag, T output, Instant timestamp, BoundedWindow window) {
                SimpleDoFnRunner.this.outputWindowedValue(tag, WindowedValue.of(output, (Instant)timestamp, (BoundedWindow)window, (PaneInfo)PaneInfo.NO_FIRING));
            }
        }
    }

    private class DoFnStartBundleArgumentProvider
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT> {
        private final org.apache.beam.repackaged.direct_java.runners.core.SimpleDoFnRunner$DoFnStartBundleArgumentProvider.Context context = new Context();

        private DoFnStartBundleArgumentProvider() {
        }

        public PipelineOptions pipelineOptions() {
            return SimpleDoFnRunner.this.options;
        }

        public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
            return this.context;
        }

        public String getErrorContext() {
            return "SimpleDoFnRunner/StartBundle";
        }

        private class Context
        extends DoFn.StartBundleContext {
            private Context() {
                super(SimpleDoFnRunner.this.fn);
            }

            public PipelineOptions getPipelineOptions() {
                return SimpleDoFnRunner.this.options;
            }
        }
    }
}

