/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import org.apache.beam.repackaged.direct_java.runners.core.MergingStateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.StateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.repackaged.direct_java.runners.core.StateTags;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.DefaultTriggerStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.FinishedTriggers;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.FinishedTriggersBitSet;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachineContextFactory;
import org.apache.beam.sdk.coders.BitSetCoder;
import org.apache.beam.sdk.state.Timers;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

public class TriggerStateMachineRunner<W extends BoundedWindow> {
    @VisibleForTesting
    public static final StateTag<ValueState<BitSet>> FINISHED_BITS_TAG = StateTags.makeSystemTagInternal(StateTags.value("closed", BitSetCoder.of()));
    private final ExecutableTriggerStateMachine rootTrigger;
    private final TriggerStateMachineContextFactory<W> contextFactory;

    public TriggerStateMachineRunner(ExecutableTriggerStateMachine rootTrigger, TriggerStateMachineContextFactory<W> contextFactory) {
        Preconditions.checkState((rootTrigger.getTriggerIndex() == 0 ? 1 : 0) != 0);
        this.rootTrigger = rootTrigger;
        this.contextFactory = contextFactory;
    }

    private FinishedTriggersBitSet readFinishedBits(ValueState<BitSet> state) {
        if (!this.isFinishedSetNeeded()) {
            return FinishedTriggersBitSet.emptyWithCapacity(this.rootTrigger.getFirstIndexAfterSubtree());
        }
        @Nullable BitSet bitSet = (BitSet)state.read();
        return bitSet == null ? FinishedTriggersBitSet.emptyWithCapacity(this.rootTrigger.getFirstIndexAfterSubtree()) : FinishedTriggersBitSet.fromBitSet(bitSet);
    }

    private void clearFinishedBits(ValueState<BitSet> state) {
        if (!this.isFinishedSetNeeded()) {
            return;
        }
        state.clear();
    }

    public boolean isClosed(StateAccessor<?> state) {
        return this.readFinishedBits(state.access(FINISHED_BITS_TAG)).isFinished(this.rootTrigger);
    }

    public void prefetchIsClosed(StateAccessor<?> state) {
        if (this.isFinishedSetNeeded()) {
            state.access(FINISHED_BITS_TAG).readLater();
        }
    }

    public void prefetchForValue(W window, StateAccessor<?> state) {
        this.prefetchIsClosed(state);
        this.rootTrigger.getSpec().prefetchOnElement(this.contextFactory.createStateAccessor(window, this.rootTrigger));
    }

    public void prefetchOnFire(W window, StateAccessor<?> state) {
        this.prefetchIsClosed(state);
        this.rootTrigger.getSpec().prefetchOnFire(this.contextFactory.createStateAccessor(window, this.rootTrigger));
    }

    public void prefetchShouldFire(W window, StateAccessor<?> state) {
        this.prefetchIsClosed(state);
        this.rootTrigger.getSpec().prefetchShouldFire(this.contextFactory.createStateAccessor(window, this.rootTrigger));
    }

    public void processValue(W window, Instant timestamp, Timers timers, StateAccessor<?> state) throws Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG)).copy();
        TriggerStateMachine.OnElementContext triggerContext = this.contextFactory.createOnElementContext(window, timers, timestamp, this.rootTrigger, finishedSet);
        this.rootTrigger.invokeOnElement(triggerContext);
        this.persistFinishedSet(state, finishedSet);
    }

    public void prefetchForMerge(W window, Collection<W> mergingWindows, MergingStateAccessor<?, W> state) {
        if (this.isFinishedSetNeeded()) {
            for (ValueState<BitSet> value : state.accessInEachMergingWindow(FINISHED_BITS_TAG).values()) {
                value.readLater();
            }
        }
        this.rootTrigger.getSpec().prefetchOnMerge(this.contextFactory.createMergingStateAccessor(window, mergingWindows, this.rootTrigger));
    }

    public void onMerge(W window, Timers timers, MergingStateAccessor<?, W> state) throws Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG)).copy();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<W, ValueState<BitSet>> entry : state.accessInEachMergingWindow(FINISHED_BITS_TAG).entrySet()) {
            builder.put((Object)((BoundedWindow)entry.getKey()), (Object)this.readFinishedBits(entry.getValue()));
            this.clearFinishedBits(entry.getValue());
        }
        ImmutableMap mergingFinishedSets = builder.build();
        TriggerStateMachine.OnMergeContext mergeContext = this.contextFactory.createOnMergeContext(window, timers, this.rootTrigger, finishedSet, (Map<W, FinishedTriggers>)mergingFinishedSets);
        this.rootTrigger.invokeOnMerge(mergeContext);
        this.persistFinishedSet(state, finishedSet);
    }

    public boolean shouldFire(W window, Timers timers, StateAccessor<?> state) throws Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG)).copy();
        TriggerStateMachine.TriggerContext context = this.contextFactory.base(window, timers, this.rootTrigger, finishedSet);
        return this.rootTrigger.invokeShouldFire(context);
    }

    public void onFire(W window, Timers timers, StateAccessor<?> state) throws Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG)).copy();
        TriggerStateMachine.TriggerContext context = this.contextFactory.base(window, timers, this.rootTrigger, finishedSet);
        this.rootTrigger.invokeOnFire(context);
        this.persistFinishedSet(state, finishedSet);
    }

    private void persistFinishedSet(StateAccessor<?> state, FinishedTriggersBitSet modifiedFinishedSet) {
        if (!this.isFinishedSetNeeded()) {
            return;
        }
        ValueState<BitSet> finishedSetState = state.access(FINISHED_BITS_TAG);
        if (!this.readFinishedBits(finishedSetState).equals(modifiedFinishedSet)) {
            if (modifiedFinishedSet.getBitSet().isEmpty()) {
                finishedSetState.clear();
            } else {
                finishedSetState.write((Object)modifiedFinishedSet.getBitSet());
            }
        }
    }

    public void clearFinished(StateAccessor<?> state) {
        this.clearFinishedBits(state.access(FINISHED_BITS_TAG));
    }

    public void clearState(W window, Timers timers, StateAccessor<?> state) throws Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG));
        this.rootTrigger.invokeClear(this.contextFactory.base(window, timers, this.rootTrigger, finishedSet));
    }

    private boolean isFinishedSetNeeded() {
        return !(this.rootTrigger.getSpec() instanceof DefaultTriggerStateMachine);
    }
}

