/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.List;
import java.util.Objects;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.NeverStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.ReadableInstant;

public class AfterWatermarkStateMachine {
    private static final String TO_STRING = "AfterWatermark.pastEndOfWindow()";

    private AfterWatermarkStateMachine() {
    }

    public static FromEndOfWindow pastEndOfWindow() {
        return new FromEndOfWindow();
    }

    public static class FromEndOfWindow
    extends TriggerStateMachine {
        private FromEndOfWindow() {
            super(null);
        }

        public AfterWatermarkEarlyAndLate withEarlyFirings(TriggerStateMachine earlyFirings) {
            Preconditions.checkNotNull((Object)earlyFirings, (Object)"Must specify the trigger to use for early firings");
            return new AfterWatermarkEarlyAndLate(earlyFirings, null);
        }

        public AfterWatermarkEarlyAndLate withLateFirings(TriggerStateMachine lateFirings) {
            Preconditions.checkNotNull((Object)lateFirings, (Object)"Must specify the trigger to use for late firings");
            return new AfterWatermarkEarlyAndLate(NeverStateMachine.ever(), lateFirings);
        }

        @Override
        public void onElement(TriggerStateMachine.OnElementContext c) throws Exception {
            if (!this.endOfWindowReached(c)) {
                c.setTimer(c.window().maxTimestamp(), TimeDomain.EVENT_TIME);
            }
        }

        @Override
        public void onMerge(TriggerStateMachine.OnMergeContext c) throws Exception {
            if (!c.trigger().finishedInAllMergingWindows()) {
                c.trigger().setFinished(false);
            } else if (!this.endOfWindowReached(c)) {
                c.trigger().setFinished(false);
            } else {
                c.trigger().setFinished(true);
            }
        }

        @Override
        public String toString() {
            return AfterWatermarkStateMachine.TO_STRING;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof FromEndOfWindow;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getClass());
        }

        @Override
        public boolean shouldFire(TriggerStateMachine.TriggerContext context) throws Exception {
            return this.endOfWindowReached(context);
        }

        private boolean endOfWindowReached(TriggerStateMachine.TriggerContext context) {
            return context.currentEventTime() != null && context.currentEventTime().isAfter((ReadableInstant)context.window().maxTimestamp());
        }

        @Override
        public void onFire(TriggerStateMachine.TriggerContext context) throws Exception {
            context.trigger().setFinished(true);
        }
    }

    public static class AfterWatermarkEarlyAndLate
    extends TriggerStateMachine {
        private static final int EARLY_INDEX = 0;
        private static final int LATE_INDEX = 1;
        private final TriggerStateMachine earlyTrigger;
        private final @Nullable TriggerStateMachine lateTrigger;

        private AfterWatermarkEarlyAndLate(TriggerStateMachine earlyTrigger, TriggerStateMachine lateTrigger) {
            super((List<TriggerStateMachine>)(lateTrigger == null ? ImmutableList.of((Object)earlyTrigger) : ImmutableList.of((Object)earlyTrigger, (Object)lateTrigger)));
            this.earlyTrigger = (TriggerStateMachine)Preconditions.checkNotNull((Object)earlyTrigger, (Object)"earlyTrigger should not be null");
            this.lateTrigger = lateTrigger;
        }

        public AfterWatermarkEarlyAndLate withEarlyFirings(TriggerStateMachine earlyTrigger) {
            return new AfterWatermarkEarlyAndLate(earlyTrigger, this.lateTrigger);
        }

        public AfterWatermarkEarlyAndLate withLateFirings(TriggerStateMachine lateTrigger) {
            return new AfterWatermarkEarlyAndLate(this.earlyTrigger, lateTrigger);
        }

        @Override
        public void onElement(TriggerStateMachine.OnElementContext c) throws Exception {
            if (!this.endOfWindowReached(c)) {
                c.setTimer(c.window().maxTimestamp(), TimeDomain.EVENT_TIME);
            }
            if (!c.trigger().isMerging()) {
                c.trigger().firstUnfinishedSubTrigger().invokeOnElement(c);
            } else {
                for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
                    subTrigger.invokeOnElement(c);
                }
            }
        }

        @Override
        public void onMerge(TriggerStateMachine.OnMergeContext c) throws Exception {
            ExecutableTriggerStateMachine earlySubtrigger = c.trigger().subTrigger(0);
            TriggerStateMachine.OnMergeContext earlyContext = c.forTrigger(earlySubtrigger);
            if (!earlyContext.trigger().finishedInAllMergingWindows() || !this.endOfWindowReached(c)) {
                earlySubtrigger.invokeOnMerge(earlyContext);
                earlyContext.trigger().setFinished(false);
                if (this.lateTrigger != null) {
                    ExecutableTriggerStateMachine lateSubtrigger = c.trigger().subTrigger(1);
                    TriggerStateMachine.OnMergeContext lateContext = c.forTrigger(lateSubtrigger);
                    lateContext.trigger().setFinished(false);
                    lateSubtrigger.invokeClear(lateContext);
                }
            } else {
                earlyContext.trigger().setFinished(true);
                if (this.lateTrigger != null) {
                    c.trigger().subTrigger(1).invokeOnMerge(c);
                }
            }
        }

        private boolean endOfWindowReached(TriggerStateMachine.TriggerContext context) {
            return context.currentEventTime() != null && context.currentEventTime().isAfter((ReadableInstant)context.window().maxTimestamp());
        }

        @Override
        public boolean shouldFire(TriggerStateMachine.TriggerContext context) throws Exception {
            if (!context.trigger().isFinished(0)) {
                return context.trigger().subTrigger(0).invokeShouldFire(context) || this.endOfWindowReached(context);
            }
            if (this.lateTrigger == null) {
                return false;
            }
            return context.trigger().subTrigger(1).invokeShouldFire(context);
        }

        @Override
        public void onFire(TriggerStateMachine.TriggerContext context) throws Exception {
            if (!context.forTrigger(context.trigger().subTrigger(0)).trigger().isFinished()) {
                this.onNonLateFiring(context);
            } else if (this.lateTrigger != null) {
                this.onLateFiring(context);
            } else {
                context.trigger().setFinished(true);
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(AfterWatermarkStateMachine.TO_STRING);
            if (!(this.earlyTrigger instanceof NeverStateMachine)) {
                builder.append(".withEarlyFirings(").append(this.earlyTrigger).append(")");
            }
            if (this.lateTrigger != null && !(this.lateTrigger instanceof NeverStateMachine)) {
                builder.append(".withLateFirings(").append(this.lateTrigger).append(")");
            }
            return builder.toString();
        }

        private void onNonLateFiring(TriggerStateMachine.TriggerContext context) throws Exception {
            ExecutableTriggerStateMachine earlySubtrigger = context.trigger().subTrigger(0);
            TriggerStateMachine.TriggerContext earlyContext = context.forTrigger(earlySubtrigger);
            if (!this.endOfWindowReached(context)) {
                earlySubtrigger.invokeOnFire(context);
                earlySubtrigger.invokeClear(context);
                earlyContext.trigger().setFinished(false);
            } else {
                if (earlySubtrigger.invokeShouldFire(context)) {
                    earlySubtrigger.invokeOnFire(context);
                }
                earlyContext.trigger().setFinished(true);
                earlySubtrigger.invokeClear(context);
                if (this.lateTrigger == null) {
                    context.trigger().setFinished(true);
                } else {
                    context.trigger().subTrigger(1).invokeClear(context);
                }
            }
        }

        private void onLateFiring(TriggerStateMachine.TriggerContext context) throws Exception {
            ExecutableTriggerStateMachine lateSubtrigger = context.trigger().subTrigger(1);
            lateSubtrigger.invokeOnFire(context);
            lateSubtrigger.invokeClear(context);
            context.forTrigger(lateSubtrigger).trigger().setFinished(false);
        }
    }
}

