/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.direct_java.runners.core.OutputWindowedValue;
import org.apache.beam.repackaged.direct_java.runners.core.SideInputReader;
import org.apache.beam.repackaged.direct_java.runners.core.SplittableProcessElementInvoker;
import org.apache.beam.repackaged.direct_java.sdk.fn.splittabledofn.RestrictionTrackers;
import org.apache.beam.repackaged.direct_java.sdk.fn.splittabledofn.WatermarkEstimators;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnOutputReceivers;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.TimestampObservingWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Futures;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class OutputAndTimeBoundedSplittableProcessElementInvoker<InputT, OutputT, RestrictionT, PositionT, WatermarkEstimatorStateT>
extends SplittableProcessElementInvoker<InputT, OutputT, RestrictionT, PositionT, WatermarkEstimatorStateT> {
    private final DoFn<InputT, OutputT> fn;
    private final PipelineOptions pipelineOptions;
    private final OutputWindowedValue<OutputT> output;
    private final SideInputReader sideInputReader;
    private final ScheduledExecutorService executor;
    private final int maxNumOutputs;
    private final Duration maxDuration;

    public OutputAndTimeBoundedSplittableProcessElementInvoker(DoFn<InputT, OutputT> fn, PipelineOptions pipelineOptions, OutputWindowedValue<OutputT> output, SideInputReader sideInputReader, ScheduledExecutorService executor, int maxNumOutputs, Duration maxDuration) {
        this.fn = fn;
        this.pipelineOptions = pipelineOptions;
        this.output = output;
        this.sideInputReader = sideInputReader;
        this.executor = executor;
        this.maxNumOutputs = maxNumOutputs;
        this.maxDuration = maxDuration;
    }

    @Override
    public SplittableProcessElementInvoker.Result invokeProcessElement(DoFnInvoker<InputT, OutputT> invoker, WindowedValue<InputT> element, final RestrictionTracker<RestrictionT, PositionT> tracker, WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator) {
        final ProcessContext processContext = new ProcessContext(element, tracker, watermarkEstimator);
        DoFn.ProcessContinuation cont = invoker.invokeProcessElement((DoFnInvoker.ArgumentProvider)new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

            public String getErrorContext() {
                return OutputAndTimeBoundedSplittableProcessElementInvoker.class.getSimpleName();
            }

            public DoFn.ProcessContext processContext(DoFn<InputT, OutputT> doFn) {
                return processContext;
            }

            public Object restriction() {
                return tracker.currentRestriction();
            }

            public InputT element(DoFn<InputT, OutputT> doFn) {
                return processContext.element();
            }

            public Instant timestamp(DoFn<InputT, OutputT> doFn) {
                return processContext.timestamp();
            }

            public String timerId(DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException("Cannot access timerId as parameter outside of @OnTimer method.");
            }

            public TimeDomain timeDomain(DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException("Access to time domain not supported in ProcessElement");
            }

            public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> doFn) {
                return DoFnOutputReceivers.windowedReceiver((DoFn.WindowedContext)processContext, null);
            }

            public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException("Not supported in SplittableDoFn");
            }

            public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> doFn) {
                return DoFnOutputReceivers.windowedMultiReceiver((DoFn.WindowedContext)processContext, null);
            }

            public RestrictionTracker<?, ?> restrictionTracker() {
                return processContext.tracker;
            }

            public WatermarkEstimator<?> watermarkEstimator() {
                return processContext.watermarkEstimator;
            }

            public PipelineOptions pipelineOptions() {
                return OutputAndTimeBoundedSplittableProcessElementInvoker.this.pipelineOptions;
            }

            public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException("Should not access startBundleContext() from @" + DoFn.ProcessElement.class.getSimpleName());
            }

            public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException("Should not access finishBundleContext() from @" + DoFn.ProcessElement.class.getSimpleName());
            }
        });
        processContext.cancelScheduledCheckpoint();
        KV residual = processContext.getTakenCheckpoint();
        if (cont.shouldResume()) {
            Preconditions.checkState((!processContext.hasClaimFailed ? 1 : 0) != 0, (Object)"After tryClaim() returned false, @ProcessElement must return stop(), but returned resume()");
            if (residual == null) {
                residual = processContext.takeCheckpointNow();
                processContext.tracker.checkDone();
            } else {
                processContext.tracker.checkDone();
            }
        } else {
            processContext.tracker.checkDone();
        }
        if (residual == null) {
            return new SplittableProcessElementInvoker.Result(this, null, cont, null, null);
        }
        return new SplittableProcessElementInvoker.Result(this, residual.getKey(), cont, (Instant)((KV)residual.getValue()).getKey(), ((KV)residual.getValue()).getValue());
    }

    private class ProcessContext
    extends DoFn.ProcessContext
    implements RestrictionTrackers.ClaimObserver<PositionT> {
        private final WindowedValue<InputT> element;
        private final RestrictionTracker<RestrictionT, PositionT> tracker;
        private final WatermarkEstimators.WatermarkAndStateObserver<WatermarkEstimatorStateT> watermarkEstimator;
        private int numClaimedBlocks;
        private boolean hasClaimFailed;
        private int numOutputs;
        @Nullable
        private RestrictionT checkpoint;
        @Nullable
        private KV<Instant, WatermarkEstimatorStateT> residualWatermarkAndState;
        @Nullable
        private Future<?> scheduledCheckpoint;

        public ProcessContext(WindowedValue<InputT> element, RestrictionTracker<RestrictionT, PositionT> tracker, WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator) {
            super(OutputAndTimeBoundedSplittableProcessElementInvoker.this.fn);
            this.element = element;
            this.tracker = RestrictionTrackers.observe(tracker, this);
            this.watermarkEstimator = WatermarkEstimators.threadSafe(watermarkEstimator);
        }

        @Override
        public void onClaimed(PositionT position) {
            Preconditions.checkState((!this.hasClaimFailed ? 1 : 0) != 0, (Object)"Must not call tryClaim() after it has previously returned false");
            if (this.numClaimedBlocks == 0) {
                this.scheduledCheckpoint = OutputAndTimeBoundedSplittableProcessElementInvoker.this.executor.schedule(this::takeCheckpointNow, OutputAndTimeBoundedSplittableProcessElementInvoker.this.maxDuration.getMillis(), TimeUnit.MILLISECONDS);
            }
            ++this.numClaimedBlocks;
        }

        @Override
        public void onClaimFailed(PositionT position) {
            Preconditions.checkState((!this.hasClaimFailed ? 1 : 0) != 0, (Object)"Must not call tryClaim() after it has previously returned false");
            this.hasClaimFailed = true;
        }

        void cancelScheduledCheckpoint() {
            if (this.scheduledCheckpoint == null) {
                return;
            }
            this.scheduledCheckpoint.cancel(true);
            try {
                Futures.getUnchecked(this.scheduledCheckpoint);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }

        synchronized KV<RestrictionT, KV<Instant, WatermarkEstimatorStateT>> takeCheckpointNow() {
            if (this.checkpoint == null) {
                this.residualWatermarkAndState = this.watermarkEstimator.getWatermarkAndState();
                SplitResult split = this.tracker.trySplit(0.0);
                if (split != null) {
                    this.checkpoint = Preconditions.checkNotNull((Object)split.getResidual());
                }
            }
            return this.getTakenCheckpoint();
        }

        @Nullable
        synchronized KV<RestrictionT, KV<Instant, WatermarkEstimatorStateT>> getTakenCheckpoint() {
            return this.checkpoint == null ? null : KV.of(this.checkpoint, this.residualWatermarkAndState);
        }

        public InputT element() {
            return this.element.getValue();
        }

        public <T> T sideInput(PCollectionView<T> view) {
            return OutputAndTimeBoundedSplittableProcessElementInvoker.this.sideInputReader.get(view, view.getWindowMappingFn().getSideInputWindow((BoundedWindow)Iterables.getOnlyElement((Iterable)this.element.getWindows())));
        }

        public Instant timestamp() {
            return this.element.getTimestamp();
        }

        public PaneInfo pane() {
            return this.element.getPane();
        }

        public PipelineOptions getPipelineOptions() {
            return OutputAndTimeBoundedSplittableProcessElementInvoker.this.pipelineOptions;
        }

        public void output(OutputT output) {
            this.outputWithTimestamp(output, this.element.getTimestamp());
        }

        public void outputWithTimestamp(OutputT value, Instant timestamp) {
            this.noteOutput();
            if (this.watermarkEstimator instanceof TimestampObservingWatermarkEstimator) {
                ((TimestampObservingWatermarkEstimator)this.watermarkEstimator).observeTimestamp(timestamp);
            }
            OutputAndTimeBoundedSplittableProcessElementInvoker.this.output.outputWindowedValue(value, timestamp, this.element.getWindows(), this.element.getPane());
        }

        public <T> void output(TupleTag<T> tag, T value) {
            this.outputWithTimestamp(tag, value, this.element.getTimestamp());
        }

        public <T> void outputWithTimestamp(TupleTag<T> tag, T value, Instant timestamp) {
            this.noteOutput();
            if (this.watermarkEstimator instanceof TimestampObservingWatermarkEstimator) {
                ((TimestampObservingWatermarkEstimator)this.watermarkEstimator).observeTimestamp(timestamp);
            }
            OutputAndTimeBoundedSplittableProcessElementInvoker.this.output.outputWindowedValue(tag, value, timestamp, this.element.getWindows(), this.element.getPane());
        }

        private void noteOutput() {
            Preconditions.checkState((!this.hasClaimFailed ? 1 : 0) != 0, (Object)"Output is not allowed after a failed tryClaim()");
            Preconditions.checkState((this.numClaimedBlocks > 0 ? 1 : 0) != 0, (Object)"Output is not allowed before tryClaim()");
            ++this.numOutputs;
            if (this.numOutputs >= OutputAndTimeBoundedSplittableProcessElementInvoker.this.maxNumOutputs) {
                this.takeCheckpointNow();
            }
        }
    }
}

