/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItem;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItems;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class KeyedWorkItemCoder<K, ElemT>
extends StructuredCoder<KeyedWorkItem<K, ElemT>> {
    private final Coder<K> keyCoder;
    private final Coder<ElemT> elemCoder;
    private final Coder<? extends BoundedWindow> windowCoder;
    private final Coder<Iterable<TimerInternals.TimerData>> timersCoder;
    private final Coder<Iterable<WindowedValue<ElemT>>> elemsCoder;

    public static <K, ElemT> KeyedWorkItemCoder<K, ElemT> of(Coder<K> keyCoder, Coder<ElemT> elemCoder, Coder<? extends BoundedWindow> windowCoder) {
        return new KeyedWorkItemCoder<K, ElemT>(keyCoder, elemCoder, windowCoder);
    }

    private KeyedWorkItemCoder(Coder<K> keyCoder, Coder<ElemT> elemCoder, Coder<? extends BoundedWindow> windowCoder) {
        this.keyCoder = keyCoder;
        this.elemCoder = elemCoder;
        this.windowCoder = windowCoder;
        this.timersCoder = IterableCoder.of((Coder)TimerInternals.TimerDataCoderV2.of(windowCoder));
        this.elemsCoder = IterableCoder.of((Coder)WindowedValue.FullWindowedValueCoder.of(elemCoder, windowCoder));
    }

    public Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    public Coder<ElemT> getElementCoder() {
        return this.elemCoder;
    }

    public void encode(KeyedWorkItem<K, ElemT> value, OutputStream outStream) throws CoderException, IOException {
        this.keyCoder.encode(value.key(), outStream);
        this.timersCoder.encode(value.timersIterable(), outStream);
        this.elemsCoder.encode(value.elementsIterable(), outStream);
    }

    public KeyedWorkItem<K, ElemT> decode(InputStream inStream) throws CoderException, IOException {
        Object key = this.keyCoder.decode(inStream);
        Iterable timers = (Iterable)this.timersCoder.decode(inStream);
        Iterable elems = (Iterable)this.elemsCoder.decode(inStream);
        return KeyedWorkItems.workItem(key, timers, elems);
    }

    public List<? extends Coder<?>> getCoderArguments() {
        return ImmutableList.of(this.keyCoder, this.elemCoder, this.windowCoder);
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.keyCoder.verifyDeterministic();
        this.timersCoder.verifyDeterministic();
        this.elemsCoder.verifyDeterministic();
    }

    public boolean consistentWithEquals() {
        return false;
    }
}

