/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Table;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class InMemoryTimerInternals
implements TimerInternals {
    Table<StateNamespace, String, TimerInternals.TimerData> existingTimers = HashBasedTable.create();
    private final NavigableSet<TimerInternals.TimerData> watermarkTimers = new TreeSet<TimerInternals.TimerData>();
    private final NavigableSet<TimerInternals.TimerData> processingTimers = new TreeSet<TimerInternals.TimerData>();
    private final NavigableSet<TimerInternals.TimerData> synchronizedProcessingTimers = new TreeSet<TimerInternals.TimerData>();
    private Instant inputWatermarkTime = BoundedWindow.TIMESTAMP_MIN_VALUE;
    @Nullable
    private Instant outputWatermarkTime = null;
    private Instant processingTime = BoundedWindow.TIMESTAMP_MIN_VALUE;
    private Instant synchronizedProcessingTime = BoundedWindow.TIMESTAMP_MIN_VALUE;

    @Override
    @Nullable
    public Instant currentOutputWatermarkTime() {
        return this.outputWatermarkTime;
    }

    public boolean hasPendingTimers() {
        return !this.existingTimers.isEmpty();
    }

    @Nullable
    public Instant getNextTimer(TimeDomain domain) {
        try {
            switch (domain) {
                case EVENT_TIME: {
                    return ((TimerInternals.TimerData)this.watermarkTimers.first()).getTimestamp();
                }
                case PROCESSING_TIME: {
                    return ((TimerInternals.TimerData)this.processingTimers.first()).getTimestamp();
                }
                case SYNCHRONIZED_PROCESSING_TIME: {
                    return ((TimerInternals.TimerData)this.synchronizedProcessingTimers.first()).getTimestamp();
                }
            }
            throw new IllegalArgumentException("Unexpected time domain: " + domain);
        }
        catch (NoSuchElementException exc) {
            return null;
        }
    }

    private NavigableSet<TimerInternals.TimerData> timersForDomain(TimeDomain domain) {
        switch (domain) {
            case EVENT_TIME: {
                return this.watermarkTimers;
            }
            case PROCESSING_TIME: {
                return this.processingTimers;
            }
            case SYNCHRONIZED_PROCESSING_TIME: {
                return this.synchronizedProcessingTimers;
            }
        }
        throw new IllegalArgumentException("Unexpected time domain: " + domain);
    }

    @Override
    public void setTimer(StateNamespace namespace, String timerId, String timerFamilyId, Instant target, Instant outputTimestamp, TimeDomain timeDomain) {
        this.setTimer(TimerInternals.TimerData.of(timerId, timerFamilyId, namespace, target, outputTimestamp, timeDomain));
    }

    @Override
    @Deprecated
    public void setTimer(TimerInternals.TimerData timerData) {
        WindowTracing.trace((String)"{}.setTimer: {}", (Object[])new Object[]{this.getClass().getSimpleName(), timerData});
        TimerInternals.TimerData existing = (TimerInternals.TimerData)this.existingTimers.get((Object)timerData.getNamespace(), (Object)(timerData.getTimerId() + '+' + timerData.getTimerFamilyId()));
        if (existing == null) {
            this.existingTimers.put((Object)timerData.getNamespace(), (Object)(timerData.getTimerId() + '+' + timerData.getTimerFamilyId()), (Object)timerData);
            this.timersForDomain(timerData.getDomain()).add(timerData);
        } else {
            Preconditions.checkArgument((boolean)timerData.getDomain().equals((Object)existing.getDomain()), (String)"Attempt to set %s for time domain %s, but it is already set for time domain %s", (Object)timerData.getTimerId(), (Object)timerData.getDomain(), (Object)existing.getDomain());
            if (!timerData.getTimestamp().equals((Object)existing.getTimestamp())) {
                NavigableSet<TimerInternals.TimerData> timers = this.timersForDomain(timerData.getDomain());
                timers.remove(existing);
                timers.add(timerData);
                this.existingTimers.put((Object)timerData.getNamespace(), (Object)(timerData.getTimerId() + '+' + timerData.getTimerFamilyId()), (Object)timerData);
            }
        }
    }

    @Override
    public void deleteTimer(StateNamespace namespace, String timerId, TimeDomain timeDomain) {
        throw new UnsupportedOperationException("Canceling a timer by ID is not yet supported.");
    }

    @Override
    @Deprecated
    public void deleteTimer(StateNamespace namespace, String timerId, String timerFamilyId) {
        TimerInternals.TimerData removedTimer = (TimerInternals.TimerData)this.existingTimers.remove((Object)namespace, (Object)(timerId + '+' + timerFamilyId));
        if (removedTimer != null) {
            this.timersForDomain(removedTimer.getDomain()).remove(removedTimer);
        }
    }

    @Override
    @Deprecated
    public void deleteTimer(TimerInternals.TimerData timer) {
        this.deleteTimer(timer.getNamespace(), timer.getTimerId(), timer.getTimerFamilyId());
    }

    @Override
    public Instant currentProcessingTime() {
        return this.processingTime;
    }

    @Override
    @Nullable
    public Instant currentSynchronizedProcessingTime() {
        return this.synchronizedProcessingTime;
    }

    @Override
    public Instant currentInputWatermarkTime() {
        return this.inputWatermarkTime;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("watermarkTimers", this.watermarkTimers).add("processingTimers", this.processingTimers).add("synchronizedProcessingTimers", this.synchronizedProcessingTimers).add("inputWatermarkTime", (Object)this.inputWatermarkTime).add("outputWatermarkTime", (Object)this.outputWatermarkTime).add("processingTime", (Object)this.processingTime).toString();
    }

    public void advanceInputWatermark(Instant newInputWatermark) throws Exception {
        Preconditions.checkNotNull((Object)newInputWatermark);
        Preconditions.checkState((!newInputWatermark.isBefore((ReadableInstant)this.inputWatermarkTime) ? 1 : 0) != 0, (String)"Cannot move input watermark time backwards from %s to %s", (Object)this.inputWatermarkTime, (Object)newInputWatermark);
        WindowTracing.trace((String)"{}.advanceInputWatermark: from {} to {}", (Object[])new Object[]{this.getClass().getSimpleName(), this.inputWatermarkTime, newInputWatermark});
        this.inputWatermarkTime = newInputWatermark;
    }

    public void advanceOutputWatermark(Instant newOutputWatermark) {
        Instant adjustedOutputWatermark;
        Preconditions.checkNotNull((Object)newOutputWatermark);
        if (newOutputWatermark.isAfter((ReadableInstant)this.inputWatermarkTime)) {
            WindowTracing.trace((String)"{}.advanceOutputWatermark: clipping output watermark from {} to {}", (Object[])new Object[]{this.getClass().getSimpleName(), newOutputWatermark, this.inputWatermarkTime});
            adjustedOutputWatermark = this.inputWatermarkTime;
        } else {
            adjustedOutputWatermark = newOutputWatermark;
        }
        Preconditions.checkState((this.outputWatermarkTime == null || !adjustedOutputWatermark.isBefore((ReadableInstant)this.outputWatermarkTime) ? 1 : 0) != 0, (String)"Cannot move output watermark time backwards from %s to %s", (Object)this.outputWatermarkTime, (Object)adjustedOutputWatermark);
        WindowTracing.trace((String)"{}.advanceOutputWatermark: from {} to {}", (Object[])new Object[]{this.getClass().getSimpleName(), this.outputWatermarkTime, adjustedOutputWatermark});
        this.outputWatermarkTime = adjustedOutputWatermark;
    }

    public void advanceProcessingTime(Instant newProcessingTime) throws Exception {
        Preconditions.checkNotNull((Object)newProcessingTime);
        Preconditions.checkState((!newProcessingTime.isBefore((ReadableInstant)this.processingTime) ? 1 : 0) != 0, (String)"Cannot move processing time backwards from %s to %s", (Object)this.processingTime, (Object)newProcessingTime);
        WindowTracing.trace((String)"{}.advanceProcessingTime: from {} to {}", (Object[])new Object[]{this.getClass().getSimpleName(), this.processingTime, newProcessingTime});
        this.processingTime = newProcessingTime;
    }

    public void advanceSynchronizedProcessingTime(Instant newSynchronizedProcessingTime) throws Exception {
        Preconditions.checkNotNull((Object)newSynchronizedProcessingTime);
        Preconditions.checkState((!newSynchronizedProcessingTime.isBefore((ReadableInstant)this.synchronizedProcessingTime) ? 1 : 0) != 0, (String)"Cannot move processing time backwards from %s to %s", (Object)this.synchronizedProcessingTime, (Object)newSynchronizedProcessingTime);
        WindowTracing.trace((String)"{}.advanceProcessingTime: from {} to {}", (Object[])new Object[]{this.getClass().getSimpleName(), this.synchronizedProcessingTime, newSynchronizedProcessingTime});
        this.synchronizedProcessingTime = newSynchronizedProcessingTime;
    }

    @Nullable
    public TimerInternals.TimerData removeNextEventTimer() {
        TimerInternals.TimerData timer = this.removeNextTimer(this.inputWatermarkTime, TimeDomain.EVENT_TIME);
        if (timer != null) {
            WindowTracing.trace((String)"{}.removeNextEventTimer: firing {} at {}", (Object[])new Object[]{this.getClass().getSimpleName(), timer, this.inputWatermarkTime});
        }
        return timer;
    }

    @Nullable
    public TimerInternals.TimerData removeNextProcessingTimer() {
        TimerInternals.TimerData timer = this.removeNextTimer(this.processingTime, TimeDomain.PROCESSING_TIME);
        if (timer != null) {
            WindowTracing.trace((String)"{}.removeNextProcessingTimer: firing {} at {}", (Object[])new Object[]{this.getClass().getSimpleName(), timer, this.processingTime});
        }
        return timer;
    }

    @Nullable
    public TimerInternals.TimerData removeNextSynchronizedProcessingTimer() {
        TimerInternals.TimerData timer = this.removeNextTimer(this.synchronizedProcessingTime, TimeDomain.SYNCHRONIZED_PROCESSING_TIME);
        if (timer != null) {
            WindowTracing.trace((String)"{}.removeNextSynchronizedProcessingTimer: firing {} at {}", (Object[])new Object[]{this.getClass().getSimpleName(), timer, this.synchronizedProcessingTime});
        }
        return timer;
    }

    @Nullable
    private TimerInternals.TimerData removeNextTimer(Instant currentTime, TimeDomain domain) {
        NavigableSet<TimerInternals.TimerData> timers = this.timersForDomain(domain);
        if (!timers.isEmpty() && currentTime.isAfter((ReadableInstant)((TimerInternals.TimerData)timers.first()).getTimestamp())) {
            TimerInternals.TimerData timer = timers.pollFirst();
            this.existingTimers.remove((Object)timer.getNamespace(), (Object)(timer.getTimerId() + '+' + timer.getTimerFamilyId()));
            return timer;
        }
        return null;
    }
}

