/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.modelmapper;

import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemProcessor;
import javax.inject.Inject;
import org.modelmapper.ModelMapper;

public class ModelMapperItemProcessor
implements ItemProcessor {
    private volatile ModelMapper mapper = null;
    @Inject
    @BatchProperty
    private String destinationType;
    private volatile Class<?> destinationTypeClass = null;

    public Object processItem(Object o) throws Exception {
        this.loadClass();
        return this.ensureMapper().map(o, this.destinationTypeClass);
    }

    protected ModelMapper newMapper() {
        return new ModelMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClass() {
        if (this.destinationTypeClass == null) {
            if (this.destinationType == null) {
                throw new IllegalArgumentException("Please set destinationType");
            }
            ModelMapperItemProcessor modelMapperItemProcessor = this;
            synchronized (modelMapperItemProcessor) {
                if (this.destinationTypeClass == null) {
                    try {
                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                        if (loader == null) {
                            loader = ModelMapperItemProcessor.class.getClassLoader();
                        }
                        this.destinationTypeClass = loader.loadClass(this.destinationType);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Can't load: '" + this.destinationType + "'", e);
                    }
                    catch (NoClassDefFoundError e) {
                        throw new IllegalArgumentException("Can't load: '" + this.destinationType + "'", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelMapper ensureMapper() {
        if (this.mapper == null) {
            ModelMapperItemProcessor modelMapperItemProcessor = this;
            synchronized (modelMapperItemProcessor) {
                if (this.mapper == null) {
                    this.mapper = this.newMapper();
                }
            }
        }
        return this.mapper;
    }
}

