/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.tools.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.batch.operations.JobOperator;
import org.apache.batchee.tools.maven.JobActionMojoBase;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="start", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class StartMojo
extends JobActionMojoBase {
    @Parameter(required=true, property="batchee.job")
    protected String jobName;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    protected File projectBinaries;
    @Parameter(defaultValue="${project.artifacts}", readonly=true, required=true)
    protected Set<Artifact> dependencies;
    @Parameter(property="batchee.use-project", defaultValue="true")
    protected boolean useProjectClasspath;
    @Parameter
    protected List<String> additionalClasspathEntries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        long id;
        JobOperator jobOperator = this.getOrCreateOperator();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = this.createStartLoader(oldLoader);
        Thread.currentThread().setContextClassLoader(loader);
        try {
            id = jobOperator.start(this.jobName, StartMojo.toProperties(this.jobParameters));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        this.getLog().info((CharSequence)("Started job " + this.jobName + ", id is #" + id));
        if (this.wait) {
            this.waitEnd(jobOperator, id);
        }
    }

    private ClassLoader createStartLoader(ClassLoader parent) throws MojoExecutionException {
        LinkedList<URL> urls = new LinkedList<URL>();
        if (this.useProjectClasspath) {
            if (this.projectBinaries != null && this.projectBinaries.exists()) {
                try {
                    urls.add(this.projectBinaries.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            if (this.dependencies != null) {
                for (Artifact dependency : this.dependencies) {
                    try {
                        urls.add(dependency.getFile().toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)e);
                    }
                }
            }
        }
        if (this.additionalClasspathEntries != null) {
            for (String entry : this.additionalClasspathEntries) {
                try {
                    File file = new File(entry);
                    if (!file.exists()) continue;
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }
}

