/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jsefa;

import jakarta.batch.api.BatchProperty;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import net.sf.jsefa.Deserializer;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.transaction.CountedReader;

public abstract class JSefaReader
extends CountedReader {
    @Inject
    @BatchProperty
    @Documentation(value="object types to use")
    protected String objectTypes;
    @Inject
    @BatchProperty
    @Documentation(value="validation mode (AUTO, CALLBACK, NONE)")
    protected String validationMode;
    @Inject
    @BatchProperty
    @Documentation(value="object accessor provider implementation")
    protected String objectAccessorProvider;
    @Inject
    @BatchProperty
    @Documentation(value="validation provider implementation")
    protected String validationProvider;
    @Inject
    @BatchProperty
    @Documentation(value="simple type provider implementation")
    protected String simpleTypeProvider;
    @Inject
    @BatchProperty
    @Documentation(value="type mapping registry to use")
    protected String typeMappingRegistry;
    @Inject
    @BatchProperty
    @Documentation(value="file to read")
    protected String file;
    @Inject
    @BatchProperty
    @Documentation(value="the encoding to use while reading the file. E.g. \"UTF-8\". If not specified the system default encoding is being used.")
    protected String encoding;
    protected Deserializer deserializer;

    public void open(Serializable checkpoint) throws Exception {
        this.deserializer = this.initDeserializer();
        Charset charset = this.encoding != null && !this.encoding.isEmpty() ? Charset.forName(this.encoding) : Charset.defaultCharset();
        this.deserializer.open((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), charset)));
        super.open(checkpoint);
    }

    protected abstract Deserializer initDeserializer() throws Exception;

    protected Object doRead() throws Exception {
        if (!this.deserializer.hasNext()) {
            return null;
        }
        return this.deserializer.next();
    }

    public void close() throws Exception {
        if (this.deserializer != null) {
            this.deserializer.close(true);
        }
    }
}

