/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jsefa;

import jakarta.batch.api.BatchProperty;
import jakarta.inject.Inject;
import java.io.Serializable;
import net.sf.jsefa.Serializer;
import net.sf.jsefa.csv.CsvIOFactory;
import net.sf.jsefa.csv.CsvSerializer;
import net.sf.jsefa.csv.config.CsvConfiguration;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.jsefa.JSefaCsvMapping;
import org.apache.batchee.jsefa.JSefaWriter;
import org.apache.batchee.jsefa.JsefaConfigurations;

@Documentation(value="Writes a CSV file using JSefa.")
public class JSefaCsvWriter
extends JSefaWriter {
    @Inject
    @BatchProperty
    @Documentation(value="Which ref or implementation to use to filter lines")
    private String lineFilter;
    @Inject
    @BatchProperty
    @Documentation(value="low level configuration implementation")
    private String lowLevelConfiguration;
    @Inject
    @BatchProperty
    @Documentation(value="if not using a custom line filter how many lines to filter")
    private String lineFilterLimit;
    @Inject
    @BatchProperty
    @Documentation(value="record delimiter")
    private String specialRecordDelimiter;
    @Inject
    @BatchProperty
    @Documentation(value="EOL")
    private String lineBreak;
    @Inject
    @BatchProperty
    @Documentation(value="which string to use for null values")
    private String defaultNoValueString;
    @Inject
    @BatchProperty
    @Documentation(value="quote mode (ALWAYS, ON_DEMAND, NEVER, DEFAULT)")
    private String defaultQuoteMode;
    @Inject
    @BatchProperty
    @Documentation(value="field delimiter")
    private String fieldDelimiter;
    @Inject
    @BatchProperty
    @Documentation(value="quote charater to use")
    private String quoteCharacter;
    @Inject
    @BatchProperty
    @Documentation(value="escape mode (ESCAPE_CHARACTER, DOUBLING)")
    private String quoteCharacterEscapeMode;
    @Inject
    @BatchProperty
    @Documentation(value="should deliimter be used after last field")
    private String useDelimiterAfterLastField;
    @Inject
    @BatchProperty
    @Documentation(value="the header for the file")
    private String header;
    @Inject
    @BatchProperty
    @Documentation(value="Should the header be calculated from @Header or fieldnames if @Header is not present on fields annotated with @CsvField. This property will be ignored if the header property is set.")
    private Boolean writeHeader;

    @Override
    protected Serializer createSerializer() throws Exception {
        return CsvIOFactory.createFactory((CsvConfiguration)JsefaConfigurations.newCsvConfiguration(this.defaultNoValueString, this.defaultQuoteMode, this.fieldDelimiter, this.lineBreak, this.quoteCharacter, this.quoteCharacterEscapeMode, this.useDelimiterAfterLastField, this.validationMode, this.validationProvider, this.lineFilter, this.lowLevelConfiguration, this.lineFilterLimit, this.objectAccessorProvider, this.specialRecordDelimiter, this.simpleTypeProvider, this.typeMappingRegistry), (Class[])JsefaConfigurations.createObjectTypes(this.objectTypes)).createSerializer();
    }

    @Override
    public void open(Serializable checkpoint) throws Exception {
        super.open(checkpoint);
        if (checkpoint != null) {
            return;
        }
        char delimiter = this.fieldDelimiter != null && !this.fieldDelimiter.isEmpty() ? (char)this.fieldDelimiter.charAt(0) : (char)';';
        if (this.header == null && this.writeHeader != null && this.writeHeader.booleanValue()) {
            Class<?>[] classes = JsefaConfigurations.createObjectTypes(this.objectTypes);
            StringBuilder headerBuilder = new StringBuilder(50);
            for (JSefaCsvMapping mapping : JSefaCsvMapping.forTypes(classes)) {
                for (String headerPart : mapping.getHeader()) {
                    if (headerBuilder.length() > 0) {
                        headerBuilder.append(delimiter);
                    }
                    headerBuilder.append(headerPart);
                }
            }
            this.header = headerBuilder.toString();
        }
        if (this.header != null && !this.header.trim().isEmpty()) {
            ((CsvSerializer)this.serializer).getLowLevelSerializer().writeLine(this.header.trim());
        }
    }
}

