/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.chunk;

import java.util.List;
import javax.batch.api.chunk.listener.RetryProcessListener;
import javax.batch.api.chunk.listener.RetryReadListener;
import javax.batch.api.chunk.listener.RetryWriteListener;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.impl.controller.chunk.ExceptionConfig;
import org.apache.batchee.jaxb.Chunk;
import org.apache.batchee.jaxb.ExceptionClassFilter;

public class RetryHandler {
    private List<RetryProcessListener> _retryProcessListeners = null;
    private List<RetryReadListener> _retryReadListeners = null;
    private List<RetryWriteListener> _retryWriteListeners = null;
    private ExceptionConfig retryNoRBConfig = new ExceptionConfig();
    private ExceptionConfig retryConfig = new ExceptionConfig();
    private int _retryLimit = Integer.MIN_VALUE;
    private long _retryCount = 0L;
    private Exception _retryException = null;

    public RetryHandler(Chunk chunk) {
        List<ExceptionClassFilter.Exclude> excludes;
        List<ExceptionClassFilter.Include> includes;
        try {
            if (chunk.getRetryLimit() != null) {
                this._retryLimit = Integer.parseInt(chunk.getRetryLimit());
                if (this._retryLimit < 0) {
                    throw new IllegalArgumentException("The retry-limit attribute on a chunk cannot be a negative value");
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("NumberFormatException reading retry-limit", nfe);
        }
        if (chunk.getRetryableExceptionClasses() != null) {
            if (chunk.getRetryableExceptionClasses().getIncludeList() != null) {
                includes = chunk.getRetryableExceptionClasses().getIncludeList();
                for (ExceptionClassFilter.Include include : includes) {
                    this.retryConfig.getIncludes().add(include.getClazz().trim());
                }
            }
            if (chunk.getRetryableExceptionClasses().getExcludeList() != null) {
                excludes = chunk.getRetryableExceptionClasses().getExcludeList();
                for (ExceptionClassFilter.Exclude exclude : excludes) {
                    this.retryConfig.getExcludes().add(exclude.getClazz().trim());
                }
            }
        }
        if (chunk.getNoRollbackExceptionClasses() != null) {
            if (chunk.getNoRollbackExceptionClasses().getIncludeList() != null) {
                includes = chunk.getNoRollbackExceptionClasses().getIncludeList();
                for (ExceptionClassFilter.Include include : includes) {
                    this.retryNoRBConfig.getIncludes().add(include.getClazz().trim());
                }
            }
            if (chunk.getNoRollbackExceptionClasses().getExcludeList() != null) {
                excludes = chunk.getNoRollbackExceptionClasses().getExcludeList();
                for (ExceptionClassFilter.Exclude exclude : excludes) {
                    this.retryNoRBConfig.getExcludes().add(exclude.getClazz().trim());
                }
            }
        }
    }

    public void addRetryProcessListener(List<RetryProcessListener> retryProcessListeners) {
        this._retryProcessListeners = retryProcessListeners;
    }

    public void addRetryReadListener(List<RetryReadListener> retryReadListeners) {
        this._retryReadListeners = retryReadListeners;
    }

    public void addRetryWriteListener(List<RetryWriteListener> retryWriteListeners) {
        this._retryWriteListeners = retryWriteListeners;
    }

    public boolean isRollbackException(Exception e) {
        return !this.isNoRollbackException(e);
    }

    public void handleExceptionRead(Exception e) {
        if (this.isRetryLimitReached() || !this.isRetryable(e)) {
            throw new BatchContainerRuntimeException(e);
        }
        this._retryException = e;
        ++this._retryCount;
        if (this._retryReadListeners != null) {
            for (RetryReadListener retryReadListenerProxy : this._retryReadListeners) {
                try {
                    retryReadListenerProxy.onRetryReadException(e);
                }
                catch (Exception e1) {
                    ExceptionConfig.wrapBatchException(e1);
                }
            }
        }
    }

    public void handleExceptionProcess(Exception e, Object w) {
        if (this.isRetryLimitReached() || !this.isRetryable(e)) {
            throw new BatchContainerRuntimeException(e);
        }
        this._retryException = e;
        ++this._retryCount;
        if (this._retryProcessListeners != null) {
            for (RetryProcessListener retryProcessListenerProxy : this._retryProcessListeners) {
                try {
                    retryProcessListenerProxy.onRetryProcessException(w, e);
                }
                catch (Exception e1) {
                    ExceptionConfig.wrapBatchException(e1);
                }
            }
        }
    }

    public void handleExceptionWrite(Exception e, List<Object> w) {
        if (this.isRetryLimitReached() || !this.isRetryable(e)) {
            throw new BatchContainerRuntimeException(e);
        }
        this._retryException = e;
        ++this._retryCount;
        if (this._retryWriteListeners != null) {
            for (RetryWriteListener retryWriteListenerProxy : this._retryWriteListeners) {
                try {
                    retryWriteListenerProxy.onRetryWriteException(w, e);
                }
                catch (Exception e1) {
                    ExceptionConfig.wrapBatchException(e1);
                }
            }
        }
    }

    private boolean isRetryable(Exception e) {
        return this.retryConfig.accept(e);
    }

    private boolean isNoRollbackException(Exception e) {
        return this.retryNoRBConfig.accept(e);
    }

    private boolean isRetryLimitReached() {
        return this._retryLimit != Integer.MIN_VALUE && this._retryCount >= (long)this._retryLimit;
    }

    public Exception getException() {
        return this._retryException;
    }

    public String toString() {
        return "RetryHandler{" + super.toString() + "}count:limit=" + this._retryCount + ":" + this._retryLimit;
    }
}

