/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller;

import java.util.List;
import javax.batch.runtime.BatchStatus;
import org.apache.batchee.container.Controller;
import org.apache.batchee.container.ExecutionElementController;
import org.apache.batchee.container.impl.JobContextImpl;
import org.apache.batchee.container.impl.controller.ExecutionTransitioner;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.navigator.ModelNavigator;
import org.apache.batchee.container.navigator.NavigatorFactory;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.status.ExecutionStatus;
import org.apache.batchee.container.status.ExtendedBatchStatus;
import org.apache.batchee.jaxb.Flow;

public class FlowController
implements ExecutionElementController {
    private final RuntimeJobExecution jobExecution;
    private final JobContextImpl jobContext;
    private final ServicesManager manager;
    protected ModelNavigator<Flow> flowNavigator;
    protected Flow flow;
    private long rootJobExecutionId;
    private ExecutionTransitioner transitioner;

    public FlowController(RuntimeJobExecution jobExecution, Flow flow, long rootJobExecutionId, ServicesManager manager) {
        this.jobExecution = jobExecution;
        this.jobContext = jobExecution.getJobContext();
        this.flowNavigator = NavigatorFactory.createFlowNavigator(flow);
        this.flow = flow;
        this.rootJobExecutionId = rootJobExecutionId;
        this.manager = manager;
    }

    @Override
    public ExecutionStatus execute() {
        if (!this.jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
            this.transitioner = new ExecutionTransitioner(this.jobExecution, this.rootJobExecutionId, this.flowNavigator, this.manager);
            return this.transitioner.doExecutionLoop();
        }
        return new ExecutionStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
    }

    @Override
    public void stop() {
        Controller stoppableElementController = this.transitioner.getCurrentStoppableElementController();
        if (stoppableElementController != null) {
            stoppableElementController.stop();
        }
    }

    @Override
    public List<Long> getLastRunStepExecutions() {
        return this.transitioner.getStepExecIds();
    }
}

