/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.chunk;

import javax.batch.api.chunk.CheckpointAlgorithm;

public final class ItemCheckpointAlgorithm
implements CheckpointAlgorithm {
    private long checkpointBeginTime = 0L;
    private int itemsRead = 0;
    private int time;
    private int item;

    public void setItemCount(int itemCount) {
        this.item = itemCount;
    }

    public void setTimeLimitSeconds(int timeLimitSeconds) {
        this.time = timeLimitSeconds;
    }

    public void endCheckpoint() throws Exception {
    }

    public boolean isReadyToCheckpointItem() throws Exception {
        return this.itemsRead >= this.item;
    }

    public boolean isReadyToCheckpointTime() throws Exception {
        boolean timeready = false;
        long currentTime = System.currentTimeMillis();
        long curdiff = currentTime - this.checkpointBeginTime;
        int diff = (int)curdiff / 1000;
        if (diff >= this.time) {
            timeready = true;
            this.checkpointBeginTime = System.currentTimeMillis();
        }
        return timeready;
    }

    public boolean isReadyToCheckpoint() throws Exception {
        boolean ready = false;
        ++this.itemsRead;
        if (this.time == 0) {
            if (this.isReadyToCheckpointItem()) {
                ready = true;
            }
        } else if (this.isReadyToCheckpointItem() || this.isReadyToCheckpointTime()) {
            ready = true;
        }
        return ready;
    }

    public void beginCheckpoint() throws Exception {
        this.checkpointBeginTime = System.currentTimeMillis();
        this.itemsRead = 0;
    }

    public int checkpointTimeout() throws Exception {
        return 0;
    }
}

