/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.persistence;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.exception.PersistenceException;
import org.apache.batchee.container.impl.JobExecutionImpl;
import org.apache.batchee.container.impl.JobInstanceImpl;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.StepExecutionImpl;
import org.apache.batchee.container.impl.controller.chunk.CheckpointData;
import org.apache.batchee.container.impl.controller.chunk.CheckpointDataKey;
import org.apache.batchee.container.impl.controller.chunk.PersistentDataWrapper;
import org.apache.batchee.container.impl.jobinstance.RuntimeFlowInSplitExecution;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.services.InternalJobExecution;
import org.apache.batchee.container.services.persistence.jpa.EntityManagerProvider;
import org.apache.batchee.container.services.persistence.jpa.TransactionProvider;
import org.apache.batchee.container.services.persistence.jpa.domain.CheckpointEntity;
import org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity;
import org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity;
import org.apache.batchee.container.services.persistence.jpa.domain.StepExecutionEntity;
import org.apache.batchee.container.services.persistence.jpa.provider.DefaultEntityManagerProvider;
import org.apache.batchee.container.services.persistence.jpa.provider.DefaultTransactionProvider;
import org.apache.batchee.container.status.JobStatus;
import org.apache.batchee.container.status.StepStatus;
import org.apache.batchee.container.util.Serializations;
import org.apache.batchee.spi.PersistenceManagerService;

public class JPAPersistenceManagerService
implements PersistenceManagerService {
    private static final Logger LOGGER = Logger.getLogger(JPAPersistenceManagerService.class.getName());
    private static final String[] DELETE_ID_QUERIES = new String[]{"org.apache.batchee.container.services.persistence.jpa.domain.StepExecutionEntity.deleteByInstanceId", "org.apache.batchee.container.services.persistence.jpa.domain.CheckpointEntity.deleteByInstanceId", "org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.deleteByInstanceId", "org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.deleteFromInstanceId"};
    private static final String[] DELETE_DATE_QUERIES = new String[]{"org.apache.batchee.container.services.persistence.jpa.domain.StepExecutionEntity.deleteByDate", "org.apache.batchee.container.services.persistence.jpa.domain.CheckpointEntity.deleteBydate", "org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.deleteByDate", "org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.deleteByDate"};
    private EntityManagerProvider emProvider;
    private TransactionProvider txProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp(long instanceId) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            Object tx = this.txProvider.start(em);
            try {
                for (String query : DELETE_ID_QUERIES) {
                    em.createNamedQuery(query).setParameter("instanceId", (Object)instanceId).executeUpdate();
                }
                this.txProvider.commit(tx);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp(Date until) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            Object tx = this.txProvider.start(em);
            try {
                for (String query : DELETE_DATE_QUERIES) {
                    em.createNamedQuery(query).setParameter("date", until, TemporalType.TIMESTAMP).executeUpdate();
                }
                this.txProvider.commit(tx);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StepStatus getStepStatus(long instanceId, String stepName) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            List list = em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.StepExecutionEntity.findByInstanceAndName", StepExecutionEntity.class).setParameter("instanceId", (Object)instanceId).setParameter("step", (Object)stepName).getResultList();
            if (list != null && !list.isEmpty()) {
                StepExecutionEntity entity = (StepExecutionEntity)list.iterator().next();
                StepStatus status = new StepStatus(entity.getId(), entity.getStartCount());
                status.setBatchStatus(entity.getBatchStatus());
                status.setExitStatus(entity.getExitStatus());
                status.setNumPartitions(entity.getNumPartitions());
                status.setLastRunStepExecutionId(entity.getLastRunStepExecutionId());
                if (entity.getPersistentData() != null) {
                    status.setPersistentUserData(new PersistentDataWrapper(entity.getPersistentData()));
                }
                StepStatus stepStatus = status;
                return stepStatus;
            }
            StepStatus stepStatus = null;
            return stepStatus;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> jobOperatorGetExternalJobInstanceData() {
        HashMap<Long, String> data = new HashMap<Long, String>();
        EntityManager em = this.emProvider.newEntityManager();
        try {
            List list = em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.findExternals", JobInstanceEntity.class).setParameter("pattern", (Object)":").getResultList();
            if (list != null) {
                for (JobInstanceEntity elt : list) {
                    data.put(elt.getJobInstanceId(), elt.getName());
                }
            }
        }
        finally {
            this.emProvider.release(em);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStatus getJobStatusFromExecution(long executionId) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            JobInstanceEntity entity = (JobInstanceEntity)em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.findByExecution", JobInstanceEntity.class).setParameter("executionId", (Object)executionId).getSingleResult();
            JobStatus status = new JobStatus(entity.getJobInstanceId());
            this.setJobStatusData(status, entity);
            JobStatus jobStatus = status;
            return jobStatus;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StepExecution getStepExecutionByStepExecutionId(long stepExecId) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            StepExecutionEntity entity = (StepExecutionEntity)em.find(StepExecutionEntity.class, (Object)stepExecId);
            StepExecutionImpl stepEx = new StepExecutionImpl(entity.getExecution().getExecutionId(), stepExecId);
            this.setStepExecutionData(entity, stepEx);
            StepExecutionImpl stepExecutionImpl = stepEx;
            return stepExecutionImpl;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    private void setStepExecutionData(StepExecutionEntity entity, StepExecutionImpl stepEx) {
        stepEx.setBatchStatus(entity.getBatchStatus());
        stepEx.setExitStatus(entity.getExitStatus());
        stepEx.setStepName(entity.getStepName());
        stepEx.setReadCount(entity.getRead());
        stepEx.setWriteCount(entity.getWrite());
        stepEx.setCommitCount(entity.getCommit());
        stepEx.setRollbackCount(entity.getRollback());
        stepEx.setReadSkipCount(entity.getReadSkip());
        stepEx.setProcessSkipCount(entity.getProcessSkip());
        stepEx.setFilterCount(entity.getFilter());
        stepEx.setWriteSkipCount(entity.getWriteSkip());
        stepEx.setStartTime(entity.getStartTime());
        stepEx.setEndTime(entity.getEndTime());
        try {
            stepEx.setPersistentUserData(Serializations.deserialize(entity.getPersistentData()));
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StepExecution> getStepExecutionsForJobExecution(long execid) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            List steps = em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.StepExecutionEntity.findByExecution", StepExecutionEntity.class).setParameter("executionId", (Object)execid).getResultList();
            if (steps == null) {
                List<StepExecution> list = Collections.emptyList();
                return list;
            }
            ArrayList<StepExecution> executions = new ArrayList<StepExecution>(steps.size());
            for (StepExecutionEntity entity : steps) {
                StepExecutionImpl stepEx = new StepExecutionImpl(execid, entity.getId());
                this.setStepExecutionData(entity, stepEx);
                executions.add(stepEx);
            }
            ArrayList<StepExecution> arrayList = executions;
            return arrayList;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStepExecution(long jobExecId, StepContextImpl stepContext) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            Object tx = this.txProvider.start(em);
            try {
                StepExecutionEntity entity = (StepExecutionEntity)em.find(StepExecutionEntity.class, (Object)stepContext.getStepInternalExecID());
                this.setStepData(em, jobExecId, stepContext, stepContext.metricsAsMap().get(Metric.MetricType.READ_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.WRITE_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.COMMIT_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.ROLLBACK_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.READ_SKIP_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.PROCESS_SKIP_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.FILTER_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.WRITE_SKIP_COUNT.name()).getValue(), entity);
                this.txProvider.commit(tx);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    @Override
    public StepExecutionImpl createStepExecution(long jobExecId, StepContextImpl stepContext) {
        StepExecutionEntity entity = new StepExecutionEntity();
        EntityManager em = this.emProvider.newEntityManager();
        try {
            this.setStepData(em, jobExecId, stepContext, stepContext.metricsAsMap().get(Metric.MetricType.READ_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.WRITE_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.COMMIT_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.ROLLBACK_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.READ_SKIP_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.PROCESS_SKIP_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.FILTER_COUNT.name()).getValue(), stepContext.metricsAsMap().get(Metric.MetricType.WRITE_SKIP_COUNT.name()).getValue(), entity);
            Object tx = this.txProvider.start(em);
            try {
                em.persist((Object)entity);
                this.txProvider.commit(tx);
                StepExecutionImpl stepExecution = new StepExecutionImpl(jobExecId, entity.getId());
                stepExecution.setStepName(stepContext.getStepName());
                StepExecutionImpl stepExecutionImpl = stepExecution;
                return stepExecutionImpl;
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    private void setStepData(EntityManager em, long jobExecId, StepContextImpl stepContext, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, StepExecutionEntity entity) {
        entity.setExecution((JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)jobExecId));
        entity.setBatchStatus(stepContext.getBatchStatus());
        entity.setExitStatus(stepContext.getExitStatus());
        entity.setStepName(stepContext.getStepName());
        entity.setRead(readCount);
        entity.setWrite(writeCount);
        entity.setCommit(commitCount);
        entity.setRollback(rollbackCount);
        entity.setReadSkip(readSkipCount);
        entity.setProcessSkip(processSkipCount);
        entity.setFilter(filterCount);
        entity.setWriteSkip(writeSkipCount);
        entity.setStartTime(stepContext.getStartTimeTS());
        entity.setEndTime(stepContext.getEndTimeTS());
        try {
            entity.setPersistentData(Serializations.serialize(stepContext.getPersistentUserData()));
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getJobInstanceIdByExecutionId(long executionId) throws NoSuchJobExecutionException {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            JobExecutionEntity jobExecutionEntity = (JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)executionId);
            if (jobExecutionEntity == null) {
                throw new NoSuchJobExecutionException("Execution #" + executionId);
            }
            long l = jobExecutionEntity.getInstance().getJobInstanceId();
            return l;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> jobOperatorGetRunningExecutions(String jobName) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            List list = em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.findRunning", JobExecutionEntity.class).setParameter("name", (Object)jobName).setParameter("statuses", JobExecutionEntity.Queries.RUNNING_STATUSES).getResultList();
            if (list == null) {
                Set<Long> set = Collections.emptySet();
                return set;
            }
            HashSet<Long> ids = new HashSet<Long>(list.size());
            for (JobExecutionEntity entity : list) {
                ids.add(entity.getExecutionId());
            }
            HashSet<Long> hashSet = ids;
            return hashSet;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InternalJobExecution> jobOperatorGetJobExecutions(long jobInstanceId) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            List list = em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.findByInstance", JobExecutionEntity.class).setParameter("instanceId", (Object)jobInstanceId).getResultList();
            if (list == null) {
                List<InternalJobExecution> list2 = Collections.emptyList();
                return list2;
            }
            ArrayList<InternalJobExecution> result = new ArrayList<InternalJobExecution>(list.size());
            for (JobExecutionEntity entity : list) {
                JobExecutionImpl jobEx = new JobExecutionImpl(entity.getExecutionId(), jobInstanceId, this);
                jobEx.setCreateTime(entity.getCreateTime());
                jobEx.setStartTime(entity.getStartTime());
                jobEx.setEndTime(entity.getEndTime());
                jobEx.setLastUpdateTime(entity.getUpdateTime());
                jobEx.setBatchStatus(entity.getBatchStatus().name());
                jobEx.setExitStatus(entity.getExitStatus());
                jobEx.setJobName(entity.getInstance().getName());
                jobEx.setJobParameters(entity.getJobProperties());
                result.add(jobEx);
            }
            ArrayList<InternalJobExecution> arrayList = result;
            return arrayList;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWithFinalExecutionStatusesAndTimestamps(long key, BatchStatus batchStatus, String exitStatus, Timestamp updatets) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            Object tx = this.txProvider.start(em);
            try {
                JobExecutionEntity instance = (JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)key);
                instance.setBatchStatus(batchStatus);
                instance.setUpdateTime(updatets);
                instance.setEndTime(updatets);
                instance.setExitStatus(exitStatus);
                em.merge((Object)instance);
                this.txProvider.commit(tx);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalJobExecution jobOperatorGetJobExecution(long jobExecutionId) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            JobExecutionEntity instance = (JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)jobExecutionId);
            JobExecutionImpl jobEx = new JobExecutionImpl(jobExecutionId, instance.getInstance().getJobInstanceId(), this);
            jobEx.setCreateTime(instance.getCreateTime());
            jobEx.setStartTime(instance.getStartTime());
            jobEx.setEndTime(instance.getEndTime());
            jobEx.setJobParameters(instance.getJobProperties());
            jobEx.setLastUpdateTime(instance.getUpdateTime());
            if (instance.getBatchStatus() != null) {
                jobEx.setBatchStatus(instance.getBatchStatus().name());
            }
            jobEx.setExitStatus(instance.getExitStatus());
            jobEx.setJobName(instance.getInstance().getName());
            JobExecutionImpl jobExecutionImpl = jobEx;
            return jobExecutionImpl;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markJobStarted(long key, Timestamp startTS) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            Object tx = this.txProvider.start(em);
            try {
                JobExecutionEntity instance = (JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)key);
                instance.setBatchStatus(BatchStatus.STARTED);
                instance.setStartTime(startTS);
                instance.setUpdateTime(startTS);
                em.merge((Object)instance);
                this.txProvider.commit(tx);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getParameters(long executionId) throws NoSuchJobExecutionException {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            Properties properties = ((JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)executionId)).getJobProperties();
            return properties;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String jobOperatorQueryJobExecutionExitStatus(long key) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            String string = ((JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)key)).getExitStatus();
            return string;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String jobOperatorQueryJobExecutionBatchStatus(long key) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            String string = ((JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)key)).getBatchStatus().name();
            return string;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    @Override
    public Timestamp jobOperatorQueryJobExecutionTimestamp(long key, PersistenceManagerService.TimestampType timetype) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            JobExecutionEntity entity = (JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)key);
            if (timetype.equals((Object)PersistenceManagerService.TimestampType.CREATE)) {
                Timestamp timestamp = entity.getCreateTime();
                return timestamp;
            }
            if (timetype.equals((Object)PersistenceManagerService.TimestampType.END)) {
                Timestamp timestamp = entity.getEndTime();
                return timestamp;
            }
            if (timetype.equals((Object)PersistenceManagerService.TimestampType.LAST_UPDATED)) {
                Timestamp timestamp = entity.getUpdateTime();
                return timestamp;
            }
            if (timetype.equals((Object)PersistenceManagerService.TimestampType.STARTED)) {
                Timestamp timestamp = entity.getStartTime();
                return timestamp;
            }
            throw new IllegalArgumentException("Unexpected enum value.");
        }
        finally {
            this.emProvider.release(em);
        }
    }

    @Override
    public RuntimeFlowInSplitExecution createFlowInSplitExecution(JobInstance jobInstance, BatchStatus batchStatus) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            JobExecutionEntity instance = new JobExecutionEntity();
            instance.setCreateTime(new Timestamp(System.currentTimeMillis()));
            instance.setUpdateTime(instance.getCreateTime());
            instance.setBatchStatus(batchStatus);
            Object tx = this.txProvider.start(em);
            try {
                instance.setInstance((JobInstanceEntity)em.find(JobInstanceEntity.class, (Object)jobInstance.getInstanceId()));
                em.persist((Object)instance);
                this.txProvider.commit(tx);
                RuntimeFlowInSplitExecution jobExecution = new RuntimeFlowInSplitExecution(jobInstance, instance.getExecutionId(), this);
                jobExecution.setBatchStatus(batchStatus.name());
                jobExecution.setCreateTime(instance.getCreateTime());
                jobExecution.setLastUpdateTime(instance.getCreateTime());
                RuntimeFlowInSplitExecution runtimeFlowInSplitExecution = jobExecution;
                return runtimeFlowInSplitExecution;
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMostRecentExecutionId(long jobInstanceId) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            long l = ((JobExecutionEntity)em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.mostRecent", JobExecutionEntity.class).setParameter("instanceId", (Object)jobInstanceId).setMaxResults(1).getSingleResult()).getExecutionId();
            return l;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBatchStatusOnly(long executionId, BatchStatus batchStatus, Timestamp timestamp) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            Object tx = this.txProvider.start(em);
            JobExecutionEntity instance = (JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)executionId);
            instance.setBatchStatus(batchStatus);
            instance.setUpdateTime(timestamp);
            try {
                em.merge((Object)instance);
                this.txProvider.commit(tx);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    @Override
    public RuntimeJobExecution createJobExecution(JobInstance jobInstance, Properties jobParameters, BatchStatus batchStatus) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            JobExecutionEntity execution = new JobExecutionEntity();
            execution.setJobProperties(jobParameters);
            execution.setCreateTime(new Timestamp(System.currentTimeMillis()));
            execution.setUpdateTime(execution.getCreateTime());
            execution.setBatchStatus(batchStatus);
            Object tx = this.txProvider.start(em);
            try {
                execution.setInstance((JobInstanceEntity)em.find(JobInstanceEntity.class, (Object)jobInstance.getInstanceId()));
                em.persist((Object)execution);
                this.txProvider.commit(tx);
                RuntimeJobExecution jobExecution = new RuntimeJobExecution(jobInstance, execution.getExecutionId(), this);
                jobExecution.setBatchStatus(batchStatus.name());
                jobExecution.setCreateTime(execution.getCreateTime());
                jobExecution.setLastUpdateTime(execution.getCreateTime());
                RuntimeJobExecution runtimeJobExecution = jobExecution;
                return runtimeJobExecution;
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    @Override
    public JobInstance createSubJobInstance(String name, String apptag) {
        return this.createJobInstance(name, apptag, null);
    }

    @Override
    public List<Long> jobOperatorGetJobInstanceIds(String jobName, int start, int count) {
        return this.jobOperatorGetJobInstanceIds(jobName, null, start, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> jobOperatorGetJobInstanceIds(String jobName, String appTag, int start, int count) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            TypedQuery query = appTag != null ? em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.findByName", JobInstanceEntity.class).setParameter("tag", (Object)appTag) : em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.findByName", JobInstanceEntity.class);
            query.setParameter("name", (Object)jobName);
            List resultList = query.setFirstResult(start).setMaxResults(count).getResultList();
            if (resultList == null) {
                List<Long> list = Collections.emptyList();
                return list;
            }
            ArrayList<Long> result = new ArrayList<Long>(resultList.size());
            for (JobInstanceEntity entity : resultList) {
                result.add(entity.getJobInstanceId());
            }
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    @Override
    public JobInstance createJobInstance(String name, String apptag, String jobXml) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            JobInstanceEntity instance = new JobInstanceEntity();
            instance.setTag(apptag);
            instance.setName(name);
            instance.setJobXml(jobXml);
            Object tx = this.txProvider.start(em);
            try {
                em.persist((Object)instance);
                this.txProvider.commit(tx);
                JobInstanceImpl jobInstance = new JobInstanceImpl(instance.getJobInstanceId(), jobXml);
                jobInstance.setJobName(name);
                JobInstanceImpl jobInstanceImpl = jobInstance;
                return jobInstanceImpl;
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int jobOperatorGetJobInstanceCount(String jobName) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            int n = ((Number)em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.countByName", Number.class).setParameter("name", (Object)jobName).getSingleResult()).intValue();
            return n;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int jobOperatorGetJobInstanceCount(String jobName, String appTag) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            int n = ((Number)em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.countByName", Number.class).setParameter("name", (Object)jobName).setParameter("tag", (Object)appTag).getSingleResult()).intValue();
            return n;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStepStatus(long stepExecutionId, StepStatus stepStatus) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            Object tx = this.txProvider.start(em);
            try {
                StepExecutionEntity entity = (StepExecutionEntity)em.find(StepExecutionEntity.class, (Object)stepExecutionId);
                entity.setBatchStatus(stepStatus.getBatchStatus());
                entity.setExitStatus(stepStatus.getExitStatus());
                entity.setLastRunStepExecutionId(stepStatus.getLastRunStepExecutionId());
                entity.setNumPartitions(stepStatus.getNumPartitions());
                entity.setPersistentData(stepStatus.getRawPersistentUserData());
                entity.setStartCount(stepStatus.getStartCount());
                em.merge((Object)entity);
                this.txProvider.commit(tx);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    @Override
    public StepStatus createStepStatus(long stepExecId) {
        return new StepStatus(stepExecId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateJobStatus(long instanceId, JobStatus jobStatus) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            Object tx = this.txProvider.start(em);
            try {
                JobInstanceEntity entity = (JobInstanceEntity)em.find(JobInstanceEntity.class, (Object)instanceId);
                entity.setBatchStatus(jobStatus.getBatchStatus());
                entity.setStep(jobStatus.getCurrentStepId());
                entity.setLatestExecution(jobStatus.getLatestExecutionId());
                entity.setExitStatus(jobStatus.getExitStatus());
                entity.setRestartOn(jobStatus.getRestartOn());
                if (jobStatus.getJobInstance() != null) {
                    entity.setName(jobStatus.getJobInstance().getJobName());
                }
                em.merge((Object)entity);
                List executions = em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.findByInstance", JobExecutionEntity.class).setParameter("instanceId", (Object)instanceId).getResultList();
                if (executions != null) {
                    for (JobExecutionEntity e : executions) {
                        e.setInstance(entity);
                        em.merge((Object)e);
                    }
                }
                this.txProvider.commit(tx);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStatus getJobStatus(long instanceId) {
        JobStatus status = new JobStatus(instanceId);
        EntityManager em = this.emProvider.newEntityManager();
        try {
            Object tx = this.txProvider.start(em);
            try {
                this.setJobStatusData(status, (JobInstanceEntity)em.find(JobInstanceEntity.class, (Object)instanceId));
                this.txProvider.commit(tx);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
        return status;
    }

    private void setJobStatusData(JobStatus status, JobInstanceEntity entity) {
        status.setBatchStatus(entity.getBatchStatus());
        status.setCurrentStepId(entity.getStep());
        status.setLatestExecutionId(entity.getLatestExecution());
        status.setExitStatus(entity.getExitStatus());
        status.setRestartOn(entity.getRestartOn());
        status.setJobInstance(entity.toJobInstance());
    }

    @Override
    public JobStatus createJobStatus(long jobInstanceId) {
        return new JobStatus(jobInstanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCheckpointData(CheckpointDataKey key, CheckpointData value) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            Object tx = this.txProvider.start(em);
            try {
                CheckpointEntity checkpoint;
                boolean isNew;
                List checkpoints = em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.CheckpointEntity.find", CheckpointEntity.class).setParameter("jobInstanceId", (Object)key.getJobInstanceId()).setParameter("stepName", (Object)key.getStepName()).setParameter("type", (Object)key.getType()).getResultList();
                boolean bl = isNew = checkpoints == null || checkpoints.isEmpty();
                if (isNew) {
                    checkpoint = new CheckpointEntity();
                    checkpoint.setInstance((JobInstanceEntity)em.find(JobInstanceEntity.class, (Object)key.getJobInstanceId()));
                    checkpoint.setStepName(key.getStepName());
                    checkpoint.setType(key.getType());
                } else {
                    checkpoint = (CheckpointEntity)checkpoints.iterator().next();
                }
                checkpoint.setData(value.getRestartToken());
                if (isNew) {
                    em.persist((Object)checkpoint);
                } else {
                    em.merge((Object)checkpoint);
                }
                this.txProvider.commit(tx);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(this.performRollback(tx, e));
            }
        }
        finally {
            this.emProvider.release(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckpointData getCheckpointData(CheckpointDataKey key) {
        EntityManager em = this.emProvider.newEntityManager();
        try {
            CheckpointEntity checkpoint = (CheckpointEntity)em.createNamedQuery("org.apache.batchee.container.services.persistence.jpa.domain.CheckpointEntity.find", CheckpointEntity.class).setParameter("jobInstanceId", (Object)key.getJobInstanceId()).setParameter("stepName", (Object)key.getStepName()).setParameter("type", (Object)key.getType()).getSingleResult();
            CheckpointData data = new CheckpointData(checkpoint.getInstance().getJobInstanceId(), checkpoint.getStepName(), checkpoint.getType());
            data.setRestartToken(checkpoint.getData());
            CheckpointData checkpointData = data;
            return checkpointData;
        }
        catch (NoResultException nre) {
            CheckpointData checkpointData = null;
            return checkpointData;
        }
        finally {
            this.emProvider.release(em);
        }
    }

    @Override
    public void init(Properties batchConfig) {
        String txProviderClass = batchConfig.getProperty("persistence.jpa.transaction-provider", DefaultTransactionProvider.class.getName());
        try {
            this.txProvider = (TransactionProvider)TransactionProvider.class.cast(Thread.currentThread().getContextClassLoader().loadClass(txProviderClass).newInstance());
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException(e);
        }
        this.txProvider.init(batchConfig);
        String providerClass = batchConfig.getProperty("persistence.jpa.entity-manager-provider", DefaultEntityManagerProvider.class.getName());
        try {
            this.emProvider = (EntityManagerProvider)EntityManagerProvider.class.cast(Thread.currentThread().getContextClassLoader().loadClass(providerClass).newInstance());
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException(e);
        }
        this.emProvider.init(batchConfig);
    }

    private Exception performRollback(Object tx, Exception originalException) {
        try {
            this.txProvider.rollback(tx, originalException);
        }
        catch (Exception exceptionDuringRollback) {
            LOGGER.log(Level.SEVERE, "Got an Exception while rolling back due to another Exception. Printing Rollback Exception and re-throwing original one", exceptionDuringRollback);
        }
        return originalException;
    }
}

