/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.kernel;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.JobInstance;
import org.apache.batchee.container.ThreadRootController;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.impl.JobContextImpl;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.jobinstance.JobExecutionHelper;
import org.apache.batchee.container.impl.jobinstance.RuntimeFlowInSplitExecution;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.services.BatchKernelService;
import org.apache.batchee.container.services.InternalJobExecution;
import org.apache.batchee.container.services.JobStatusManagerService;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.util.BatchFlowInSplitWorkUnit;
import org.apache.batchee.container.util.BatchPartitionWorkUnit;
import org.apache.batchee.container.util.BatchWorkUnit;
import org.apache.batchee.container.util.FlowInSplitBuilderConfig;
import org.apache.batchee.container.util.PartitionsBuilderConfig;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.spi.BatchThreadPoolService;
import org.apache.batchee.spi.JobExecutionCallbackService;
import org.apache.batchee.spi.PersistenceManagerService;

public class DefaultBatchKernel
implements BatchKernelService {
    private final Map<Long, ThreadRootController> executionId2jobControllerMap = new ConcurrentHashMap<Long, ThreadRootController>();
    private final Set<Long> instanceIdExecutingSet = new HashSet<Long>();
    private final BatchThreadPoolService executorService;
    private final PersistenceManagerService persistenceService;
    private final ServicesManager servicesManager;
    private final JobExecutionCallbackService jobExecutionCallback;

    public DefaultBatchKernel(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
        this.executorService = servicesManager.service(BatchThreadPoolService.class);
        this.persistenceService = servicesManager.service(PersistenceManagerService.class);
        this.jobExecutionCallback = servicesManager.service(JobExecutionCallbackService.class);
    }

    @Override
    public void init(Properties pgcConfig) throws BatchContainerServiceException {
    }

    @Override
    public InternalJobExecution startJob(String jobXML, Properties jobParameters) throws JobStartException {
        RuntimeJobExecution jobExecution = JobExecutionHelper.startJob(this.servicesManager, jobXML, jobParameters);
        BatchWorkUnit batchWork = new BatchWorkUnit(this.servicesManager, jobExecution);
        this.registerCurrentInstanceAndExecution(jobExecution, batchWork.getController());
        this.executorService.executeTask(batchWork, null);
        return jobExecution.getJobOperatorJobExecution();
    }

    @Override
    public void stopJob(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        ThreadRootController controller = this.executionId2jobControllerMap.get(executionId);
        if (controller == null) {
            throw new JobExecutionNotRunningException("JobExecution with execution id of " + executionId + "is not running.");
        }
        controller.stop();
    }

    @Override
    public InternalJobExecution restartJob(long executionId, Properties jobOverrideProps) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        RuntimeJobExecution jobExecution = JobExecutionHelper.restartJob(this.servicesManager, executionId, jobOverrideProps);
        BatchWorkUnit batchWork = new BatchWorkUnit(this.servicesManager, jobExecution);
        this.registerCurrentInstanceAndExecution(jobExecution, batchWork.getController());
        this.executorService.executeTask(batchWork, null);
        return jobExecution.getJobOperatorJobExecution();
    }

    @Override
    public void jobExecutionDone(RuntimeJobExecution jobExecution) {
        this.executionId2jobControllerMap.remove(jobExecution.getExecutionId());
        this.instanceIdExecutingSet.remove(jobExecution.getInstanceId());
        for (Closeable closeable : jobExecution.getReleasables()) {
            try {
                closeable.close();
            }
            catch (IOException e) {}
        }
        this.jobExecutionCallback.onJobExecutionDone(jobExecution);
    }

    @Override
    public InternalJobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException {
        return JobExecutionHelper.getPersistedJobOperatorJobExecution(this.servicesManager.service(PersistenceManagerService.class), executionId);
    }

    @Override
    public void startGeneratedJob(BatchWorkUnit batchWork) {
        this.executorService.executeTask(batchWork, null);
    }

    @Override
    public int getJobInstanceCount(String jobName) {
        return this.persistenceService.jobOperatorGetJobInstanceCount(jobName);
    }

    @Override
    public JobInstance getJobInstance(long executionId) {
        return JobExecutionHelper.getJobInstance(this.servicesManager.service(JobStatusManagerService.class), executionId);
    }

    @Override
    public List<BatchPartitionWorkUnit> buildNewParallelPartitions(PartitionsBuilderConfig config, JobContextImpl jc, StepContextImpl sc) throws JobRestartException, JobStartException {
        List<JSLJob> jobModels = config.getJobModels();
        Properties[] partitionPropertiesArray = config.getPartitionProperties();
        ArrayList<BatchPartitionWorkUnit> batchWorkUnits = new ArrayList<BatchPartitionWorkUnit>(jobModels.size());
        int instance = 0;
        for (JSLJob parallelJob : jobModels) {
            Properties partitionProps = partitionPropertiesArray == null ? null : partitionPropertiesArray[instance];
            RuntimeJobExecution jobExecution = JobExecutionHelper.startPartition(this.servicesManager, parallelJob, partitionProps);
            jobExecution.inheritJobContext(jc);
            jobExecution.setPartitionInstance(instance);
            BatchPartitionWorkUnit batchWork = new BatchPartitionWorkUnit(jobExecution, config, this.servicesManager);
            batchWork.inheritStepContext(sc);
            this.registerCurrentInstanceAndExecution(jobExecution, batchWork.getController());
            batchWorkUnits.add(batchWork);
            ++instance;
        }
        return batchWorkUnits;
    }

    @Override
    public List<BatchPartitionWorkUnit> buildOnRestartParallelPartitions(PartitionsBuilderConfig config, JobContextImpl jc, StepContextImpl sc) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException {
        List<JSLJob> jobModels = config.getJobModels();
        Properties[] partitionProperties = config.getPartitionProperties();
        ArrayList<BatchPartitionWorkUnit> batchWorkUnits = new ArrayList<BatchPartitionWorkUnit>(jobModels.size());
        int instance = 0;
        for (JSLJob parallelJob : jobModels) {
            Properties partitionProps = partitionProperties == null ? null : partitionProperties[instance];
            try {
                RuntimeJobExecution jobExecution;
                long execId = this.getMostRecentExecutionId(parallelJob);
                try {
                    jobExecution = JobExecutionHelper.restartPartition(this.servicesManager, execId, parallelJob, partitionProps);
                    jobExecution.inheritJobContext(jc);
                    jobExecution.setPartitionInstance(instance);
                }
                catch (NoSuchJobExecutionException e) {
                    throw new IllegalStateException("Caught NoSuchJobExecutionException but this is an internal JobExecution so this shouldn't have happened: execId =" + execId, e);
                }
                BatchPartitionWorkUnit batchWork = new BatchPartitionWorkUnit(jobExecution, config, this.servicesManager);
                batchWork.inheritStepContext(sc);
                this.registerCurrentInstanceAndExecution(jobExecution, batchWork.getController());
                batchWorkUnits.add(batchWork);
            }
            catch (JobExecutionAlreadyCompleteException e) {
                // empty catch block
            }
            ++instance;
        }
        return batchWorkUnits;
    }

    @Override
    public void restartGeneratedJob(BatchWorkUnit batchWork) throws JobRestartException {
        this.executorService.executeTask(batchWork, null);
    }

    @Override
    public BatchFlowInSplitWorkUnit buildNewFlowInSplitWorkUnit(FlowInSplitBuilderConfig config, JobContextImpl jc) {
        JSLJob parallelJob = config.getJobModel();
        RuntimeFlowInSplitExecution execution = JobExecutionHelper.startFlowInSplit(this.servicesManager, parallelJob);
        BatchFlowInSplitWorkUnit batchWork = new BatchFlowInSplitWorkUnit(execution, config, this.servicesManager);
        execution.inheritJobContext(jc);
        this.registerCurrentInstanceAndExecution(execution, batchWork.getController());
        return batchWork;
    }

    private long getMostRecentExecutionId(JSLJob jobModel) {
        List<Long> instanceIds = this.persistenceService.jobOperatorGetJobInstanceIds(jobModel.getId(), 0, 2);
        if (instanceIds.size() > 1) {
            throw new IllegalStateException("Found " + instanceIds.size() + " entries for instance id = " + jobModel.getId() + ", which should not have happened.  Blowing up.");
        }
        List<InternalJobExecution> partitionExecs = this.persistenceService.jobOperatorGetJobExecutions(instanceIds.get(0));
        Long execId = Long.MIN_VALUE;
        for (InternalJobExecution partitionExec : partitionExecs) {
            if (partitionExec.getExecutionId() <= execId) continue;
            execId = partitionExec.getExecutionId();
        }
        return execId;
    }

    @Override
    public BatchFlowInSplitWorkUnit buildOnRestartFlowInSplitWorkUnit(FlowInSplitBuilderConfig config, JobContextImpl jc) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException {
        RuntimeFlowInSplitExecution jobExecution;
        JSLJob jobModel = config.getJobModel();
        long execId = this.getMostRecentExecutionId(jobModel);
        try {
            jobExecution = JobExecutionHelper.restartFlowInSplit(this.servicesManager, execId, jobModel);
        }
        catch (NoSuchJobExecutionException e) {
            throw new IllegalStateException("Caught NoSuchJobExecutionException but this is an internal JobExecution so this shouldn't have happened: execId =" + execId, e);
        }
        BatchFlowInSplitWorkUnit batchWork = new BatchFlowInSplitWorkUnit(jobExecution, config, this.servicesManager);
        jobExecution.inheritJobContext(jc);
        this.registerCurrentInstanceAndExecution(jobExecution, batchWork.getController());
        return batchWork;
    }

    private void registerCurrentInstanceAndExecution(RuntimeJobExecution jobExecution, ThreadRootController controller) {
        long execId = jobExecution.getExecutionId();
        long instanceId = jobExecution.getInstanceId();
        String errorPrefix = "Tried to execute with Job executionId = " + execId + " and instanceId = " + instanceId + " ";
        if (this.executionId2jobControllerMap.get(execId) != null) {
            throw new IllegalStateException(errorPrefix + "but executionId is already currently executing.");
        }
        if (this.instanceIdExecutingSet.contains(instanceId)) {
            throw new IllegalStateException(errorPrefix + "but another execution with this instanceId is already currently executing.");
        }
        this.instanceIdExecutingSet.add(instanceId);
        this.executionId2jobControllerMap.put(jobExecution.getExecutionId(), controller);
    }

    @Override
    public boolean isExecutionRunning(long executionId) {
        return this.executionId2jobControllerMap.containsKey(executionId);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

