/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.util.TCCLObjectInputStream;
import org.apache.batchee.spi.DataRepresentationService;

public class DefaultDataRepresentationService
implements DataRepresentationService {
    public static final String BATCHEE_SPLIT_TOKEN = ":";
    public static final String BATCHEE_DATA_PREFIX = "BatchEE_data:";
    private static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    private static final Logger LOGGER = Logger.getLogger(DefaultDataRepresentationService.class.getName());

    @Override
    public void init(Properties batchConfig) {
    }

    @Override
    public <T> byte[] toInternalRepresentation(T dataObject) {
        if (dataObject == null) {
            return null;
        }
        byte[] serialValue = this.convertJavaNativeTypes(dataObject);
        if (serialValue == null) {
            serialValue = this.convertJava7DateTypes(dataObject);
        }
        if (serialValue == null) {
            serialValue = this.convertJava8DateTypes(dataObject);
        }
        if (serialValue == null) {
            serialValue = this.convertJodaDateTypes(dataObject);
        }
        if (serialValue == null) {
            serialValue = this.convertCustomEnumTypes(dataObject);
        }
        if (serialValue == null) {
            serialValue = this.convertCustomTypes(dataObject);
        }
        if (serialValue == null) {
            serialValue = this.convertSerializableObjectTypes(dataObject);
        }
        return serialValue;
    }

    @Override
    public <T> T toJavaRepresentation(byte[] internalRepresentation) {
        if (internalRepresentation == null) {
            return null;
        }
        T data = null;
        String stringRep = new String(internalRepresentation, UTF8_CHARSET);
        if (stringRep.startsWith(BATCHEE_DATA_PREFIX)) {
            String valueVal;
            String dataVal = stringRep.substring(BATCHEE_DATA_PREFIX.length());
            String typeVal = dataVal.substring(0, dataVal.indexOf(BATCHEE_SPLIT_TOKEN));
            data = this.convertBackJavaNativeTypes(typeVal, valueVal = dataVal.substring(dataVal.indexOf(BATCHEE_SPLIT_TOKEN) + BATCHEE_SPLIT_TOKEN.length()));
            if (data == null) {
                data = this.convertBackJava7DateTypes(typeVal, valueVal);
            }
            if (data == null) {
                data = this.convertBackJava8DateTypes(typeVal, valueVal);
            }
            if (data == null) {
                data = this.convertBackJodaDateTypes(typeVal, valueVal);
            }
            if (data == null) {
                data = this.convertBackCustomEnumTypes(typeVal, valueVal);
            }
            if (data == null) {
                data = this.convertBackCustomTypes(typeVal, valueVal);
            }
        }
        if (data == null) {
            data = this.convertBackSerializableObjectTypes(internalRepresentation);
        }
        if (data == null) {
            throw new IllegalStateException("Cannot convert back BatchEE data: " + internalRepresentation);
        }
        return data;
    }

    private <T> byte[] convertCustomEnumTypes(T dataObject) {
        if (dataObject instanceof Enum) {
            return this.toBatchEeData(dataObject.getClass(), ((Enum)dataObject).name());
        }
        return null;
    }

    private <T> T convertBackCustomEnumTypes(String typeVal, String valueVal) {
        try {
            Class<?> typeClass = this.getClassLoader().loadClass(typeVal);
            if (typeClass.isEnum()) {
                return (T)Enum.valueOf(typeClass, valueVal);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot convert back BatchEE data: " + valueVal + " of Enum type " + typeVal);
        }
        return null;
    }

    protected <T> byte[] convertCustomTypes(T dataObject) {
        return null;
    }

    private <T> T convertBackCustomTypes(String typeVal, String valueVal) {
        return null;
    }

    protected <T> byte[] convertJavaNativeTypes(T dataObject) {
        if (dataObject instanceof Integer || dataObject instanceof String || dataObject instanceof Long || dataObject instanceof Float || dataObject instanceof Double) {
            return this.toBatchEeData(dataObject.getClass(), dataObject.toString());
        }
        return null;
    }

    protected <T> T convertBackJavaNativeTypes(String typeVal, String value) {
        if (Integer.class.getName().equals(typeVal)) {
            return (T)Integer.valueOf(value);
        }
        if (Long.class.getName().equals(typeVal)) {
            return (T)Long.valueOf(value);
        }
        if (String.class.getName().equals(typeVal)) {
            return (T)value;
        }
        if (Float.class.getName().equals(typeVal)) {
            return (T)Float.valueOf(value);
        }
        if (Double.class.getName().equals(typeVal)) {
            return (T)Double.valueOf(value);
        }
        return null;
    }

    protected <T> byte[] convertJava7DateTypes(T dataObject) {
        if (dataObject.getClass().equals(Date.class)) {
            return this.toBatchEeData(Date.class, this.getSimpleDateFormat().format((Date)dataObject));
        }
        if (dataObject.getClass().equals(Timestamp.class)) {
            String val = String.format("%s.%09d", this.getTimestampDateFormat().format((Timestamp)dataObject), ((Timestamp)dataObject).getNanos());
            return this.toBatchEeData(Timestamp.class, val);
        }
        return null;
    }

    protected <T> T convertBackJava7DateTypes(String typeVal, String valueVal) {
        if (Date.class.getName().equals(typeVal)) {
            try {
                return (T)this.getSimpleDateFormat().parse(valueVal);
            }
            catch (ParseException e) {
                LOGGER.warning("Could not parse Date - format must be yyyy-MM-dd'T'HH:mm:ss'Z' but value is " + valueVal);
            }
        }
        if (Timestamp.class.getName().equals(typeVal)) {
            try {
                int lastDot = valueVal.lastIndexOf(46);
                String datePart = valueVal.substring(0, lastDot);
                Date dt = this.getTimestampDateFormat().parse(datePart);
                Timestamp tst = new Timestamp(dt.getTime());
                String nanoPart = valueVal.substring(lastDot + 1);
                tst.setNanos(Integer.parseInt(nanoPart));
                return (T)tst;
            }
            catch (ParseException e) {
                LOGGER.warning("Could not parse Date - format must be yyyy-MM-dd'T'HH:mm:ss'Z' but value is " + valueVal);
            }
        }
        return null;
    }

    private <T> byte[] convertJodaDateTypes(T dataObject) {
        String className = dataObject.getClass().getName();
        if (className.equals("org.joda.time.LocalDate") || className.equals("org.joda.time.LocalDateTime") || className.equals("org.joda.time.LocalTime")) {
            return this.toBatchEeData(dataObject.getClass(), dataObject.toString());
        }
        return null;
    }

    private <T> T convertBackJodaDateTypes(String typeVal, String valueVal) {
        if (typeVal.equals("org.joda.time.LocalDate") || typeVal.equals("org.joda.time.LocalDateTime") || typeVal.equals("org.joda.time.LocalTime")) {
            return (T)this.invokeStaticMethod(typeVal, "parse", String.class, valueVal);
        }
        return null;
    }

    private <T> byte[] convertJava8DateTypes(T dataObject) {
        String className = dataObject.getClass().getName();
        if (className.equals("java.time.LocalDate") || className.equals("java.time.LocalDateTime") || className.equals("java.time.LocalTime")) {
            return this.toBatchEeData(dataObject.getClass(), dataObject.toString());
        }
        return null;
    }

    private <T> T convertBackJava8DateTypes(String typeVal, String valueVal) {
        if (typeVal.equals("java.time.LocalDate") || typeVal.equals("java.time.LocalDateTime") || typeVal.equals("java.time.LocalTime")) {
            return (T)this.invokeStaticMethod(typeVal, "parse", CharSequence.class, valueVal);
        }
        return null;
    }

    protected Object invokeStaticMethod(String typeVal, String methodName, Class paramType, String valueVal) {
        try {
            Class<?> typeClass = this.getClassLoader().loadClass(typeVal);
            Method method = typeClass.getMethod(methodName, paramType);
            return method.invoke(null, valueVal);
        }
        catch (ReflectiveOperationException e) {
            throw new BatchContainerServiceException("Cannot convert data [" + valueVal + "] of type [" + typeVal + "]", e);
        }
    }

    protected <T> byte[] convertSerializableObjectTypes(T dataObject) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(dataObject);
        }
        catch (IOException e) {
            throw new BatchContainerServiceException("Cannot convert data for [" + dataObject.toString() + "]");
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T convertBackSerializableObjectTypes(byte[] internalRepresentation) {
        Object object;
        ByteArrayInputStream readerChkptBA = new ByteArrayInputStream(internalRepresentation);
        TCCLObjectInputStream readerOIS = null;
        try {
            Object instance;
            readerOIS = new TCCLObjectInputStream(readerChkptBA);
            object = instance = readerOIS.readObject();
        }
        catch (Exception ex) {
            T t = null;
            return t;
        }
        finally {
            if (readerOIS != null) {
                try {
                    readerOIS.close();
                }
                catch (IOException e) {}
            }
        }
        return (T)object;
    }

    protected byte[] toBatchEeData(Class<?> type, String stringRepresentation) {
        return (BATCHEE_DATA_PREFIX + type.getName() + BATCHEE_SPLIT_TOKEN + stringRepresentation).getBytes(UTF8_CHARSET);
    }

    protected ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }

    protected SimpleDateFormat getSimpleDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf;
    }

    protected SimpleDateFormat getTimestampDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf;
    }
}

