/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.proxy;

import javax.batch.api.chunk.CheckpointAlgorithm;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.impl.controller.chunk.ItemCheckpointAlgorithm;
import org.apache.batchee.container.proxy.AbstractProxy;

public class CheckpointAlgorithmProxy
extends AbstractProxy<CheckpointAlgorithm>
implements CheckpointAlgorithm {
    private String checkpointType = null;

    public CheckpointAlgorithmProxy(CheckpointAlgorithm delegate) {
        super(delegate);
        this.checkpointType = delegate instanceof ItemCheckpointAlgorithm ? "item" : "custom";
    }

    public String getCheckpointType() {
        return this.checkpointType;
    }

    public void beginCheckpoint() {
        try {
            ((CheckpointAlgorithm)this.delegate).beginCheckpoint();
        }
        catch (Exception e) {
            this.stepContext.setException(e);
            throw new BatchContainerRuntimeException(e);
        }
    }

    public int checkpointTimeout() {
        try {
            return ((CheckpointAlgorithm)this.delegate).checkpointTimeout();
        }
        catch (Exception e) {
            this.stepContext.setException(e);
            throw new BatchContainerRuntimeException(e);
        }
    }

    public void endCheckpoint() {
        try {
            ((CheckpointAlgorithm)this.delegate).endCheckpoint();
        }
        catch (Exception e) {
            this.stepContext.setException(e);
            throw new BatchContainerRuntimeException(e);
        }
    }

    public boolean isReadyToCheckpoint() {
        try {
            return ((CheckpointAlgorithm)this.delegate).isReadyToCheckpoint();
        }
        catch (Exception e) {
            this.stepContext.setException(e);
            throw new BatchContainerRuntimeException(e);
        }
    }
}

