/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.servlet;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.spi.BatchThreadPoolService;

@WebListener
public class CleanUpWebappListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
        BatchThreadPoolService threadPoolService = ServicesManager.find().service(BatchThreadPoolService.class);
        if (CleanUpWebappListener.class.getClassLoader() == sce.getServletContext().getClassLoader()) {
            threadPoolService.shutdown();
            MBeanServer jmx = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName objectName = new ObjectName("org.apache.batchee:type=batchee,name=operator");
                if (jmx.isRegistered(objectName)) {
                    jmx.unregisterMBean(objectName);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

