/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.security;

import java.security.AccessController;
import java.security.Principal;
import java.util.Iterator;
import java.util.Properties;
import javax.security.auth.Subject;
import org.apache.batchee.container.services.security.DefaultSecurityService;

public class JAASSecurityService
extends DefaultSecurityService {
    private static boolean isAuthenticatedAndAuthorized(String permission) {
        Subject subject = JAASSecurityService.getSubject();
        if (subject == null) {
            return false;
        }
        for (BatchRole role : subject.getPrincipals(BatchRole.class)) {
            if (!role.getName().equals(permission)) continue;
            return true;
        }
        return false;
    }

    private static Subject getSubject() {
        return Subject.getSubject(AccessController.getContext());
    }

    @Override
    public boolean isAuthorized(long instanceId) {
        return JAASSecurityService.isAuthenticatedAndAuthorized("update");
    }

    @Override
    public boolean isAuthorized(String perm) {
        return JAASSecurityService.isAuthenticatedAndAuthorized(perm);
    }

    @Override
    public String getLoggedUser() {
        Iterator<BatchUser> iterator;
        Subject subject = JAASSecurityService.getSubject();
        if (subject != null && (iterator = subject.getPrincipals(BatchUser.class).iterator()).hasNext()) {
            return iterator.next().getName();
        }
        return super.getLoggedUser();
    }

    @Override
    public void init(Properties batchConfig) {
        super.init(batchConfig);
    }

    public static class BatchRole
    extends BatchPrincipal {
        public BatchRole(String name) {
            super(name);
        }
    }

    public static class BatchUser
    extends BatchPrincipal {
        public BatchUser(String name) {
            super(name);
        }
    }

    public static abstract class BatchPrincipal
    implements Principal {
        private final String name;

        public BatchPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

