/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.persistence.jdbc;

import org.apache.batchee.container.services.persistence.jdbc.database.Database;

public class Dictionary {
    private final String checkpointTable;
    private final String createCheckpointTable;
    private final String insertCheckpoint;
    private final String selectCheckpoint;
    private final String updateCheckpoint;
    private final String deleteCheckpoint;
    private final String jobInstanceTable;
    private final String createJobInstanceTable;
    private final String countJobInstanceByName;
    private final String findJobInstance;
    private final String updateJobInstanceStatus;
    private final String countJobInstanceByNameAndTag;
    private final String findJoBInstanceIds;
    private final String findJobInstanceIdsByName;
    private final String findExternalJobInstances;
    private final String createJobInstance;
    private final String createJobInstanceWithJobXml;
    private final String deleteJobInstance;
    private final String jobExecutionTable;
    private final String createJobExecutionTable;
    private final String findJobExecutionTimestamps;
    private final String findJobExecutionBatchStatus;
    private final String findJobExecutionExitStatus;
    private final String findJobExecutionJobProperties;
    private final String updateJobExecution;
    private final String setJobExecutionFinalData;
    private final String updateStartedJobExecution;
    private final String findJobExecutionById;
    private final String findJobExecutionByInstance;
    private final String findRunningJobExecutions;
    private final String findJobStatus;
    private final String findJobInstanceFromJobExecution;
    private final String createJobExecution;
    private final String findMostRecentJobExecution;
    private final String deleteJobExecution;
    private final String stepExecutionTable;
    private final String createStepExecutionTable;
    private final String finStepExecutionFromJobExecution;
    private final String findStepExecutionFromId;
    private final String createStepExecution;
    private final String updateStepExecutionStatus;
    private final String updateStepExecution;
    private final String findStepExecutionByJobInstanceAndStepName;
    private final String deleteStepExecution;
    private final String[] checkpointColumns;
    private final String[] jobInstanceColumns;
    private final String[] jobExecutionColumns;
    private final String[] stepExecutionColumns;

    public Dictionary(String checkpointTable, String jobInstanceTable, String jobExecutionTable, String stepExecutionTable, Database database) {
        this.checkpointTable = checkpointTable;
        this.jobInstanceTable = jobInstanceTable;
        this.jobExecutionTable = jobExecutionTable;
        this.stepExecutionTable = stepExecutionTable;
        this.checkpointColumns = Dictionary.columns(database, SQL.CHECKPOINT_COLUMNS);
        this.createCheckpointTable = String.format("create table %s(%s %s %s , %s %s, %s %s, %s %s, %s %s, primary key(id))", checkpointTable, this.checkpointColumns[0], database.bigint(), database.autoIncrementId(), this.checkpointColumns[1], database.blob(), this.checkpointColumns[2], database.varchar255(), this.checkpointColumns[3], database.varchar20(), this.checkpointColumns[4], database.bigint());
        this.insertCheckpoint = String.format("insert into %s(%s, %s, %s, %s) values (?, ?, ?, ?)", checkpointTable, this.checkpointColumns[1], this.checkpointColumns[2], this.checkpointColumns[3], this.checkpointColumns[4]);
        this.selectCheckpoint = String.format("select %s from %s where %s = ? and %s = ? and %s = ?", this.checkpointColumns[1], checkpointTable, this.checkpointColumns[4], this.checkpointColumns[3], this.checkpointColumns[2]);
        this.updateCheckpoint = String.format("update %s set %s = ? where %s = ? and %s = ? and %s = ?", checkpointTable, this.checkpointColumns[1], this.checkpointColumns[4], this.checkpointColumns[3], this.checkpointColumns[2]);
        this.deleteCheckpoint = String.format("delete from %s where %s = ?", checkpointTable, this.checkpointColumns[4]);
        this.jobInstanceColumns = Dictionary.columns(database, SQL.JOB_INSTANCE_COLUMNS);
        this.createJobInstanceTable = String.format("create table %s(%s %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, PRIMARY KEY (%s))", jobInstanceTable, this.jobInstanceColumns[0], database.bigint(), database.autoIncrementId(), this.jobInstanceColumns[1], database.varchar20(), this.jobInstanceColumns[2], database.varchar255(), this.jobInstanceColumns[3], database.varchar255(), this.jobInstanceColumns[4], database.blob(), this.jobInstanceColumns[5], database.bigint(), this.jobInstanceColumns[6], database.varchar255(), this.jobInstanceColumns[7], database.varchar255(), this.jobInstanceColumns[8], database.varchar255(), this.jobInstanceColumns[0]);
        this.countJobInstanceByName = String.format("select count(%s) as jobinstancecount from %s where %s = ?", this.jobInstanceColumns[0], jobInstanceTable, this.jobInstanceColumns[3]);
        this.findJobInstance = String.format("select * from %s where %s = ?", jobInstanceTable, this.jobInstanceColumns[0]);
        this.updateJobInstanceStatus = String.format("update %s set %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ? where %s = ?", jobInstanceTable, this.jobInstanceColumns[1], this.jobInstanceColumns[2], this.jobInstanceColumns[5], this.jobInstanceColumns[6], this.jobInstanceColumns[7], this.jobInstanceColumns[3], this.jobInstanceColumns[0]);
        this.countJobInstanceByNameAndTag = String.format("select count(%s) as jobinstancecount from %s where %s = ? and %s = ?", this.jobInstanceColumns[0], jobInstanceTable, this.jobInstanceColumns[6], this.jobInstanceColumns[8]);
        this.findJoBInstanceIds = String.format("select %s from %s where %s = ? and %s = ? order by %s desc", this.jobInstanceColumns[0], jobInstanceTable, this.jobInstanceColumns[3], this.jobInstanceColumns[8], this.jobInstanceColumns[0]);
        this.findJobInstanceIdsByName = String.format("select %s from %s where  %s = ? order by %s desc", this.jobInstanceColumns[0], jobInstanceTable, this.jobInstanceColumns[3], this.jobInstanceColumns[0]);
        this.findExternalJobInstances = String.format("select distinct %s, %s from %s where %s not like '%s'", this.jobInstanceColumns[0], this.jobInstanceColumns[3], jobInstanceTable, this.jobInstanceColumns[3], ":%");
        this.createJobInstance = String.format("insert into %s(%s, %s) VALUES(?, ?)", jobInstanceTable, this.jobInstanceColumns[3], this.jobInstanceColumns[8]);
        this.createJobInstanceWithJobXml = String.format("insert into %s(%s, %s, %s) VALUES(?, ?, ?)", jobInstanceTable, this.jobInstanceColumns[3], this.jobInstanceColumns[8], this.jobInstanceColumns[4]);
        this.deleteJobInstance = String.format("delete from %s where %s = ?", jobInstanceTable, this.jobInstanceColumns[0]);
        this.jobExecutionColumns = Dictionary.columns(database, SQL.JOB_EXECUTION_COLUMNS);
        this.createJobExecutionTable = String.format("create table %s(%s %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s)", jobExecutionTable, this.jobExecutionColumns[0], database.bigint(), database.autoIncrementId(), this.jobExecutionColumns[1], database.varchar20(), this.jobExecutionColumns[2], database.timestamp(), this.jobExecutionColumns[3], database.timestamp(), this.jobExecutionColumns[4], database.varchar255(), this.jobExecutionColumns[5], database.blob(), this.jobExecutionColumns[6], database.timestamp(), this.jobExecutionColumns[7], database.timestamp(), this.jobExecutionColumns[8], database.bigint());
        this.findJobExecutionTimestamps = String.format("select  %s, %s, %s, %s from %s where %s = ?", this.jobExecutionColumns[2], this.jobExecutionColumns[3], this.jobExecutionColumns[7], this.jobExecutionColumns[6], jobExecutionTable, this.jobExecutionColumns[0]);
        this.findJobExecutionBatchStatus = String.format("select %s from %s where %s = ?", this.jobExecutionColumns[1], jobExecutionTable, this.jobExecutionColumns[0]);
        this.findJobExecutionExitStatus = String.format("select %s from %s where %s = ?", this.jobExecutionColumns[4], jobExecutionTable, this.jobExecutionColumns[0]);
        this.findJobExecutionJobProperties = String.format("select %s from %s where %s = ?", this.jobExecutionColumns[5], jobExecutionTable, this.jobExecutionColumns[0]);
        this.updateJobExecution = String.format("update %s set %s = ?, %s = ? where %s = ?", jobExecutionTable, this.jobExecutionColumns[1], this.jobExecutionColumns[7], this.jobExecutionColumns[0]);
        this.setJobExecutionFinalData = String.format("update %s set %s = ?, %s = ?, %s = ?, %s = ? where %s = ?", jobExecutionTable, this.jobExecutionColumns[1], this.jobExecutionColumns[4], this.jobExecutionColumns[3], this.jobExecutionColumns[7], this.jobExecutionColumns[0]);
        this.updateStartedJobExecution = String.format("update %s set %s = ?, %s = ?, %s = ? where %s = ?", jobExecutionTable, this.jobExecutionColumns[1], this.jobExecutionColumns[6], this.jobExecutionColumns[7], this.jobExecutionColumns[0]);
        this.findJobExecutionById = String.format("select A.%s, A.%s, A.%s, A.%s, A.%s, A.%s, A.%s, A.%s, B.%s from %s as A inner join %s as B on A.%s = B.%s where %s = ?", this.jobExecutionColumns[2], this.jobExecutionColumns[6], this.jobExecutionColumns[3], this.jobExecutionColumns[7], this.jobExecutionColumns[5], this.jobExecutionColumns[8], this.jobExecutionColumns[1], this.jobExecutionColumns[4], this.jobInstanceColumns[3], jobExecutionTable, jobInstanceTable, this.jobExecutionColumns[8], this.jobInstanceColumns[0], this.jobExecutionColumns[0]);
        this.findRunningJobExecutions = String.format("select A.%s from %s AS A inner join %s AS B ON A.%s = B.%s WHERE A.%s IN (?,?,?) AND B.%s = ?", this.jobExecutionColumns[0], jobExecutionTable, jobInstanceTable, this.jobExecutionColumns[8], this.jobInstanceColumns[0], this.jobExecutionColumns[1], this.jobInstanceColumns[3]);
        this.findJobExecutionByInstance = String.format("select A.%s, A.%s, A.%s, A.%s, A.%s, A.%s, A.%s, A.%s, B.%s  from %s as A inner join %s as B ON A.%s = B.%s where B.%s = ?", this.jobExecutionColumns[0], this.jobExecutionColumns[2], this.jobExecutionColumns[6], this.jobExecutionColumns[3], this.jobExecutionColumns[7], this.jobExecutionColumns[5], this.jobExecutionColumns[1], this.jobExecutionColumns[4], this.jobInstanceColumns[3], jobExecutionTable, jobInstanceTable, this.jobExecutionColumns[8], this.jobInstanceColumns[0], this.jobInstanceColumns[0]);
        this.findJobStatus = String.format("select * from %s as A inner join %s as B on A.%s = B.%s  where B.%s = ?", jobInstanceTable, jobExecutionTable, this.jobInstanceColumns[0], this.jobExecutionColumns[8], this.jobExecutionColumns[0]);
        this.findJobInstanceFromJobExecution = String.format("select %s from %s where %s = ?", this.jobExecutionColumns[8], jobExecutionTable, this.jobExecutionColumns[0]);
        this.createJobExecution = String.format("insert into %s(%s, %s, %s, %s, %s) VALUES(?, ?, ?, ?, ?)", jobExecutionTable, this.jobExecutionColumns[8], this.jobExecutionColumns[2], this.jobExecutionColumns[7], this.jobExecutionColumns[1], this.jobExecutionColumns[5]);
        this.findMostRecentJobExecution = String.format("select %s from %s where %s = ? ORDER BY %s DESC", this.jobExecutionColumns[0], jobExecutionTable, this.jobExecutionColumns[8], this.jobExecutionColumns[2]);
        this.deleteJobExecution = String.format("delete from %s where %s = ?", jobExecutionTable, this.jobExecutionColumns[8]);
        this.stepExecutionColumns = Dictionary.columns(database, SQL.STEP_EXECUTION_COLUMNS);
        this.createStepExecutionTable = String.format("create table %s(%s %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, PRIMARY KEY (id))", stepExecutionTable, this.stepExecutionColumns[0], database.bigint(), database.autoIncrementId(), this.stepExecutionColumns[1], database.varchar20(), this.stepExecutionColumns[2], database.bigint(), this.stepExecutionColumns[3], database.timestamp(), this.stepExecutionColumns[4], database.varchar255(), this.stepExecutionColumns[5], database.bigint(), this.stepExecutionColumns[6], database.bigint(), this.stepExecutionColumns[7], database.integer(), this.stepExecutionColumns[8], database.blob(), this.stepExecutionColumns[9], database.bigint(), this.stepExecutionColumns[10], database.bigint(), this.stepExecutionColumns[11], database.bigint(), this.stepExecutionColumns[12], database.bigint(), this.stepExecutionColumns[13], database.integer(), this.stepExecutionColumns[14], database.timestamp(), this.stepExecutionColumns[15], database.varchar255(), this.stepExecutionColumns[16], database.bigint(), this.stepExecutionColumns[17], database.bigint(), this.stepExecutionColumns[18], database.bigint());
        this.finStepExecutionFromJobExecution = String.format("select * from %s where %s = ?", stepExecutionTable, this.stepExecutionColumns[18]);
        this.findStepExecutionFromId = String.format("select * from %s where %s = ?", stepExecutionTable, this.stepExecutionColumns[0]);
        this.createStepExecution = String.format("insert into %s(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", stepExecutionTable, this.stepExecutionColumns[18], this.stepExecutionColumns[1], this.stepExecutionColumns[4], this.stepExecutionColumns[15], this.stepExecutionColumns[10], this.stepExecutionColumns[16], this.stepExecutionColumns[2], this.stepExecutionColumns[12], this.stepExecutionColumns[11], this.stepExecutionColumns[9], this.stepExecutionColumns[5], this.stepExecutionColumns[17], this.stepExecutionColumns[14], this.stepExecutionColumns[3], this.stepExecutionColumns[8]);
        this.updateStepExecutionStatus = String.format("update %s SET %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ? WHERE %s = ?", stepExecutionTable, this.stepExecutionColumns[8], this.stepExecutionColumns[1], this.stepExecutionColumns[4], this.stepExecutionColumns[6], this.stepExecutionColumns[7], this.stepExecutionColumns[13], this.stepExecutionColumns[0]);
        this.updateStepExecution = String.format("update %s SET %s = ?, %s = ?, %s = ?, %s = ?,  %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ? WHERE %s = ?", stepExecutionTable, this.stepExecutionColumns[18], this.stepExecutionColumns[1], this.stepExecutionColumns[4], this.stepExecutionColumns[15], this.stepExecutionColumns[10], this.stepExecutionColumns[16], this.stepExecutionColumns[2], this.stepExecutionColumns[12], this.stepExecutionColumns[11], this.stepExecutionColumns[9], this.stepExecutionColumns[5], this.stepExecutionColumns[17], this.stepExecutionColumns[14], this.stepExecutionColumns[3], this.stepExecutionColumns[8], this.stepExecutionColumns[0]);
        this.findStepExecutionByJobInstanceAndStepName = String.format("select B.%s, B.%s, B.%s, B.%s, B.%s, B.%s, B.%s, B.%s from %s A inner join %s B ON A.%s = B.%s  where A.%s = ? and B.%s = ?", this.stepExecutionColumns[0], this.stepExecutionColumns[13], this.stepExecutionColumns[1], this.stepExecutionColumns[4], this.stepExecutionColumns[8], this.stepExecutionColumns[6], this.stepExecutionColumns[7], this.stepExecutionColumns[18], jobExecutionTable, stepExecutionTable, this.jobExecutionColumns[0], this.stepExecutionColumns[18], this.jobExecutionColumns[8], this.stepExecutionColumns[15]);
        this.deleteStepExecution = String.format("delete from %s A inner join %s B ON A.%s = B.%s  where A.%s = ?", jobExecutionTable, stepExecutionTable, this.jobExecutionColumns[0], this.stepExecutionColumns[18], this.jobExecutionColumns[8]);
    }

    private static String[] columns(Database database, String[] cols) {
        String[] out = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            out[i] = database.columnName(cols[i]);
        }
        return out;
    }

    public String getCheckpointTable() {
        return this.checkpointTable;
    }

    public String getCreateCheckpointTable() {
        return this.createCheckpointTable;
    }

    public String getInsertCheckpoint() {
        return this.insertCheckpoint;
    }

    public String getSelectCheckpoint() {
        return this.selectCheckpoint;
    }

    public String getUpdateCheckpoint() {
        return this.updateCheckpoint;
    }

    public String getDeleteCheckpoint() {
        return this.deleteCheckpoint;
    }

    public String getJobInstanceTable() {
        return this.jobInstanceTable;
    }

    public String getCreateJobInstanceTable() {
        return this.createJobInstanceTable;
    }

    public String getCountJobInstanceByName() {
        return this.countJobInstanceByName;
    }

    public String getFindJobInstance() {
        return this.findJobInstance;
    }

    public String getUpdateJobInstanceStatus() {
        return this.updateJobInstanceStatus;
    }

    public String getCountJobInstanceByNameAndTag() {
        return this.countJobInstanceByNameAndTag;
    }

    public String getFindJoBInstanceIds() {
        return this.findJoBInstanceIds;
    }

    public String getFindJobInstanceIdsByName() {
        return this.findJobInstanceIdsByName;
    }

    public String getFindExternalJobInstances() {
        return this.findExternalJobInstances;
    }

    public String getCreateJobInstance() {
        return this.createJobInstance;
    }

    public String getCreateJobInstanceWithJobXml() {
        return this.createJobInstanceWithJobXml;
    }

    public String getDeleteJobInstance() {
        return this.deleteJobInstance;
    }

    public String getJobExecutionTable() {
        return this.jobExecutionTable;
    }

    public String getCreateJobExecutionTable() {
        return this.createJobExecutionTable;
    }

    public String getFindJobExecutionTimestamps() {
        return this.findJobExecutionTimestamps;
    }

    public String getFindJobExecutionBatchStatus() {
        return this.findJobExecutionBatchStatus;
    }

    public String getFindJobExecutionExitStatus() {
        return this.findJobExecutionExitStatus;
    }

    public String getFindJobExecutionJobProperties() {
        return this.findJobExecutionJobProperties;
    }

    public String getUpdateJobExecution() {
        return this.updateJobExecution;
    }

    public String getSetJobExecutionFinalData() {
        return this.setJobExecutionFinalData;
    }

    public String getUpdateStartedJobExecution() {
        return this.updateStartedJobExecution;
    }

    public String getFindJobExecutionById() {
        return this.findJobExecutionById;
    }

    public String getFindJobExecutionByInstance() {
        return this.findJobExecutionByInstance;
    }

    public String getFindRunningJobExecutions() {
        return this.findRunningJobExecutions;
    }

    public String getFindJobStatus() {
        return this.findJobStatus;
    }

    public String getFindJobInstanceFromJobExecution() {
        return this.findJobInstanceFromJobExecution;
    }

    public String getCreateJobExecution() {
        return this.createJobExecution;
    }

    public String getFindMostRecentJobExecution() {
        return this.findMostRecentJobExecution;
    }

    public String getDeleteJobExecution() {
        return this.deleteJobExecution;
    }

    public String getStepExecutionTable() {
        return this.stepExecutionTable;
    }

    public String getCreateStepExecutionTable() {
        return this.createStepExecutionTable;
    }

    public String getFinStepExecutionFromJobExecution() {
        return this.finStepExecutionFromJobExecution;
    }

    public String getFindStepExecutionFromId() {
        return this.findStepExecutionFromId;
    }

    public String getCreateStepExecution() {
        return this.createStepExecution;
    }

    public String getUpdateStepExecutionStatus() {
        return this.updateStepExecutionStatus;
    }

    public String getUpdateStepExecution() {
        return this.updateStepExecution;
    }

    public String getFindStepExecutionByJobInstanceAndStepName() {
        return this.findStepExecutionByJobInstanceAndStepName;
    }

    public String getDeleteStepExecution() {
        return this.deleteStepExecution;
    }

    public String checkpointColumn(int idx) {
        return this.checkpointColumns[idx];
    }

    public String jobInstanceColumns(int idx) {
        return this.jobInstanceColumns[idx];
    }

    public String jobExecutionColumns(int idx) {
        return this.jobExecutionColumns[idx];
    }

    public String stepExecutionColumns(int idx) {
        return this.stepExecutionColumns[idx];
    }

    public static interface SQL {
        public static final String CREATE_TABLE = "create table ";
        public static final String INSERT_INTO = "insert into ";
        public static final String SELECT = "select ";
        public static final String FROM = " from ";
        public static final String UPDATE = "update ";
        public static final String WHERE = " where ";
        public static final String DELETE = "delete from ";
        public static final String[] CHECKPOINT_COLUMNS = new String[]{"id", "data", "stepName", "type", "INSTANCE_JOBINSTANCEID"};
        public static final String CREATE_CHECKPOINT = "create table %s(%s %s %s , %s %s, %s %s, %s %s, %s %s, primary key(id))";
        public static final String INSERT_CHECKPOINT = "insert into %s(%s, %s, %s, %s) values (?, ?, ?, ?)";
        public static final String SELECT_CHECKPOINT = "select %s from %s where %s = ? and %s = ? and %s = ?";
        public static final String UPDATE_CHECKPOINT = "update %s set %s = ? where %s = ? and %s = ? and %s = ?";
        public static final String DELETE_CHECKPOINT = "delete from %s where %s = ?";
        public static final String[] JOB_INSTANCE_COLUMNS = new String[]{"jobInstanceId", "batchStatus", "exitStatus", "jobName", "jobXml", "latestExecution", "restartOn", "step", "tag"};
        public static final String CREATE_JOB_INSTANCE = "create table %s(%s %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, PRIMARY KEY (%s))";
        public static final String JOB_INSTANCE_COUNT_FROM_NAME = "select count(%s) as jobinstancecount from %s where %s = ?";
        public static final String JOB_INSTANCE_BY_ID = "select * from %s where %s = ?";
        public static final String JOB_INSTANCE_UPDATE_STATUS = "update %s set %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ? where %s = ?";
        public static final String JOB_INSTANCE_COUNT = "select count(%s) as jobinstancecount from %s where %s = ? and %s = ?";
        public static final String JOB_INSTANCE_IDS = "select %s from %s where %s = ? and %s = ? order by %s desc";
        public static final String JOB_INSTANCE_IDS_FROM_NAME = "select %s from %s where  %s = ? order by %s desc";
        public static final String EXTERNAL_JOB_INSTANCE = "select distinct %s, %s from %s where %s not like '%s'";
        public static final String JOB_INSTANCE_CREATE = "insert into %s(%s, %s) VALUES(?, ?)";
        public static final String JOB_INSTANCE_CREATE_WITH_JOB_XML = "insert into %s(%s, %s, %s) VALUES(?, ?, ?)";
        public static final String DELETE_JOB_INSTANCE = "delete from %s where %s = ?";
        public static final String[] JOB_EXECUTION_COLUMNS = new String[]{"executionId", "batchStatus", "createTime", "endTime", "exitStatus", "jobProperties", "startTime", "updateTime", "INSTANCE_JOBINSTANCEID"};
        public static final String CREATE_JOB_EXECUTION = "create table %s(%s %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s)";
        public static final String JOB_EXECUTION_TIMESTAMPS = "select  %s, %s, %s, %s from %s where %s = ?";
        public static final String JOB_EXECUTION_BATCH_STATUS = "select %s from %s where %s = ?";
        public static final String JOB_EXECUTION_EXIT_STATUS = "select %s from %s where %s = ?";
        public static final String JOB_EXECUTION_PROPERTIES = "select %s from %s where %s = ?";
        public static final String JOB_EXECUTION_UPDATE = "update %s set %s = ?, %s = ? where %s = ?";
        public static final String JOB_EXECUTION_SET_FINAL_DATA = "update %s set %s = ?, %s = ?, %s = ?, %s = ? where %s = ?";
        public static final String JOB_EXECUTION_START = "update %s set %s = ?, %s = ?, %s = ? where %s = ?";
        public static final String JOB_EXECUTION_FIND_BY_ID = "select A.%s, A.%s, A.%s, A.%s, A.%s, A.%s, A.%s, A.%s, B.%s from %s as A inner join %s as B on A.%s = B.%s where %s = ?";
        public static final String JOB_EXECUTION_FROM_INSTANCE = "select A.%s, A.%s, A.%s, A.%s, A.%s, A.%s, A.%s, A.%s, B.%s  from %s as A inner join %s as B ON A.%s = B.%s where B.%s = ?";
        public static final String JOB_EXECUTION_RUNNING = "select A.%s from %s AS A inner join %s AS B ON A.%s = B.%s WHERE A.%s IN (?,?,?) AND B.%s = ?";
        public static final String JOB_INSTANCE_STATUS = "select * from %s as A inner join %s as B on A.%s = B.%s  where B.%s = ?";
        public static final String JOB_INSTANCE_FROM_EXECUTION = "select %s from %s where %s = ?";
        public static final String JOB_EXECUTION_CREATE = "insert into %s(%s, %s, %s, %s, %s) VALUES(?, ?, ?, ?, ?)";
        public static final String JOB_EXECUTION_MOST_RECENT = "select %s from %s where %s = ? ORDER BY %s DESC";
        public static final String DELETE_JOB_EXECUTION = "delete from %s where %s = ?";
        public static final String[] STEP_EXECUTION_COLUMNS = new String[]{"id", "batchStatus", "exec_commit", "endTime", "exitStatus", "exec_filter", "lastRunStepExecutionId", "numPartitions", "persistentData", "exec_processskip", "exec_read", "exec_readskip", "exec_rollback", "startCount", "startTime", "stepName", "exec_write", "exec_writeskip", "EXECUTION_EXECUTIONID"};
        public static final String CREATE_STEP_EXECUTION = "create table %s(%s %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, %s %s, PRIMARY KEY (id))";
        public static final String STEPS_FROM_EXECUTION = "select * from %s where %s = ?";
        public static final String STEP_FROM_ID = "select * from %s where %s = ?";
        public static final String STEP_EXECUTION_CREATE = "insert into %s(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        public static final String STEP_EXECUTION_UPDATE_STATUS = "update %s SET %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ? WHERE %s = ?";
        public static final String STEP_EXECUTION_UPDATE = "update %s SET %s = ?, %s = ?, %s = ?, %s = ?,  %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ? WHERE %s = ?";
        public static final String STEP_EXECUTION_BY_INSTANCE_AND_STEP = "select B.%s, B.%s, B.%s, B.%s, B.%s, B.%s, B.%s, B.%s from %s A inner join %s B ON A.%s = B.%s  where A.%s = ? and B.%s = ?";
        public static final String DELETE_STEP_EXECUTION = "delete from %s A inner join %s B ON A.%s = B.%s  where A.%s = ?";
    }
}

