/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.services.BatchKernelService;
import org.apache.batchee.container.services.JobStatusManagerService;
import org.apache.batchee.container.services.ServicesManagerLocator;
import org.apache.batchee.container.services.callback.SimpleJobExecutionCallbackService;
import org.apache.batchee.container.services.executor.DefaultThreadPoolService;
import org.apache.batchee.container.services.factory.CDIBatchArtifactFactory;
import org.apache.batchee.container.services.factory.DefaultBatchArtifactFactory;
import org.apache.batchee.container.services.kernel.DefaultBatchKernel;
import org.apache.batchee.container.services.loader.DefaultJobXMLLoaderService;
import org.apache.batchee.container.services.locator.SingletonLocator;
import org.apache.batchee.container.services.persistence.MemoryPersistenceManagerService;
import org.apache.batchee.container.services.security.DefaultSecurityService;
import org.apache.batchee.container.services.status.DefaultJobStatusManager;
import org.apache.batchee.container.services.transaction.DefaultBatchTransactionService;
import org.apache.batchee.container.util.BatchContainerConstants;
import org.apache.batchee.spi.BatchArtifactFactory;
import org.apache.batchee.spi.BatchService;
import org.apache.batchee.spi.BatchThreadPoolService;
import org.apache.batchee.spi.JobExecutionCallbackService;
import org.apache.batchee.spi.JobXMLLoaderService;
import org.apache.batchee.spi.PersistenceManagerService;
import org.apache.batchee.spi.SecurityService;
import org.apache.batchee.spi.TransactionManagementService;

public class ServicesManager
implements BatchContainerConstants {
    private static final Logger LOGGER = Logger.getLogger(ServicesManager.class.getName());
    private static final String SERVICES_CONFIGURATION_FILE = "batchee.properties";
    private static final Map<String, String> SERVICE_IMPL_CLASS_NAMES = new ConcurrentHashMap<String, String>();
    private static ServicesManagerLocator servicesManagerLocator;
    private ClassLoader loader = null;
    private final byte[] isInitedLock = new byte[0];
    private volatile boolean isInited = false;
    private Properties batchRuntimeConfig;
    private boolean logServices;
    private final ConcurrentHashMap<String, BatchService> serviceRegistry = new ConcurrentHashMap();

    public static void setServicesManagerLocator(ServicesManagerLocator locator) {
        servicesManagerLocator = locator;
    }

    public static ServicesManager find() {
        return servicesManagerLocator.find();
    }

    public static String value(String key, String defaultValue) {
        return ServicesManager.servicesManagerLocator.find().batchRuntimeConfig.getProperty(key, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(Properties props) {
        if (this.isInited) return;
        byte[] byArray = this.isInitedLock;
        synchronized (this.isInitedLock) {
            if (this.isInited) return;
            this.batchRuntimeConfig = new Properties();
            this.batchRuntimeConfig.putAll(SERVICE_IMPL_CLASS_NAMES);
            this.loader = Thread.currentThread().getContextClassLoader();
            InputStream batchServicesListInputStream = this.loader.getResourceAsStream(SERVICES_CONFIGURATION_FILE);
            if (batchServicesListInputStream != null) {
                try {
                    this.batchRuntimeConfig.load(batchServicesListInputStream);
                }
                catch (Exception e) {
                    LOGGER.config("Error loading batchee.properties Exception=" + e.toString());
                }
                finally {
                    try {
                        batchServicesListInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (props != null) {
                this.batchRuntimeConfig.putAll((Map<?, ?>)props);
            }
            this.batchRuntimeConfig.putAll((Map<?, ?>)System.getProperties());
            this.logServices = Boolean.parseBoolean(this.batchRuntimeConfig.getProperty("batchee.service-manager.log", "false"));
            this.isInited = Boolean.TRUE;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BatchService> T service(Class<T> clazz) throws BatchContainerServiceException {
        BatchService service = (BatchService)clazz.cast(this.serviceRegistry.get(clazz.getName()));
        if (service == null) {
            ConcurrentHashMap<String, BatchService> concurrentHashMap = this.serviceRegistry;
            synchronized (concurrentHashMap) {
                service = (BatchService)clazz.cast(this.serviceRegistry.get(clazz.getName()));
                if (service == null) {
                    service = this.loadService(clazz);
                    service.init(this.batchRuntimeConfig);
                    this.serviceRegistry.putIfAbsent(clazz.getName(), service);
                }
            }
        }
        return (T)service;
    }

    private <T extends BatchService> T loadService(Class<T> serviceType) {
        Object existing = this.batchRuntimeConfig.get(serviceType.getName());
        if (serviceType.isInstance(existing)) {
            return (T)((BatchService)serviceType.cast(existing));
        }
        BatchService service = null;
        String className = this.batchRuntimeConfig.getProperty(serviceType.getSimpleName());
        try {
            if (className != null) {
                service = (BatchService)this.load(serviceType, className);
            } else {
                className = (String)String.class.cast(existing);
                if (className != null) {
                    service = (BatchService)this.load(serviceType, className);
                }
            }
        }
        catch (Throwable e1) {
            this.handleBatchContainerRuntimeException(e1);
            throw new IllegalArgumentException("Could not instantiate service " + className + " due to exception: " + e1);
        }
        if (service == null) {
            throw new BatchContainerRuntimeException("Instantiate of service=: " + className + " returned null. Aborting...");
        }
        if (this.logServices) {
            LOGGER.info("Using " + service + " (" + className + ") as " + serviceType.getName());
        }
        return (T)service;
    }

    private <T> T load(Class<T> expected, String className) throws Exception {
        Class<?> cls = null;
        try {
            cls = this.getLoader().loadClass(className);
        }
        catch (Exception e) {
            this.handleBatchContainerRuntimeException(e);
            throw new BatchContainerRuntimeException("Could not load Service class " + className + ". Make sure it exists", e);
        }
        Throwable problem = null;
        try {
            Constructor<?> constructor = cls.getConstructor(ServicesManager.class);
            return expected.cast(constructor.newInstance(this));
        }
        catch (Throwable th) {
            this.handleBatchContainerRuntimeException(th);
            problem = th;
            try {
                if (cls.getConstructor(new Class[0]) != null) {
                    return expected.cast(cls.newInstance());
                }
            }
            catch (Throwable th2) {
                this.handleBatchContainerRuntimeException(th2);
            }
            throw new BatchContainerRuntimeException("Service class " + className + " cannnot be loaded", problem);
        }
    }

    private void handleBatchContainerRuntimeException(Throwable e) throws BatchContainerRuntimeException {
        InvocationTargetException ite;
        if (e instanceof BatchContainerRuntimeException) {
            throw (BatchContainerRuntimeException)e;
        }
        if (e instanceof InvocationTargetException && (ite = (InvocationTargetException)e).getCause() instanceof BatchContainerRuntimeException) {
            throw (BatchContainerRuntimeException)ite.getCause();
        }
    }

    private ClassLoader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    static {
        SERVICE_IMPL_CLASS_NAMES.put(TransactionManagementService.class.getName(), DefaultBatchTransactionService.class.getName());
        SERVICE_IMPL_CLASS_NAMES.put(PersistenceManagerService.class.getName(), MemoryPersistenceManagerService.class.getName());
        SERVICE_IMPL_CLASS_NAMES.put(JobStatusManagerService.class.getName(), DefaultJobStatusManager.class.getName());
        SERVICE_IMPL_CLASS_NAMES.put(BatchThreadPoolService.class.getName(), DefaultThreadPoolService.class.getName());
        SERVICE_IMPL_CLASS_NAMES.put(BatchKernelService.class.getName(), DefaultBatchKernel.class.getName());
        SERVICE_IMPL_CLASS_NAMES.put(JobXMLLoaderService.class.getName(), DefaultJobXMLLoaderService.class.getName());
        SERVICE_IMPL_CLASS_NAMES.put(SecurityService.class.getName(), DefaultSecurityService.class.getName());
        SERVICE_IMPL_CLASS_NAMES.put(JobExecutionCallbackService.class.getName(), SimpleJobExecutionCallbackService.class.getName());
        try {
            Thread.currentThread().getContextClassLoader().loadClass("javax.enterprise.inject.spi.BeanManager");
            SERVICE_IMPL_CLASS_NAMES.put(BatchArtifactFactory.class.getName(), CDIBatchArtifactFactory.class.getName());
        }
        catch (Throwable th) {
            SERVICE_IMPL_CLASS_NAMES.put(BatchArtifactFactory.class.getName(), DefaultBatchArtifactFactory.class.getName());
        }
        ServicesManager.setServicesManagerLocator(SingletonLocator.INSTANCE);
    }
}

