/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.chunk;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.chunk.CheckpointAlgorithm;
import javax.batch.api.chunk.listener.ChunkListener;
import javax.batch.api.chunk.listener.ItemProcessListener;
import javax.batch.api.chunk.listener.ItemReadListener;
import javax.batch.api.chunk.listener.ItemWriteListener;
import javax.batch.api.chunk.listener.RetryProcessListener;
import javax.batch.api.chunk.listener.RetryReadListener;
import javax.batch.api.chunk.listener.RetryWriteListener;
import javax.batch.api.chunk.listener.SkipProcessListener;
import javax.batch.api.chunk.listener.SkipReadListener;
import javax.batch.api.chunk.listener.SkipWriteListener;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.controller.SingleThreadedStepController;
import org.apache.batchee.container.impl.controller.chunk.CheckpointAlgorithmFactory;
import org.apache.batchee.container.impl.controller.chunk.CheckpointData;
import org.apache.batchee.container.impl.controller.chunk.CheckpointDataKey;
import org.apache.batchee.container.impl.controller.chunk.CheckpointManager;
import org.apache.batchee.container.impl.controller.chunk.CheckpointType;
import org.apache.batchee.container.impl.controller.chunk.ChunkHelper;
import org.apache.batchee.container.impl.controller.chunk.ExceptionConfig;
import org.apache.batchee.container.impl.controller.chunk.ItemCheckpointAlgorithm;
import org.apache.batchee.container.impl.controller.chunk.RetryHandler;
import org.apache.batchee.container.impl.controller.chunk.SkipHandler;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.proxy.CheckpointAlgorithmProxy;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.container.proxy.ProxyFactory;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.util.PartitionDataWrapper;
import org.apache.batchee.container.util.TCCLObjectInputStream;
import org.apache.batchee.jaxb.Chunk;
import org.apache.batchee.jaxb.ItemProcessor;
import org.apache.batchee.jaxb.ItemReader;
import org.apache.batchee.jaxb.ItemWriter;
import org.apache.batchee.jaxb.Property;
import org.apache.batchee.jaxb.Step;
import org.apache.batchee.spi.BatchArtifactFactory;
import org.apache.batchee.spi.PersistenceManagerService;

public class ChunkStepController
extends SingleThreadedStepController {
    private static final Logger logger = Logger.getLogger(ChunkStepController.class.getName());
    private final PersistenceManagerService persistenceManagerService;
    private final BatchArtifactFactory artifactFactory;
    private Chunk chunk = null;
    private javax.batch.api.chunk.ItemReader readerProxy = null;
    private javax.batch.api.chunk.ItemProcessor processorProxy = null;
    private javax.batch.api.chunk.ItemWriter writerProxy = null;
    private CheckpointAlgorithmProxy checkpointProxy = null;
    private CheckpointAlgorithm chkptAlg = null;
    private CheckpointManager checkpointManager;
    private SkipHandler skipHandler = null;
    private CheckpointDataKey readerChkptDK = null;
    private CheckpointDataKey writerChkptDK = null;
    private List<ChunkListener> chunkListeners = null;
    private List<ItemReadListener> itemReadListeners = null;
    private List<ItemProcessListener> itemProcessListeners = null;
    private List<ItemWriteListener> itemWriteListeners = null;
    private RetryHandler retryHandler;
    private boolean rollbackRetry = false;

    public ChunkStepController(RuntimeJobExecution jobExecutionImpl, Step step, StepContextImpl stepContext, long rootJobExecutionId, BlockingQueue<PartitionDataWrapper> analyzerStatusQueue, ServicesManager servicesManager) {
        super(jobExecutionImpl, step, stepContext, rootJobExecutionId, analyzerStatusQueue, servicesManager);
        this.persistenceManagerService = servicesManager.service(PersistenceManagerService.class);
        this.artifactFactory = servicesManager.service(BatchArtifactFactory.class);
    }

    private List<Object> readAndProcess(int chunkSize, ItemStatus theStatus) {
        ArrayList<Object> chunkToWrite = new ArrayList<Object>();
        int readProcessedCount = 0;
        do {
            ItemStatus status = new ItemStatus();
            Object itemRead = this.readItem(status);
            if (status.isRollback()) {
                theStatus.setRollback(true);
                this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                break;
            }
            if (!status.isSkipped() && !status.isFinished()) {
                Object itemProcessed = this.processItem(itemRead, status);
                if (status.isRollback()) {
                    theStatus.setRollback(true);
                    this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                    break;
                }
                if (!status.isSkipped() && !status.isFiltered()) {
                    chunkToWrite.add(itemProcessed);
                    ++readProcessedCount;
                }
            }
            theStatus.setFinished(status.isFinished());
            theStatus.setCheckPointed(this.checkpointManager.applyCheckPointPolicy());
            if (!this.stepContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) continue;
            theStatus.setFinished(true);
        } while ((readProcessedCount != chunkSize || "custom".equals(this.checkpointProxy.getCheckpointType())) && !theStatus.isCheckPointed() && !theStatus.isFinished());
        return chunkToWrite;
    }

    private Object readItem(ItemStatus status) {
        Object itemRead = null;
        try {
            for (ItemReadListener readListenerProxy : this.itemReadListeners) {
                readListenerProxy.beforeRead();
            }
            itemRead = this.readerProxy.readItem();
            for (ItemReadListener readListenerProxy : this.itemReadListeners) {
                readListenerProxy.afterRead(itemRead);
            }
            status.setFinished(itemRead == null);
            if (!status.isFinished()) {
                this.stepContext.getMetric(Metric.MetricType.READ_COUNT).incValue();
            }
        }
        catch (Exception e) {
            this.stepContext.setException(e);
            for (ItemReadListener readListenerProxy : this.itemReadListeners) {
                try {
                    readListenerProxy.onReadError(e);
                }
                catch (Exception e1) {
                    ExceptionConfig.wrapBatchException(e1);
                }
            }
            if (!this.rollbackRetry) {
                if (this.retryReadException(e)) {
                    for (ItemReadListener readListenerProxy : this.itemReadListeners) {
                        try {
                            readListenerProxy.onReadError(e);
                        }
                        catch (Exception e1) {
                            ExceptionConfig.wrapBatchException(e1);
                        }
                    }
                    if (!this.retryHandler.isRollbackException(e)) {
                        itemRead = this.readItem(status);
                    } else {
                        status.setRollback(true);
                        this.rollbackRetry = true;
                        this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                    }
                }
                if (this.skipReadException(e)) {
                    status.setSkipped(true);
                    this.stepContext.getMetric(Metric.MetricType.READ_SKIP_COUNT).incValue();
                }
                throw new BatchContainerRuntimeException(e);
            }
            if (this.skipReadException(e)) {
                status.setSkipped(true);
                this.stepContext.getMetric(Metric.MetricType.READ_SKIP_COUNT).incValue();
            }
            if (this.retryReadException(e)) {
                if (!this.retryHandler.isRollbackException(e)) {
                    itemRead = this.readItem(status);
                } else {
                    status.setRollback(true);
                    this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                }
            }
            throw new BatchContainerRuntimeException(e);
        }
        catch (Throwable e) {
            throw new BatchContainerRuntimeException(e);
        }
        return itemRead;
    }

    private Object processItem(Object itemRead, ItemStatus status) {
        Object processedItem = null;
        if (this.processorProxy == null) {
            return itemRead;
        }
        try {
            for (ItemProcessListener processListenerProxy : this.itemProcessListeners) {
                processListenerProxy.beforeProcess(itemRead);
            }
            processedItem = this.processorProxy.processItem(itemRead);
            if (processedItem == null) {
                this.stepContext.getMetric(Metric.MetricType.FILTER_COUNT).incValue();
                status.setFiltered(true);
            }
            for (ItemProcessListener processListenerProxy : this.itemProcessListeners) {
                processListenerProxy.afterProcess(itemRead, processedItem);
            }
        }
        catch (Exception e) {
            for (ItemProcessListener processListenerProxy : this.itemProcessListeners) {
                try {
                    processListenerProxy.onProcessError(itemRead, e);
                }
                catch (Exception e1) {
                    ExceptionConfig.wrapBatchException(e1);
                }
            }
            if (!this.rollbackRetry) {
                if (this.retryProcessException(e, itemRead)) {
                    if (!this.retryHandler.isRollbackException(e)) {
                        for (ItemProcessListener processListenerProxy : this.itemProcessListeners) {
                            try {
                                processListenerProxy.beforeProcess(itemRead);
                            }
                            catch (Exception e1) {
                                ExceptionConfig.wrapBatchException(e1);
                            }
                        }
                        processedItem = this.processItem(itemRead, status);
                        if (processedItem == null) {
                            this.stepContext.getMetric(Metric.MetricType.FILTER_COUNT).incValue();
                            status.setFiltered(true);
                        }
                        for (ItemProcessListener processListenerProxy : this.itemProcessListeners) {
                            try {
                                processListenerProxy.afterProcess(itemRead, processedItem);
                            }
                            catch (Exception e1) {
                                ExceptionConfig.wrapBatchException(e1);
                            }
                        }
                    } else {
                        status.setRollback(true);
                        this.rollbackRetry = true;
                        this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                    }
                }
                if (this.skipProcessException(e, itemRead)) {
                    status.setSkipped(true);
                    this.stepContext.getMetric(Metric.MetricType.PROCESS_SKIP_COUNT).incValue();
                }
                throw new BatchContainerRuntimeException(e);
            }
            if (this.skipProcessException(e, itemRead)) {
                status.setSkipped(true);
                this.stepContext.getMetric(Metric.MetricType.PROCESS_SKIP_COUNT).incValue();
            }
            if (this.retryProcessException(e, itemRead)) {
                if (!this.retryHandler.isRollbackException(e)) {
                    for (ItemProcessListener processListenerProxy : this.itemProcessListeners) {
                        try {
                            processListenerProxy.beforeProcess(itemRead);
                        }
                        catch (Exception e1) {
                            ExceptionConfig.wrapBatchException(e1);
                        }
                    }
                    processedItem = this.processItem(itemRead, status);
                    if (processedItem == null) {
                        this.stepContext.getMetric(Metric.MetricType.FILTER_COUNT).incValue();
                        status.setFiltered(true);
                    }
                    for (ItemProcessListener processListenerProxy : this.itemProcessListeners) {
                        try {
                            processListenerProxy.afterProcess(itemRead, processedItem);
                        }
                        catch (Exception e1) {
                            ExceptionConfig.wrapBatchException(e1);
                        }
                    }
                } else {
                    status.setRollback(true);
                    this.rollbackRetry = true;
                    this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                }
            }
            throw new BatchContainerRuntimeException(e);
        }
        catch (Throwable e) {
            throw new BatchContainerRuntimeException(e);
        }
        return processedItem;
    }

    private void writeChunk(List<Object> theChunk, ItemStatus status) {
        if (!theChunk.isEmpty()) {
            try {
                for (ItemWriteListener writeListenerProxy : this.itemWriteListeners) {
                    writeListenerProxy.beforeWrite(theChunk);
                }
                this.writerProxy.writeItems(theChunk);
                for (ItemWriteListener writeListenerProxy : this.itemWriteListeners) {
                    writeListenerProxy.afterWrite(theChunk);
                }
                this.stepContext.getMetric(Metric.MetricType.WRITE_COUNT).incValueBy(theChunk.size());
            }
            catch (Exception e) {
                this.stepContext.setException(e);
                for (ItemWriteListener writeListenerProxy : this.itemWriteListeners) {
                    try {
                        writeListenerProxy.onWriteError(theChunk, e);
                    }
                    catch (Exception e1) {
                        ExceptionConfig.wrapBatchException(e1);
                    }
                }
                if (!this.rollbackRetry) {
                    if (this.retryWriteException(e, theChunk)) {
                        if (!this.retryHandler.isRollbackException(e)) {
                            this.writeChunk(theChunk, status);
                        } else {
                            this.rollbackRetry = true;
                            status.setRollback(true);
                            this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                        }
                    }
                    if (this.skipWriteException(e, theChunk)) {
                        this.stepContext.getMetric(Metric.MetricType.WRITE_SKIP_COUNT).incValueBy(1L);
                    }
                    throw new BatchContainerRuntimeException(e);
                }
                if (this.skipWriteException(e, theChunk)) {
                    this.stepContext.getMetric(Metric.MetricType.WRITE_SKIP_COUNT).incValueBy(1L);
                }
                if (this.retryWriteException(e, theChunk)) {
                    if (!this.retryHandler.isRollbackException(e)) {
                        status.setRetry(true);
                        this.writeChunk(theChunk, status);
                    } else {
                        this.rollbackRetry = true;
                        status.setRollback(true);
                        this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                    }
                }
                throw new BatchContainerRuntimeException(e);
            }
            catch (Throwable e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    private void invokeChunk() {
        int itemCount = ChunkHelper.getItemCount(this.chunk);
        int timeInterval = ChunkHelper.getTimeLimit(this.chunk);
        boolean checkPointed = true;
        boolean rollback = false;
        try {
            this.transactionManager.begin();
            this.openReaderAndWriter();
            this.transactionManager.commit();
            while (true) {
                if (checkPointed || rollback) {
                    if ("custom".equals(this.checkpointProxy.getCheckpointType())) {
                        int newtimeOut = this.checkpointManager.checkpointTimeout();
                        this.transactionManager.setTransactionTimeout(newtimeOut);
                    }
                    this.transactionManager.begin();
                    for (ChunkListener chunkProxy : this.chunkListeners) {
                        chunkProxy.beforeChunk();
                    }
                    if (rollback) {
                        this.positionReaderAtCheckpoint();
                        this.positionWriterAtCheckpoint();
                        this.checkpointManager = new CheckpointManager(this.readerProxy, this.writerProxy, this.getCheckpointAlgorithm(itemCount, timeInterval), this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), this.persistenceManagerService);
                    }
                }
                ItemStatus status = new ItemStatus();
                if (rollback) {
                    rollback = false;
                }
                List<Object> chunkToWrite = this.readAndProcess(itemCount, status);
                if (status.isRollback()) {
                    itemCount = 1;
                    rollback = true;
                    this.readerProxy.close();
                    this.writerProxy.close();
                    this.transactionManager.rollback();
                    continue;
                }
                this.writeChunk(chunkToWrite, status);
                if (status.isRollback()) {
                    itemCount = 1;
                    rollback = true;
                    this.readerProxy.close();
                    this.writerProxy.close();
                    this.transactionManager.rollback();
                    continue;
                }
                checkPointed = status.isCheckPointed();
                if (!status.isCheckPointed() && !status.isFinished()) continue;
                this.checkpointManager.checkpoint();
                for (ChunkListener chunkProxy : this.chunkListeners) {
                    chunkProxy.afterChunk();
                }
                this.persistUserData();
                this.chkptAlg.beginCheckpoint();
                this.transactionManager.commit();
                this.chkptAlg.endCheckpoint();
                this.invokeCollectorIfPresent();
                if (status.isFinished()) {
                    this.transactionManager.begin();
                    this.readerProxy.close();
                    this.writerProxy.close();
                    this.transactionManager.commit();
                    this.stepContext.getMetric(Metric.MetricType.COMMIT_COUNT).incValue();
                    break;
                }
                this.stepContext.getMetric(Metric.MetricType.COMMIT_COUNT).incValue();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failure in Read-Process-Write Loop", e);
            for (ChunkListener chunkProxy : this.chunkListeners) {
                try {
                    chunkProxy.onError(e);
                }
                catch (Exception e1) {
                    logger.log(Level.SEVERE, e1.getMessage(), e1);
                }
            }
            this.rollback(e);
        }
        catch (Throwable t) {
            this.rollback(t);
        }
    }

    private void rollback(Throwable t) {
        this.transactionManager.setRollbackOnly();
        try {
            this.readerProxy.close();
            this.writerProxy.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.transactionManager.rollback();
        throw new BatchContainerRuntimeException("Failure in Read-Process-Write Loop", t);
    }

    @Override
    protected void invokeCoreStep() throws BatchContainerServiceException {
        this.chunk = this.step.getChunk();
        this.initializeChunkArtifacts();
        this.invokeChunk();
    }

    private CheckpointAlgorithm getCheckpointAlgorithm(int itemCount, int timeInterval) {
        Object alg;
        if ("item".equals(this.checkpointProxy.getCheckpointType())) {
            alg = new ItemCheckpointAlgorithm();
            ((ItemCheckpointAlgorithm)alg).setThresholds(itemCount, timeInterval);
        } else {
            alg = this.checkpointProxy;
        }
        return alg;
    }

    private void initializeChunkArtifacts() {
        ItemWriter itemWriter;
        int itemCount = ChunkHelper.getItemCount(this.chunk);
        int timeInterval = ChunkHelper.getTimeLimit(this.chunk);
        ItemReader itemReader = this.chunk.getReader();
        List<Property> itemReaderProps = itemReader.getProperties() == null ? null : itemReader.getProperties().getPropertyList();
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, itemReaderProps);
        this.readerProxy = ProxyFactory.createItemReaderProxy(this.artifactFactory, itemReader.getRef(), injectionRef, this.jobExecutionImpl);
        ItemProcessor itemProcessor = this.chunk.getProcessor();
        if (itemProcessor != null) {
            List<Property> itemProcessorProps = itemProcessor.getProperties() == null ? null : itemProcessor.getProperties().getPropertyList();
            injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, itemProcessorProps);
            this.processorProxy = ProxyFactory.createItemProcessorProxy(this.artifactFactory, itemProcessor.getRef(), injectionRef, this.jobExecutionImpl);
        }
        List<Property> itemWriterProps = (itemWriter = this.chunk.getWriter()).getProperties() == null ? null : itemWriter.getProperties().getPropertyList();
        injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, itemWriterProps);
        this.writerProxy = ProxyFactory.createItemWriterProxy(this.artifactFactory, itemWriter.getRef(), injectionRef, this.jobExecutionImpl);
        List<Property> propList = this.chunk.getCheckpointAlgorithm() != null ? (this.chunk.getCheckpointAlgorithm().getProperties() == null ? null : this.chunk.getCheckpointAlgorithm().getProperties().getPropertyList()) : null;
        InjectionReferences injectionRef2 = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
        this.checkpointProxy = CheckpointAlgorithmFactory.getCheckpointAlgorithmProxy(this.artifactFactory, this.step, injectionRef2, this.jobExecutionImpl);
        InjectionReferences injectionRef3 = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, null);
        this.chunkListeners = this.jobExecutionImpl.getListenerFactory().getListeners(ChunkListener.class, this.step, injectionRef3, this.jobExecutionImpl);
        this.itemReadListeners = this.jobExecutionImpl.getListenerFactory().getListeners(ItemReadListener.class, this.step, injectionRef3, this.jobExecutionImpl);
        this.itemProcessListeners = this.jobExecutionImpl.getListenerFactory().getListeners(ItemProcessListener.class, this.step, injectionRef3, this.jobExecutionImpl);
        this.itemWriteListeners = this.jobExecutionImpl.getListenerFactory().getListeners(ItemWriteListener.class, this.step, injectionRef3, this.jobExecutionImpl);
        List<SkipProcessListener> skipProcessListeners = this.jobExecutionImpl.getListenerFactory().getListeners(SkipProcessListener.class, this.step, injectionRef3, this.jobExecutionImpl);
        List<SkipReadListener> skipReadListeners = this.jobExecutionImpl.getListenerFactory().getListeners(SkipReadListener.class, this.step, injectionRef3, this.jobExecutionImpl);
        List<SkipWriteListener> skipWriteListeners = this.jobExecutionImpl.getListenerFactory().getListeners(SkipWriteListener.class, this.step, injectionRef3, this.jobExecutionImpl);
        List<RetryProcessListener> retryProcessListeners = this.jobExecutionImpl.getListenerFactory().getListeners(RetryProcessListener.class, this.step, injectionRef3, this.jobExecutionImpl);
        List<RetryReadListener> retryReadListeners = this.jobExecutionImpl.getListenerFactory().getListeners(RetryReadListener.class, this.step, injectionRef3, this.jobExecutionImpl);
        List<RetryWriteListener> retryWriteListeners = this.jobExecutionImpl.getListenerFactory().getListeners(RetryWriteListener.class, this.step, injectionRef3, this.jobExecutionImpl);
        if ("item".equals(this.checkpointProxy.getCheckpointType())) {
            this.chkptAlg = new ItemCheckpointAlgorithm();
            ((ItemCheckpointAlgorithm)ItemCheckpointAlgorithm.class.cast(this.chkptAlg)).setThresholds(itemCount, timeInterval);
        } else {
            this.chkptAlg = this.checkpointProxy;
        }
        this.checkpointManager = new CheckpointManager(this.readerProxy, this.writerProxy, this.chkptAlg, this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), this.persistenceManagerService);
        this.skipHandler = new SkipHandler(this.chunk);
        this.skipHandler.addSkipProcessListener(skipProcessListeners);
        this.skipHandler.addSkipReadListener(skipReadListeners);
        this.skipHandler.addSkipWriteListener(skipWriteListeners);
        this.retryHandler = new RetryHandler(this.chunk);
        this.retryHandler.addRetryProcessListener(retryProcessListeners);
        this.retryHandler.addRetryReadListener(retryReadListeners);
        this.retryHandler.addRetryWriteListener(retryWriteListeners);
    }

    private void openReaderAndWriter() {
        block15: {
            block14: {
                this.readerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), CheckpointType.READER);
                CheckpointData readerChkptData = this.persistenceManagerService.getCheckpointData(this.readerChkptDK);
                try {
                    if (readerChkptData != null) {
                        byte[] readertoken = readerChkptData.getRestartToken();
                        ByteArrayInputStream readerChkptBA = new ByteArrayInputStream(readertoken);
                        try {
                            TCCLObjectInputStream readerOIS = new TCCLObjectInputStream(readerChkptBA);
                            this.readerProxy.open((Serializable)readerOIS.readObject());
                            readerOIS.close();
                            break block14;
                        }
                        catch (Exception ex) {
                            throw new BatchContainerServiceException("Cannot read the checkpoint data for [" + this.step.getId() + "]", ex);
                        }
                    }
                    readerChkptData = null;
                    try {
                        this.readerProxy.open(null);
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Exception while opening step [" + this.step.getId() + "]", ex);
                    }
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException("Expected CheckpointData but found" + readerChkptData);
                }
            }
            this.writerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), CheckpointType.WRITER);
            CheckpointData writerChkptData = this.persistenceManagerService.getCheckpointData(this.writerChkptDK);
            try {
                if (writerChkptData != null) {
                    byte[] writertoken = writerChkptData.getRestartToken();
                    ByteArrayInputStream writerChkptBA = new ByteArrayInputStream(writertoken);
                    try {
                        TCCLObjectInputStream writerOIS = new TCCLObjectInputStream(writerChkptBA);
                        this.writerProxy.open((Serializable)writerOIS.readObject());
                        writerOIS.close();
                        break block15;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                writerChkptData = null;
                try {
                    this.writerProxy.open(null);
                }
                catch (Exception e) {
                    ExceptionConfig.wrapBatchException(e);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Expected Checkpoint but found" + writerChkptData);
            }
        }
    }

    @Override
    public void stop() {
        this.stepContext.setBatchStatus(BatchStatus.STOPPING);
    }

    private boolean skipReadException(Exception e) {
        try {
            this.skipHandler.handleExceptionRead(e);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private boolean retryReadException(Exception e) {
        try {
            this.retryHandler.handleExceptionRead(e);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private boolean skipProcessException(Exception e, Object record) {
        try {
            this.skipHandler.handleExceptionWithRecordProcess(e, record);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private boolean retryProcessException(Exception e, Object record) {
        try {
            this.retryHandler.handleExceptionProcess(e, record);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private boolean skipWriteException(Exception e, List<Object> chunkToWrite) {
        try {
            this.skipHandler.handleExceptionWithRecordListWrite(e, chunkToWrite);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private boolean retryWriteException(Exception e, List<Object> chunkToWrite) {
        try {
            this.retryHandler.handleExceptionWrite(e, chunkToWrite);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private void positionReaderAtCheckpoint() {
        block7: {
            this.readerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), CheckpointType.READER);
            CheckpointData readerData = this.persistenceManagerService.getCheckpointData(this.readerChkptDK);
            try {
                if (readerData != null) {
                    byte[] readertoken = readerData.getRestartToken();
                    ByteArrayInputStream readerChkptBA = new ByteArrayInputStream(readertoken);
                    try {
                        TCCLObjectInputStream readerOIS = new TCCLObjectInputStream(readerChkptBA);
                        this.readerProxy.open((Serializable)readerOIS.readObject());
                        readerOIS.close();
                        break block7;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                readerData = null;
                try {
                    this.readerProxy.open(null);
                }
                catch (Exception ex) {
                    throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Expected CheckpointData but found" + readerData);
            }
        }
    }

    private void positionWriterAtCheckpoint() {
        block7: {
            this.writerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), CheckpointType.WRITER);
            CheckpointData writerData = this.persistenceManagerService.getCheckpointData(this.writerChkptDK);
            try {
                if (writerData != null) {
                    byte[] writertoken = writerData.getRestartToken();
                    ByteArrayInputStream writerChkptBA = new ByteArrayInputStream(writertoken);
                    try {
                        TCCLObjectInputStream writerOIS = new TCCLObjectInputStream(writerChkptBA);
                        this.writerProxy.open((Serializable)writerOIS.readObject());
                        writerOIS.close();
                        break block7;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot read the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                writerData = null;
                try {
                    this.writerProxy.open(null);
                }
                catch (Exception ex) {
                    throw new BatchContainerServiceException("Cannot open the step [" + this.step.getId() + "]", ex);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Expected CheckpointData but found" + writerData);
            }
        }
    }

    private class ItemStatus {
        private boolean skipped = false;
        private boolean filtered = false;
        private boolean finished = false;
        private boolean checkPointed = false;
        private boolean rollback = false;

        private ItemStatus() {
        }

        public boolean isSkipped() {
            return this.skipped;
        }

        public void setSkipped(boolean skipped) {
            this.skipped = skipped;
        }

        public boolean isFiltered() {
            return this.filtered;
        }

        public void setFiltered(boolean filtered) {
            this.filtered = filtered;
        }

        public boolean isCheckPointed() {
            return this.checkPointed;
        }

        public void setCheckPointed(boolean checkPointed) {
            this.checkPointed = checkPointed;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        public void setRetry(boolean ignored) {
        }

        public boolean isRollback() {
            return this.rollback;
        }

        public void setRollback(boolean rollback) {
            this.rollback = rollback;
        }
    }
}

