/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class TCCLObjectInputStream
extends ObjectInputStream {
    private final ClassLoader tccl = Thread.currentThread().getContextClassLoader();

    public TCCLObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        return Class.forName(desc.getName(), false, this.tccl);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = Class.forName(interfaces[i], false, this.tccl);
        }
        try {
            return Proxy.getProxyClass(this.tccl, cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

