/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.chunk;

import java.util.List;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.impl.controller.chunk.ExceptionConfig;
import org.apache.batchee.container.proxy.RetryProcessListenerProxy;
import org.apache.batchee.container.proxy.RetryReadListenerProxy;
import org.apache.batchee.container.proxy.RetryWriteListenerProxy;
import org.apache.batchee.jaxb.Chunk;
import org.apache.batchee.jaxb.ExceptionClassFilter;

public class RetryHandler {
    private List<RetryProcessListenerProxy> _retryProcessListeners = null;
    private List<RetryReadListenerProxy> _retryReadListeners = null;
    private List<RetryWriteListenerProxy> _retryWriteListeners = null;
    private ExceptionConfig retryNoRBConfig = new ExceptionConfig();
    private ExceptionConfig retryConfig = new ExceptionConfig();
    private int _retryLimit = Integer.MIN_VALUE;
    private long _retryCount = 0L;
    private Exception _retryException = null;

    public RetryHandler(Chunk chunk) {
        List<ExceptionClassFilter.Exclude> excludes;
        List<ExceptionClassFilter.Include> includes;
        try {
            if (chunk.getRetryLimit() != null) {
                this._retryLimit = Integer.parseInt(chunk.getRetryLimit());
                if (this._retryLimit < 0) {
                    throw new IllegalArgumentException("The retry-limit attribute on a chunk cannot be a negative value");
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("NumberFormatException reading retry-limit", nfe);
        }
        if (chunk.getRetryableExceptionClasses() != null) {
            if (chunk.getRetryableExceptionClasses().getIncludeList() != null) {
                includes = chunk.getRetryableExceptionClasses().getIncludeList();
                for (ExceptionClassFilter.Include include : includes) {
                    this.retryConfig.getIncludes().add(include.getClazz().trim());
                }
            }
            if (chunk.getRetryableExceptionClasses().getExcludeList() != null) {
                excludes = chunk.getRetryableExceptionClasses().getExcludeList();
                for (ExceptionClassFilter.Exclude exclude : excludes) {
                    this.retryConfig.getExcludes().add(exclude.getClazz().trim());
                }
            }
        }
        if (chunk.getNoRollbackExceptionClasses() != null) {
            if (chunk.getNoRollbackExceptionClasses().getIncludeList() != null) {
                includes = chunk.getNoRollbackExceptionClasses().getIncludeList();
                for (ExceptionClassFilter.Include include : includes) {
                    this.retryNoRBConfig.getIncludes().add(include.getClazz().trim());
                }
            }
            if (chunk.getNoRollbackExceptionClasses().getExcludeList() != null) {
                excludes = chunk.getNoRollbackExceptionClasses().getExcludeList();
                for (ExceptionClassFilter.Exclude exclude : excludes) {
                    this.retryNoRBConfig.getExcludes().add(exclude.getClazz().trim());
                }
            }
        }
    }

    public void addRetryProcessListener(List<RetryProcessListenerProxy> retryProcessListeners) {
        this._retryProcessListeners = retryProcessListeners;
    }

    public void addRetryReadListener(List<RetryReadListenerProxy> retryReadListeners) {
        this._retryReadListeners = retryReadListeners;
    }

    public void addRetryWriteListener(List<RetryWriteListenerProxy> retryWriteListeners) {
        this._retryWriteListeners = retryWriteListeners;
    }

    public boolean isRollbackException(Exception e) {
        return !this.isNoRollbackException(e);
    }

    public void handleExceptionRead(Exception e) {
        if (this.isRetryLimitReached() || !this.isRetryable(e)) {
            throw new BatchContainerRuntimeException(e);
        }
        this._retryException = e;
        ++this._retryCount;
        if (this._retryReadListeners != null) {
            for (RetryReadListenerProxy retryReadListenerProxy : this._retryReadListeners) {
                retryReadListenerProxy.onRetryReadException(e);
            }
        }
    }

    public void handleExceptionProcess(Exception e, Object w) {
        if (this.isRetryLimitReached() || !this.isRetryable(e)) {
            throw new BatchContainerRuntimeException(e);
        }
        this._retryException = e;
        ++this._retryCount;
        if (this._retryProcessListeners != null) {
            for (RetryProcessListenerProxy retryProcessListenerProxy : this._retryProcessListeners) {
                retryProcessListenerProxy.onRetryProcessException(w, e);
            }
        }
    }

    public void handleExceptionWrite(Exception e, List<Object> w) {
        if (this.isRetryLimitReached() || !this.isRetryable(e)) {
            throw new BatchContainerRuntimeException(e);
        }
        this._retryException = e;
        ++this._retryCount;
        if (this._retryWriteListeners != null) {
            for (RetryWriteListenerProxy retryWriteListenerProxy : this._retryWriteListeners) {
                retryWriteListenerProxy.onRetryWriteException(w, e);
            }
        }
    }

    private boolean isRetryable(Exception e) {
        return this.retryConfig.accept(e);
    }

    private boolean isNoRollbackException(Exception e) {
        return this.retryNoRBConfig.accept(e);
    }

    private boolean isRetryLimitReached() {
        return this._retryLimit != Integer.MIN_VALUE && this._retryCount >= (long)this._retryLimit;
    }

    public Exception getException() {
        return this._retryException;
    }

    public String toString() {
        return "RetryHandler{" + super.toString() + "}count:limit=" + this._retryCount + ":" + this._retryLimit;
    }
}

