/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.batchee.container.Controller;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.controller.BaseStepController;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.container.proxy.PartitionCollectorProxy;
import org.apache.batchee.container.proxy.ProxyFactory;
import org.apache.batchee.container.proxy.StepListenerProxy;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.util.PartitionDataWrapper;
import org.apache.batchee.jaxb.Collector;
import org.apache.batchee.jaxb.Property;
import org.apache.batchee.jaxb.Step;
import org.apache.batchee.spi.BatchArtifactFactory;

public abstract class SingleThreadedStepController
extends BaseStepController
implements Controller {
    private final BatchArtifactFactory factory;
    protected PartitionCollectorProxy collectorProxy = null;
    List<StepListenerProxy> stepListeners = null;

    protected SingleThreadedStepController(RuntimeJobExecution jobExecutionImpl, Step step, StepContextImpl stepContext, long rootJobExecutionId, BlockingQueue<PartitionDataWrapper> analyzerStatusQueue, ServicesManager servicesManager) {
        super(jobExecutionImpl, step, stepContext, rootJobExecutionId, analyzerStatusQueue, servicesManager);
        this.factory = servicesManager.service(BatchArtifactFactory.class);
    }

    @Override
    protected void setupStepArtifacts() {
        Collector collector;
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, null);
        this.stepListeners = this.jobExecutionImpl.getListenerFactory().getStepListeners(this.step, injectionRef, this.stepContext, this.jobExecutionImpl);
        if (this.step.getPartition() != null && (collector = this.step.getPartition().getCollector()) != null) {
            List<Property> propList = collector.getProperties() == null ? null : collector.getProperties().getPropertyList();
            injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
            this.collectorProxy = ProxyFactory.createPartitionCollectorProxy(this.factory, collector.getRef(), injectionRef, this.stepContext, this.jobExecutionImpl);
        }
    }

    @Override
    protected void invokePreStepArtifacts() {
        if (this.stepListeners != null && this.jobExecutionImpl.getPartitionInstance() == null) {
            for (StepListenerProxy listenerProxy : this.stepListeners) {
                listenerProxy.beforeStep();
            }
        }
    }

    @Override
    protected void invokePostStepArtifacts() {
        if (this.stepListeners != null && this.jobExecutionImpl.getPartitionInstance() == null) {
            for (StepListenerProxy listenerProxy : this.stepListeners) {
                listenerProxy.afterStep();
            }
        }
    }

    protected void invokeCollectorIfPresent() {
        if (this.collectorProxy != null) {
            Serializable data = this.collectorProxy.collectPartitionData();
            this.sendCollectorDataToAnalyzerIfPresent(data);
        }
    }

    protected void sendCollectorDataToAnalyzerIfPresent(Serializable data) {
        if (this.analyzerStatusQueue != null) {
            PartitionDataWrapper dataWrapper = new PartitionDataWrapper();
            dataWrapper.setCollectorData(data);
            dataWrapper.setEventType(PartitionDataWrapper.PartitionEventType.ANALYZE_COLLECTOR_DATA);
            this.analyzerStatusQueue.add(dataWrapper);
        }
    }

    @Override
    protected void sendStatusFromPartitionToAnalyzerIfPresent() {
        if (this.analyzerStatusQueue != null) {
            PartitionDataWrapper dataWrapper = new PartitionDataWrapper();
            dataWrapper.setBatchStatus(this.stepStatus.getBatchStatus());
            dataWrapper.setExitStatus(this.stepStatus.getExitStatus());
            dataWrapper.setEventType(PartitionDataWrapper.PartitionEventType.ANALYZE_STATUS);
            this.analyzerStatusQueue.add(dataWrapper);
        }
    }
}

