/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller;

import java.util.List;
import javax.batch.runtime.StepExecution;
import org.apache.batchee.container.ExecutionElementController;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.jsl.ExecutionElement;
import org.apache.batchee.container.proxy.DeciderProxy;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.container.proxy.ProxyFactory;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.status.ExecutionStatus;
import org.apache.batchee.container.status.ExtendedBatchStatus;
import org.apache.batchee.jaxb.Decision;
import org.apache.batchee.jaxb.Property;
import org.apache.batchee.spi.BatchArtifactFactory;
import org.apache.batchee.spi.PersistenceManagerService;

public class DecisionController
implements ExecutionElementController {
    private RuntimeJobExecution jobExecution;
    private Decision decision;
    private StepExecution[] previousStepExecutions = null;
    private final PersistenceManagerService persistenceService;
    private final BatchArtifactFactory factory;

    public DecisionController(RuntimeJobExecution jobExecution, Decision decision, ServicesManager manager) {
        this.jobExecution = jobExecution;
        this.decision = decision;
        this.persistenceService = manager.service(PersistenceManagerService.class);
        this.factory = manager.service(BatchArtifactFactory.class);
    }

    @Override
    public ExecutionStatus execute() {
        String deciderId = this.decision.getRef();
        List<Property> propList = this.decision.getProperties() == null ? null : this.decision.getProperties().getPropertyList();
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecution.getJobContext(), null, propList);
        DeciderProxy deciderProxy = ProxyFactory.createDeciderProxy(this.factory, deciderId, injectionRef, this.jobExecution);
        String exitStatus = deciderProxy.decide(this.previousStepExecutions);
        this.jobExecution.getJobContext().setExitStatus(exitStatus);
        return new ExecutionStatus(ExtendedBatchStatus.NORMAL_COMPLETION, exitStatus);
    }

    protected void setPreviousStepExecutions(ExecutionElement previousExecutionElement, ExecutionElementController previousElementController) {
        if (previousExecutionElement != null && previousExecutionElement instanceof Decision) {
            throw new BatchContainerRuntimeException("A decision cannot precede another decision.");
        }
        List<Long> previousStepExecsIds = previousElementController.getLastRunStepExecutions();
        StepExecution[] stepExecArray = new StepExecution[previousStepExecsIds.size()];
        for (int i = 0; i < stepExecArray.length; ++i) {
            StepExecution stepExec;
            stepExecArray[i] = stepExec = this.persistenceService.getStepExecutionByStepExecutionId(previousStepExecsIds.get(i));
        }
        this.previousStepExecutions = stepExecArray;
    }

    @Override
    public void stop() {
    }

    @Override
    public List<Long> getLastRunStepExecutions() {
        return null;
    }
}

