/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jaxrs.server;

import jakarta.annotation.PostConstruct;
import jakarta.batch.operations.JobOperator;
import jakarta.batch.runtime.BatchRuntime;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.batchee.jaxrs.common.JBatchResource;
import org.apache.batchee.jaxrs.common.RestJobExecution;
import org.apache.batchee.jaxrs.common.RestJobInstance;
import org.apache.batchee.jaxrs.common.RestProperties;
import org.apache.batchee.jaxrs.common.RestStepExecution;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="batchee")
public class JBatchResourceImpl
implements JBatchResource {
    private JobOperator operator;

    @PostConstruct
    public void findOperator() {
        this.operator = BatchRuntime.getJobOperator();
    }

    @GET
    @Path(value="job-names")
    public String[] getJobNames() {
        Set jobNames = this.operator.getJobNames();
        return jobNames.toArray(new String[jobNames.size()]);
    }

    @GET
    @Path(value="job-instance/count/{name}")
    @Produces(value={"text/plain"})
    public int getJobInstanceCount(@PathParam(value="name") String jobName) {
        return this.operator.getJobInstanceCount(jobName);
    }

    @GET
    @Path(value="job-instances/{name}")
    public RestJobInstance[] getJobInstances(@PathParam(value="name") String jobName, @QueryParam(value="start") int start, @QueryParam(value="count") int count) {
        List restJobInstances = RestJobInstance.wrap((List)this.operator.getJobInstances(jobName, start, count));
        return restJobInstances.toArray(new RestJobInstance[restJobInstances.size()]);
    }

    @GET
    @Path(value="executions/running/{name}")
    public Long[] getRunningExecutions(@PathParam(value="name") String jobName) {
        List runningExecutions = this.operator.getRunningExecutions(jobName);
        return runningExecutions.toArray(runningExecutions.toArray(new Long[runningExecutions.size()]));
    }

    @GET
    @Path(value="execution/parameter/{id}")
    public RestProperties getParameters(@PathParam(value="id") long executionId) {
        return RestProperties.wrap((Properties)this.operator.getParameters(executionId));
    }

    @GET
    @Path(value="job-instance/{id}")
    public RestJobInstance getJobInstance(@PathParam(value="id") long executionId) {
        return RestJobInstance.wrap((JobInstance)this.operator.getJobInstance(executionId));
    }

    @GET
    @Path(value="job-executions/{id}/{name}")
    public RestJobExecution[] getJobExecutions(@PathParam(value="id") long id, @PathParam(value="name") String name) {
        List restJobExecutions = RestJobExecution.wrap((List)this.operator.getJobExecutions((JobInstance)new JobInstanceImpl(name, id)));
        return restJobExecutions.toArray(new RestJobExecution[restJobExecutions.size()]);
    }

    @GET
    @Path(value="job-execution/{id}")
    public RestJobExecution getJobExecution(@PathParam(value="id") long executionId) {
        return RestJobExecution.wrap((JobExecution)this.operator.getJobExecution(executionId));
    }

    @GET
    @Path(value="step-executions/{id}")
    public RestStepExecution[] getStepExecutions(@PathParam(value="id") long jobExecutionId) {
        List restStepExecutions = RestStepExecution.wrap((List)this.operator.getStepExecutions(jobExecutionId));
        return restStepExecutions.toArray(new RestStepExecution[restStepExecutions.size()]);
    }

    @POST
    @Path(value="execution/start/{name}")
    @Produces(value={"text/plain"})
    public long start(@PathParam(value="name") String jobXMLName, RestProperties jobParameters) {
        return this.operator.start(jobXMLName, RestProperties.unwrap((RestProperties)jobParameters));
    }

    @POST
    @Path(value="execution/restart/{id}")
    @Produces(value={"text/plain"})
    public long restart(@PathParam(value="id") long executionId, RestProperties restartParameters) {
        return this.operator.restart(executionId, RestProperties.unwrap((RestProperties)restartParameters));
    }

    @HEAD
    @Path(value="execution/stop/{id}")
    public void stop(@PathParam(value="id") long executionId) {
        this.operator.stop(executionId);
    }

    @HEAD
    @Path(value="execution/abandon/{id}")
    public void abandon(@PathParam(value="id") long executionId) {
        this.operator.abandon(executionId);
    }

    private static class JobInstanceImpl
    implements JobInstance {
        private final String name;
        private final long id;

        public JobInstanceImpl(String name, long id) {
            this.name = name;
            this.id = id;
        }

        public long getInstanceId() {
            return this.id;
        }

        public String getJobName() {
            return this.name;
        }
    }
}

