/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jaxrs.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class ClientSslConfiguration {
    private String hostnameVerifier = null;
    private String keystorePassword = null;
    private String keystoreType = "JKS";
    private String keystorePath = null;
    private String sslContextType = "TLS";
    private String keyManagerType = "SunX509";
    private String keyManagerPath = null;
    private String trustManagerAlgorithm = null;
    private String trustManagerProvider = null;

    public HostnameVerifier getHostnameVerifier() {
        return (HostnameVerifier)HostnameVerifier.class.cast(ClientSslConfiguration.load(this.hostnameVerifier));
    }

    private static Class<?> load(String name) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setHostnameVerifier(String hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLContext getSslContext() {
        SSLContext context;
        try {
            KeyManager[] km;
            context = SSLContext.getInstance(this.sslContextType);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.keyManagerType);
            if (this.keyManagerPath != null) {
                InputStream fin = ClientSslConfiguration.findInputStream(this.keyManagerPath);
                KeyStore ks = KeyStore.getInstance(this.keystoreType);
                ks.load(fin, this.keystorePassword.toCharArray());
                km = kmf.getKeyManagers();
            } else {
                km = null;
            }
            TrustManager[] tm = this.trustManagerAlgorithm != null ? (this.trustManagerProvider != null ? TrustManagerFactory.getInstance(this.trustManagerAlgorithm, this.trustManagerProvider).getTrustManagers() : TrustManagerFactory.getInstance(this.trustManagerAlgorithm).getTrustManagers()) : null;
            context.init(km, tm, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return context;
    }

    public KeyStore getKeystore() {
        try {
            KeyStore keystore = KeyStore.getInstance(this.keystoreType);
            InputStream is = ClientSslConfiguration.findInputStream(this.keystorePath);
            if (is != null) {
                try {
                    keystore.load(is, this.keystorePassword.toCharArray());
                }
                finally {
                    is.close();
                }
            }
            return keystore;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    private static InputStream findInputStream(String path) throws FileNotFoundException {
        File file = new File(path);
        if (file.isFile()) {
            return new FileInputStream(file);
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public void setSslContextType(String sslContextType) {
        this.sslContextType = sslContextType;
    }

    public void setKeyManagerType(String keyManagerType) {
        this.keyManagerType = keyManagerType;
    }

    public void setKeyManagerPath(String keyManagerPath) {
        this.keyManagerPath = keyManagerPath;
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = trustManagerAlgorithm;
    }

    public void setTrustManagerProvider(String trustManagerProvider) {
        this.trustManagerProvider = trustManagerProvider;
    }
}

